/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.util.Data;
import com.spacekiller.util.swing.WindowManager;
import java.awt.AWTEventMulticaster;
import java.awt.Frame;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class InfectionWindowManager
implements WindowManager {
    private List windowList = new ArrayList();
    private WindowHandler windowHandler = new WindowHandler();
    private transient WindowListener windowListeners;
    private static final Logger logger = Logger.getLogger(InfectionWindowManager.class.getName());
    private Method isWindowOpaqueMethod;
    private Method setWindowOpaqueMethod;
    private Method getWindowOpacityMethod;
    private Method setWindowOpacityMethod;
    private Method getWindowShapeMethod;
    private Method setWindowShapeMethod;

    public InfectionWindowManager() {
        this.initInfectionWindowManager();
        this.refreshWindowList();
    }

    protected void initInfectionWindowManager() {
        Class<?> classAWTUtilities = null;
        try {
            classAWTUtilities = Class.forName("com.sun.awt.AWTUtilities");
        }
        catch (ClassNotFoundException e) {
            logger.fine("AWTUtilities class not found.");
        }
        if (classAWTUtilities != null) {
            try {
                this.isWindowOpaqueMethod = classAWTUtilities.getMethod("isWindowOpaque", Window.class);
                this.setWindowOpaqueMethod = classAWTUtilities.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
                this.getWindowOpacityMethod = classAWTUtilities.getMethod("getWindowOpacity", Window.class);
                this.setWindowOpacityMethod = classAWTUtilities.getMethod("setWindowOpacity", Window.class, Float.TYPE);
                this.getWindowShapeMethod = classAWTUtilities.getMethod("getWindowShape", Window.class);
                this.setWindowShapeMethod = classAWTUtilities.getMethod("setWindowShape", Window.class, Shape.class);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public Window[] getWindowArray() {
        return this.windowList.toArray(new Window[this.windowList.size()]);
    }

    public Window getWindowAt(int i) {
        return (Window)this.windowList.get(i);
    }

    public int getWindowCount() {
        return this.windowList.size();
    }

    public void refreshWindowList() {
        ArrayList<Window> wins = new ArrayList<Window>();
        Frame[] frames = Frame.getFrames();
        if (frames != null) {
            for (int i = 0; i < frames.length; ++i) {
                Frame frame = frames[i];
                if (frame == null) continue;
                wins.add(frame);
            }
        }
        try {
            Object arr;
            Method meth = Window.class.getMethod("getOwnerlessWindows", new Class[0]);
            if (meth != null && (arr = meth.invoke(null, new Object[0])) != null && arr instanceof Window[]) {
                Window[] warr = (Window[])arr;
                for (int i = 0; i < warr.length; ++i) {
                    Window win = warr[i];
                    if (win == null) continue;
                    wins.add(win);
                }
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        for (Window win : wins) {
            this.checkWindow(win);
            boolean exists = this.windowList.contains(win);
            if (win.isVisible()) {
                if (exists) continue;
                this.windowList.add(win);
                win.addWindowListener(this.windowHandler);
                continue;
            }
            if (!exists) continue;
            this.windowList.remove(win);
            win.removeWindowListener(this.windowHandler);
        }
    }

    protected void checkWindow(Window win) {
        JFrame frame;
        int dco;
        if (win instanceof JFrame && (dco = (frame = (JFrame)win).getDefaultCloseOperation()) == 3) {
            frame.setDefaultCloseOperation(2);
        }
    }

    protected void fireWindowOpened(WindowEvent e) {
        if (this.windowListeners == null) {
            return;
        }
        this.windowListeners.windowOpened(e);
    }

    protected void fireWindowClosing(WindowEvent e) {
        if (this.windowListeners == null) {
            return;
        }
        this.windowListeners.windowClosing(e);
    }

    protected void fireWindowClosed(WindowEvent e) {
        if (this.windowListeners == null) {
            return;
        }
        this.windowListeners.windowClosed(e);
    }

    protected void fireWindowIconified(WindowEvent e) {
        if (this.windowListeners == null) {
            return;
        }
        this.windowListeners.windowIconified(e);
    }

    protected void fireWindowDeiconified(WindowEvent e) {
        if (this.windowListeners == null) {
            return;
        }
        this.windowListeners.windowDeiconified(e);
    }

    protected void fireWindowActivated(WindowEvent e) {
        if (this.windowListeners == null) {
            return;
        }
        this.windowListeners.windowActivated(e);
    }

    protected void fireWindowDeactivated(WindowEvent e) {
        if (this.windowListeners == null) {
            return;
        }
        this.windowListeners.windowDeactivated(e);
    }

    public void addWindowListener(WindowListener listener) {
        this.windowListeners = AWTEventMulticaster.add(this.windowListeners, listener);
    }

    public void removeWindowListener(WindowListener listener) {
        this.windowListeners = AWTEventMulticaster.remove(this.windowListeners, listener);
    }

    protected WindowListener[] getWindowListeners() {
        return (WindowListener[])AWTEventMulticaster.getListeners((EventListener)this.windowListeners, WindowListener.class);
    }

    public void closeWindow(Window window) {
        WindowEvent ev = new WindowEvent(window, 201);
        window.dispatchEvent(ev);
    }

    public void disposeWindow(Window window) {
        window.dispose();
    }

    public boolean isWindowOpaque(Window window) throws Exception {
        if (this.isWindowOpaqueMethod != null) {
            Object result = this.isWindowOpaqueMethod.invoke(null, window);
            return (Boolean)result;
        }
        throw new UnsupportedOperationException();
    }

    public void setWindowOpaque(Window window, boolean opaque) throws Exception {
        if (this.setWindowOpaqueMethod != null) {
            this.setWindowOpaqueMethod.invoke(null, window, opaque ? Boolean.TRUE : Boolean.FALSE);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public float getWindowOpacity(Window window) throws Exception {
        if (this.getWindowOpacityMethod != null) {
            Object result = this.getWindowOpacityMethod.invoke(null, window);
            return ((Float)result).floatValue();
        }
        throw new UnsupportedOperationException();
    }

    public void setWindowOpacity(Window window, float opacity) throws Exception {
        if (this.setWindowOpacityMethod != null) {
            this.setWindowOpacityMethod.invoke(null, window, Data.toFloat((float)opacity));
            return;
        }
        throw new UnsupportedOperationException();
    }

    public Shape getWindowShape(Window window) throws Exception {
        if (this.getWindowShapeMethod != null) {
            Object result = this.getWindowShapeMethod.invoke(null, window);
            return (Shape)result;
        }
        throw new UnsupportedOperationException();
    }

    public void setWindowShape(Window window, Shape shape) throws Exception {
        if (this.setWindowShapeMethod != null) {
            this.setWindowShapeMethod.invoke(null, window, shape);
            return;
        }
        throw new UnsupportedOperationException();
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            InfectionWindowManager.this.refreshWindowList();
            InfectionWindowManager.this.fireWindowActivated(e);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            InfectionWindowManager.this.refreshWindowList();
            InfectionWindowManager.this.fireWindowDeactivated(e);
        }

        @Override
        public void windowOpened(WindowEvent e) {
            InfectionWindowManager.this.refreshWindowList();
            InfectionWindowManager.this.fireWindowOpened(e);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            InfectionWindowManager.this.refreshWindowList();
            InfectionWindowManager.this.fireWindowClosed(e);
        }

        @Override
        public void windowIconified(WindowEvent e) {
            InfectionWindowManager.this.refreshWindowList();
            InfectionWindowManager.this.fireWindowIconified(e);
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            InfectionWindowManager.this.refreshWindowList();
            InfectionWindowManager.this.fireWindowDeiconified(e);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            InfectionWindowManager.this.refreshWindowList();
            InfectionWindowManager.this.fireWindowClosing(e);
        }
    }
}

