/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.platform.InfectionFrame;
import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.platform.InfectionPreferencesConstants;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.BackgroundPanel;
import com.spacekiller.util.swing.LookAndFeelManager;
import com.spacekiller.util.swing.WindowManager;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.DefaultPerspective;
import com.spacekiller.util.workbench.DefaultWorkbench;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workspace.Project;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class InfectionWorkbench
extends DefaultWorkbench
implements InfectionPreferencesConstants {
    public static final String PROPERTY_PARENT_COMPONENT = "infection.parent.component";
    public static final String KEY_WINDOW_BOUNDS = "window.bounds";
    public static final String KEY_ACTIVE_PERSPECTIVE = "active.perspective";
    private Container parentContainer;
    private JRootPane rootPane;
    private static final Logger logger = Logger.getLogger(InfectionWorkbench.class.getName());

    public InfectionWorkbench() {
        this.initInfectionWorkbench();
    }

    protected void initInfectionWorkbench() {
        RuntimeContext rtc = Platform.getInstance().getRuntimeContext();
        this.setRuntimeContext(rtc);
        Object parent = null;
        try {
            InfectionRuntime runtime = Infection.getInstance().getInfectionRuntime();
            if (runtime != null) {
                parent = runtime.getProperty(PROPERTY_PARENT_COMPONENT);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (parent != null && parent instanceof Window) {
            this.parentContainer = (Window)parent;
        }
        Platform.getInstance().debugReference((Object)this);
    }

    protected Window createWindow() {
        Window window = null;
        if (this.parentContainer == null) {
            InfectionFrame frame = new InfectionFrame((Workbench)this);
            window = frame;
            frame.addWindowListener((WindowListener)this.getWindowHandler());
            frame.setContentPane(this.getContentPane());
            frame.setSize(800, 650);
            Tools.centerWindow((Window)frame);
            Platform plat = null;
            try {
                Object obj;
                plat = Platform.getInstance();
                PreferencesRegistry reg = plat.getPreferencesRegistry();
                Preferences prefs = reg.getPreferences("platform.workbench");
                if (prefs != null && (obj = prefs.getObject(KEY_WINDOW_BOUNDS)) != null && obj instanceof Rectangle) {
                    Rectangle bounds = (Rectangle)obj;
                    frame.setBounds(bounds);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            String title = plat.getApplicationTitle();
            if (title == null) {
                title = "N/A";
            }
            frame.setInfectionTitle(title);
            Image iconImage = null;
            try {
                if (plat instanceof InfectionPlatform) {
                    iconImage = ((InfectionPlatform)plat).getDistributionResourceImage("icon16");
                }
                if (iconImage != null) {
                    frame.setInfectionIconImage(iconImage);
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            Tools.ensureWindowFitsScreen((Window)frame);
        } else {
            window = (Window)this.parentContainer;
            logger.fine("Using embedded window: " + window);
            window.removeAll();
            window.setLayout(new GridLayout(1, 1));
            this.rootPane = new JRootPane();
            this.rootPane.setLayout(new BorderLayout());
            Panel panel = new Panel();
            panel.setBackground(null);
            panel.setLayout(new GridLayout(1, 1));
            panel.add(this.rootPane);
            window.add(panel);
            window.validate();
            window.repaint();
        }
        LookAndFeelManager lafManager = LookAndFeelManager.getInstance();
        if (lafManager != null) {
            lafManager.registerComponent((Component)window);
        }
        return window;
    }

    protected synchronized Window getWindow() {
        return super.getWindow();
    }

    protected void installContentPane(Perspective newPerspective) {
        if (this.rootPane == null) {
            super.installContentPane(newPerspective);
        } else {
            logger.fine("installContentPane into: " + this.parentContainer);
            Component content = newPerspective.getComponent();
            if (content != null) {
                JPanel background = new JPanel();
                background.setOpaque(true);
                background.setBackground(Color.blue.brighter());
                background.setLayout(new GridLayout(1, 1));
                background.add(content);
                this.rootPane.add((Component)background, "Center");
                this.rootPane.validate();
                this.rootPane.repaint();
            }
        }
    }

    protected void refreshMenuBar() {
        this.getWindow();
        if (this.rootPane == null) {
            super.refreshMenuBar();
        } else {
            logger.fine("installMenuBar into: " + this.parentContainer);
            boolean showMenuBar = false;
            ToolGroup group = this.getMenuGroup();
            if (group != null && group.getChildCount() > 0) {
                showMenuBar = true;
            }
            if (showMenuBar) {
                JMenuBar bar = this.getMenuBar();
                if (bar != null) {
                    this.rootPane.add((Component)bar, "North");
                    this.rootPane.validate();
                    this.rootPane.repaint();
                }
            } else {
                JMenuBar bar = this.getMenuBar();
                if (bar != null) {
                    this.rootPane.remove(bar);
                    this.rootPane.validate();
                    this.rootPane.repaint();
                }
            }
        }
    }

    public void refresh() {
        try {
            this.refreshInternal();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        super.refresh();
    }

    protected synchronized void refreshInternal() throws Exception {
        String disableWindowAnimation;
        Window window;
        boolean backTypeCustom = false;
        String backFilePath = null;
        boolean backStretch = false;
        boolean alwaysOnTop = false;
        boolean autoHideDetached = false;
        boolean windowAnimation = false;
        try {
            PreferencesRegistry reg = Platform.getInstance().getPreferencesRegistry();
            if (reg == null) {
                return;
            }
            Preferences prefs = reg.getPreferences("platform.workbench");
            if (prefs != null) {
                String str;
                String stretch;
                String backType = (String)prefs.getObject("background.type");
                backTypeCustom = false;
                if (backType != null && backType.equals("custom")) {
                    backTypeCustom = true;
                }
                if ((backFilePath = (String)prefs.getObject("background.file")) == null || backFilePath.length() < 1) {
                    backTypeCustom = false;
                }
                if ((stretch = (String)prefs.getObject("background.stretch")) != null) {
                    backStretch = new Boolean(stretch);
                }
                if ((str = (String)prefs.getObject("window.alwaysOnTop")) != null) {
                    alwaysOnTop = new Boolean(str);
                }
                if ((str = (String)prefs.getObject("window.audioHideDetachedViews")) != null) {
                    autoHideDetached = new Boolean(str);
                }
                if ((str = (String)prefs.getObject("window.animation")) != null) {
                    windowAnimation = new Boolean(str);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        File file = null;
        if (backFilePath != null && backFilePath.length() > 0) {
            file = new File(backFilePath);
        }
        if ((window = this.getWindow()) != null) {
            try {
                Method methSetAlwaysOnTop = Window.class.getMethod("setAlwaysOnTop", Boolean.TYPE);
                methSetAlwaysOnTop.invoke((Object)window, alwaysOnTop ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((disableWindowAnimation = System.getProperty("infection.disable.window.animation")) != null && "true".equalsIgnoreCase(disableWindowAnimation)) {
            windowAnimation = false;
        }
        int persCount = this.getPerspectiveCount();
        for (int i = 0; i < persCount; ++i) {
            Perspective pers = this.getPerspectiveAt(i);
            if (pers == null || !(pers instanceof DefaultPerspective)) continue;
            DefaultPerspective defPers = (DefaultPerspective)pers;
            defPers.setAutoHideDetachedViews(autoHideDetached);
            defPers.setWindowAnimationEnabled(windowAnimation);
            defPers.setCustomBackgroundEnabled(backTypeCustom);
            String backURL = null;
            if (file != null) {
                backURL = file.toURI().toURL().toString();
            }
            defPers.setCustomBackgroundStretch(backStretch);
            defPers.setCustomBackgroundURL(backURL);
        }
    }

    protected void savePreferences() {
        super.savePreferences();
        Platform plat = Platform.getInstance();
        PreferencesRegistry reg = plat.getPreferencesRegistry();
        if (reg == null) {
            return;
        }
        try {
            Perspective activePers;
            Window win;
            logger.fine("Saving workbench preferences...");
            Preferences prefs = reg.getPreferences("platform.workbench");
            if (prefs == null) {
                prefs = reg.createPreferences("platform.workbench");
            }
            if ((win = this.getWindow()) != null) {
                Rectangle bounds = win.getBounds();
                prefs.setObject(KEY_WINDOW_BOUNDS, (Object)bounds);
            }
            String activePersName = (activePers = this.getPerspective()) == null ? null : activePers.getName();
            prefs.setObject(KEY_ACTIVE_PERSPECTIVE, (Object)activePersName);
            reg.savePreferences(prefs);
            int persCount = this.getPerspectiveCount();
            for (int c = 0; c < persCount; ++c) {
                Perspective pers = this.getPerspectiveAt(c);
                if (pers == null) continue;
                logger.fine("Saving perspective: " + pers);
                try {
                    String persName = pers.getName();
                    String prefsKey = "perspective." + persName;
                    Preferences persPrefs = reg.getPreferences(prefsKey);
                    if (persPrefs == null) {
                        persPrefs = reg.createPreferences(prefsKey);
                    }
                    pers.savePreferences(persPrefs);
                    reg.savePreferences(persPrefs);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            logger.fine("Saved workbench preferences.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void saveProjectReferences() {
        super.saveProjectReferences();
        Workspace ws = this.getWorkspace();
        if (ws == null) {
            return;
        }
        Platform plat = Platform.getInstance();
        PreferencesRegistry reg = plat.getPreferencesRegistry();
        if (reg == null) {
            return;
        }
        logger.fine("Enumerate project references: " + ws.size());
        ArrayList<ProjectReference> projectRefs = new ArrayList<ProjectReference>();
        for (Object proj : ws) {
            Project project;
            ProjectReference ref;
            if (proj == null || !(proj instanceof Project) || (ref = (project = (Project)proj).getProjectReference()) == null) continue;
            String name = ref.getProjectName();
            Object path = ref.getProjectPath();
            logger.fine("Project reference: " + ref + " => " + path);
            if (path == null || name == null) continue;
            int index = -1;
            int num = projectRefs.size();
            for (int j = 0; j < num; ++j) {
                ProjectReference x = (ProjectReference)projectRefs.get(j);
                if (name.compareTo(x.getProjectName()) >= 0) continue;
                index = j;
                break;
            }
            if (index < 0) {
                projectRefs.add(ref);
                continue;
            }
            projectRefs.add(index, ref);
        }
        try {
            SyncManager sync = ws.getSyncManager();
            if (sync != null && sync.isActivated()) {
                logger.fine("Saving project references: " + projectRefs.size());
                String databaseURL = sync.getDatabaseURL();
                String databaseUser = sync.getDatabaseUser();
                String prefsKey = "platform.workspace." + databaseUser + "." + databaseURL;
                Preferences prefs = reg.getPreferences(prefsKey);
                if (prefs == null) {
                    prefs = reg.createPreferences(prefsKey);
                }
                prefs.setObject("projectReferences", projectRefs);
                reg.savePreferences(prefs);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected List loadProjectReferences() {
        Workspace ws;
        ArrayList list = new ArrayList();
        List superList = super.loadProjectReferences();
        if (superList != null) {
            list.addAll(superList);
        }
        if ((ws = this.getWorkspace()) == null) {
            return list;
        }
        Platform plat = Platform.getInstance();
        PreferencesRegistry reg = plat.getPreferencesRegistry();
        if (reg == null) {
            return list;
        }
        try {
            SyncManager sync = ws.getSyncManager();
            if (sync != null) {
                Object objProjectRefs;
                String databaseURL = sync.getDatabaseURL();
                String databaseUser = sync.getDatabaseUser();
                String prefsKey = "platform.workspace." + databaseUser + "." + databaseURL;
                Preferences prefs = reg.getPreferences(prefsKey);
                if (prefs != null && (objProjectRefs = prefs.getObject("projectReferences")) != null && objProjectRefs instanceof Collection) {
                    Collection refs = (Collection)objProjectRefs;
                    list.addAll(refs);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return list;
    }

    protected void disposeWindow(Window window) {
        try {
            InfectionPlatform plat = InfectionPlatform.getInfectionPlatform();
            boolean windowAnimation = true;
            try {
                String str;
                Preferences prefs;
                PreferencesRegistry reg = plat.getPreferencesRegistry();
                if (reg != null && (prefs = reg.getPreferences("platform.workbench")) != null && (str = (String)prefs.getObject("window.animation")) != null) {
                    windowAnimation = new Boolean(str);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            String disableWindowAnimation = System.getProperty("infection.disable.window.animation");
            if (disableWindowAnimation != null && "true".equalsIgnoreCase(disableWindowAnimation)) {
                windowAnimation = false;
            }
            if (!windowAnimation) {
                super.disposeWindow(window);
                return;
            }
            logger.fine("Performing window close animation...");
            WindowManager windowManager = plat.getWindowManager();
            GraphicsConfiguration gc = window.getGraphicsConfiguration();
            GraphicsDevice gd = gc.getDevice();
            Rectangle bounds = window.getBounds();
            window.getGraphicsConfiguration().getDevice();
            Robot robot = new Robot(gd);
            BufferedImage bi = robot.createScreenCapture(bounds);
            BackgroundPanel back = new BackgroundPanel();
            back.setBackgroundImage((Image)bi);
            String title = null;
            if (window instanceof JFrame) {
                JFrame f = (JFrame)window;
                title = f.getTitle();
            }
            JDialog fadeWindow = new JDialog();
            fadeWindow.setTitle(title);
            fadeWindow.setUndecorated(true);
            fadeWindow.setBounds(bounds);
            fadeWindow.setContentPane((Container)back);
            windowManager.setWindowOpaque((Window)fadeWindow, false);
            fadeWindow.setVisible(true);
            window.setVisible(false);
            int steps = 20;
            int delay = 5;
            int initDelay = 0;
            WindowDisposer disposer = new WindowDisposer(windowManager, window, fadeWindow, steps);
            Thread hook = new Thread((Runnable)new WindowDisposerShutdownHook(disposer), "WindowDisposerShutdownHook");
            plat.addShutdownHook(hook);
            Timer timer = new Timer(delay, disposer);
            disposer.setTimer(timer);
            timer.setInitialDelay(initDelay);
            timer.setCoalesce(true);
            timer.setRepeats(true);
            timer.start();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            super.disposeWindow(window);
            return;
        }
    }

    protected static class WindowDisposerShutdownHook
    implements Runnable {
        WindowDisposer disposer;

        public WindowDisposerShutdownHook(WindowDisposer disposer) {
            this.disposer = disposer;
        }

        @Override
        public void run() {
            logger.fine("Waiting for window disposer...");
            try {
                this.disposer.join();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            logger.fine("WindowDisposer completed.");
        }
    }

    protected class WindowDisposer
    implements ActionListener {
        private WindowManager windowManager;
        private Window window;
        private Window fadewindow;
        private int steps;
        private int done;
        private Timer timer;

        public WindowDisposer(WindowManager windowManager, Window window, Window fadewindow, int steps) {
            this.windowManager = windowManager;
            this.window = window;
            this.fadewindow = fadewindow;
            this.steps = steps;
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("WindowDisposer.actionPerformed: done=" + this.done + ", steps=" + this.steps);
            }
            if (this.done < this.steps) {
                ++this.done;
                try {
                    this.windowManager.setWindowOpacity(this.fadewindow, 1.0f - (float)this.done / (float)this.steps);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    this.done = this.steps;
                }
            } else {
                this.notifyAll();
                this.timer.stop();
                this.fadewindow.dispose();
                this.window.dispose();
            }
        }

        protected void setTimer(Timer timer) {
            this.timer = timer;
        }

        protected synchronized void join() throws InterruptedException {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("Cannot join from EventDispatchThread!");
            }
            if (this.done < this.steps) {
                this.wait();
            }
        }
    }
}

