/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.platform.DefaultRuntimeContext;
import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.Balloon;
import com.spacekiller.util.swing.BalloonManager;
import com.spacekiller.util.swing.FadeablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;

public class PlatformRuntimeContext
extends DefaultRuntimeContext {
    private long minimumNotifyMillis = 2000L;
    private long defaultNotifyMillis = 10000L;
    private long maximumNotifyMillis = 86400000L;
    private Font defaultMessageFont;

    @Override
    public void notify(Object source, Object message, long millis) {
        BalloonManager bm = BalloonManager.getSharedInstance();
        if (bm == null) {
            super.notify(source, message, millis);
            return;
        }
        if (millis > this.maximumNotifyMillis) {
            millis = this.maximumNotifyMillis;
        }
        if (millis < this.minimumNotifyMillis) {
            millis = this.minimumNotifyMillis;
        }
        Component sourceComponent = null;
        int x = -1;
        int y = -1;
        if (source != null && source instanceof Component) {
            sourceComponent = (Component)source;
        }
        if (sourceComponent == null) {
            super.notify(source, message, millis);
            return;
        }
        if (x < 0) {
            x = sourceComponent.getWidth() - 1;
            y = sourceComponent.getHeight() - 1;
        }
        Balloon balloon = new Balloon();
        Component messageComponent = null;
        if (message != null && message instanceof Component) {
            messageComponent = (Component)message;
        }
        if (messageComponent == null) {
            String msgText = String.valueOf(message);
            if (message instanceof Throwable) {
                balloon.setForeground(Color.red);
                Throwable error = (Throwable)message;
                String msg = error.getMessage();
                if (msg != null && msg.length() > 0) {
                    msgText = msg;
                }
            }
            messageComponent = new JLabel(msgText);
            messageComponent.setFont(this.getDefaultMessageFont());
        }
        FadeablePanel fadePanel = new FadeablePanel();
        fadePanel.setBackground(null);
        fadePanel.setLayout((LayoutManager)new GridLayout(1, 1));
        fadePanel.add(messageComponent);
        balloon.add((Component)fadePanel);
        balloon.setSize(balloon.getPreferredSize());
        balloon.setAutoDisposeDelay(5000);
        bm.showBalloon(sourceComponent, balloon, x, y);
    }

    @Override
    public void notify(Object source, Object message) {
        this.notify(source, message, this.defaultNotifyMillis);
    }

    @Override
    public void notifyError(Object source, Throwable error) {
        this.notify(source, error);
    }

    @Override
    public void notifyError(Object source, Throwable error, long millis) {
        this.notify(source, error, millis);
    }

    protected Font createDefaultMessageFont() {
        return Tools.getDefaultFont();
    }

    protected Font getDefaultMessageFont() {
        if (this.defaultMessageFont == null) {
            this.setDefaultMessageFont(this.createDefaultMessageFont());
        }
        return this.defaultMessageFont;
    }

    protected void setDefaultMessageFont(Font defaultMessageFont) {
        this.defaultMessageFont = defaultMessageFont;
    }
}

