/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.platform.InfectionPreferencesConstants;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SoftwareUpdater
implements InfectionPreferencesConstants {
    private static final long MIN_INTERVAL = 60000L;
    private static SoftwareUpdater instance;
    private boolean autoUpdateEnabled = false;
    private long autoUpdateInterval = -1L;
    private boolean promptCheck = false;
    private boolean promptDownload = false;
    private boolean promptApply = false;
    private TimerTask timerTask;
    private long lastRunTime = 0L;
    private static final Logger logger;

    protected SoftwareUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SoftwareUpdater getInstance() {
        if (instance != null) return instance;
        Class<SoftwareUpdater> clazz = SoftwareUpdater.class;
        synchronized (SoftwareUpdater.class) {
            if (instance != null) return instance;
            instance = new SoftwareUpdater();
            instance.refresh();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isAutoUpdateEnabled() {
        return this.autoUpdateEnabled;
    }

    protected void setAutoUpdateEnabled(boolean autoUpdateEnabled) {
        this.autoUpdateEnabled = autoUpdateEnabled;
    }

    public long getAutoUpdateInterval() {
        return this.autoUpdateInterval;
    }

    protected void setAutoUpdateInterval(long autoUpdateInterval) {
        this.autoUpdateInterval = autoUpdateInterval;
    }

    public synchronized void refresh() {
        boolean newPromptApply;
        boolean newPromptDownload;
        boolean newPromptCheck;
        long newInterval;
        boolean newEnabled;
        block13: {
            newEnabled = false;
            newInterval = -1L;
            newPromptCheck = false;
            newPromptDownload = false;
            newPromptApply = false;
            boolean autoUpdateEnabled = false;
            try {
                InfectionPlatform ip = (InfectionPlatform)Platform.getInstance();
                autoUpdateEnabled = ip.isAutoSoftwareUpdateEnabled();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (autoUpdateEnabled) {
                try {
                    PreferencesRegistry reg = Platform.getInstance().getPreferencesRegistry();
                    Preferences prefs = reg.getPreferences("platform.update");
                    if (prefs == null) break block13;
                    try {
                        long last = prefs.getLong("lastAutoUpdate");
                        this.setLastRunTime(last);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    newEnabled = prefs.getBoolean("autoUpdateEnabled");
                    newInterval = prefs.getLong("autoUpdatePeriod");
                    newPromptCheck = prefs.getBoolean("promptCheck");
                    newPromptDownload = prefs.getBoolean("promptDownload");
                    newPromptApply = prefs.getBoolean("promptApply");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        this.setAutoUpdateEnabled(newEnabled);
        this.setAutoUpdateInterval(newInterval);
        this.setPromptCheck(newPromptCheck);
        this.setPromptDownload(newPromptDownload);
        this.setPromptApply(newPromptApply);
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (newEnabled) {
            Timer timer;
            long cms = System.currentTimeMillis();
            long nms = this.lastRunTime + newInterval;
            if (newInterval <= 1L) {
                nms = cms;
                newInterval = 86400000L;
            }
            if (nms <= cms) {
                nms = cms + 10000L;
            }
            if ((timer = Platform.getInstance().getTimer()) == null) {
                logger.warning("Warning: no default Timer is available!");
                return;
            }
            this.timerTask = new SoftwareUpdateTimerTask();
            Date firstTime = new Date(nms);
            long period = newInterval;
            if (period < 60000L) {
                period = 60000L;
            }
            timer.schedule(this.timerTask, firstTime, period);
            logger.info("Next software update scheduled: " + firstTime);
        }
    }

    public boolean isPromptApply() {
        return this.promptApply;
    }

    protected void setPromptApply(boolean promptApply) {
        this.promptApply = promptApply;
    }

    public boolean isPromptCheck() {
        return this.promptCheck;
    }

    protected void setPromptCheck(boolean promptCheck) {
        this.promptCheck = promptCheck;
    }

    public boolean isPromptDownload() {
        return this.promptDownload;
    }

    protected void setPromptDownload(boolean promptDownload) {
        this.promptDownload = promptDownload;
    }

    protected void performSoftwareUpdate() {
        InfectionPlatform ip;
        try {
            ip = (InfectionPlatform)Platform.getInstance();
            if (!ip.isAutoSoftwareUpdateEnabled()) {
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        long ms = System.currentTimeMillis();
        this.setLastRunTime(ms);
        try {
            PreferencesRegistry reg = Platform.getInstance().getPreferencesRegistry();
            Preferences prefs = reg.getPreferences("platform.update");
            if (prefs == null) {
                prefs = reg.createPreferences("platform.update");
            }
            prefs.setLong("lastAutoUpdate", ms);
            reg.savePreferences(prefs);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        logger.info("Running scheduled software update: " + new Date(ms));
        try {
            ip.startAutoSoftwareUpdate(this.isPromptCheck(), this.isPromptDownload(), this.isPromptApply());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public long getLastRunTime() {
        return this.lastRunTime;
    }

    protected void setLastRunTime(long lastRunTime) {
        this.lastRunTime = lastRunTime;
    }

    static {
        logger = Logger.getLogger(SoftwareUpdater.class.getName());
    }

    protected class SoftwareUpdateTimerTask
    extends TimerTask {
        protected SoftwareUpdateTimerTask() {
        }

        @Override
        public void run() {
            SoftwareUpdater.this.performSoftwareUpdate();
        }
    }
}

