/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform.legacy;

import com.spacekiller.util.Data;
import com.spacekiller.util.Preferences;
import java.beans.PropertyVetoException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LegacyPreferences
implements Preferences,
Serializable,
Externalizable {
    private static final long serialVersionUID = 980792389720937L;
    private Map preferences = new HashMap();

    public boolean getBoolean(String key) {
        return (Boolean)this.getObject(key);
    }

    public byte getByte(String key) {
        return (Byte)this.getObject(key);
    }

    public char getChar(String key) throws IllegalAccessException, InvocationTargetException {
        return ((Character)this.getObject(key)).charValue();
    }

    public double getDouble(String key) {
        return (Double)this.getObject(key);
    }

    public float getFloat(String key) {
        return ((Float)this.getObject(key)).floatValue();
    }

    public int getInt(String key) {
        return (Integer)this.getObject(key);
    }

    public long getLong(String key) {
        return (Long)this.getObject(key);
    }

    public Object getObject(String key) {
        return this.preferences.get(key);
    }

    public short getShort(String key) {
        return (Short)this.getObject(key);
    }

    public String[] propertyNames() {
        Set coll = this.preferences.keySet();
        return coll.toArray(new String[coll.size()]);
    }

    public boolean contains(String key) {
        return this.preferences.containsKey(key);
    }

    public void setBoolean(String key, boolean value) {
        this.setObject(key, Data.toBoolean((boolean)value));
    }

    public void setByte(String key, byte value) {
        this.setObject(key, Data.toByte((byte)value));
    }

    public void setChar(String key, char value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        this.setObject(key, Data.toCharacter((char)value));
    }

    public void setDouble(String key, double value) {
        this.setObject(key, Data.toDouble((double)value));
    }

    public void setFloat(String key, float value) {
        this.setObject(key, Data.toFloat((float)value));
    }

    public void setInt(String key, int value) {
        this.setObject(key, Data.toInteger((int)value));
    }

    public void setLong(String key, long value) {
        this.setObject(key, Data.toLong((long)value));
    }

    public void setShort(String key, short value) {
        this.setObject(key, Data.toShort((short)value));
    }

    public void setObject(String key, Object value) {
        if (key != null) {
            if (value == null) {
                this.preferences.remove(key);
            } else {
                this.preferences.put(key, value);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this.preferences.size());
        for (String key : this.preferences.keySet()) {
            Object value = this.preferences.get(key);
            out.writeUTF(key);
            out.writeObject(value);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte ver = in.readByte();
        int count = in.readInt();
        for (int c = 0; c < count; ++c) {
            String key = in.readUTF();
            Object value = in.readObject();
            this.preferences.put(key, value);
        }
        if (ver < 1) {
            return;
        }
    }
}

