/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform.legacy;

import com.spacekiller.infection.platform.legacy.LegacyPreferencesRegistry;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LegacyPreferencesMigrator {
    private static final Logger logger = Logger.getLogger(LegacyPreferencesMigrator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateLegacyPreferencesRegistry(File configDir, PreferencesRegistry target) throws Exception {
        String LEGACY_PREFSREGISTRY_FILENAME = "preferences.registry";
        File legacyFile = new File(configDir, LEGACY_PREFSREGISTRY_FILENAME);
        if (!legacyFile.exists()) {
            return;
        }
        logger.info("Migrating legacy preferences registry: " + legacyFile);
        LegacyPreferencesRegistry legacyReg = new LegacyPreferencesRegistry(legacyFile);
        try {
            String[] keys = legacyReg.getKeys();
            int numKeys = keys.length;
            logger.info("Migrating preferences: " + numKeys);
            int errorCount = 0;
            for (int i = 0; i < numKeys; ++i) {
                String key = keys[i];
                try {
                    int numProps;
                    Preferences prefs = legacyReg.verifyPreferences(key);
                    if (prefs == null) continue;
                    String[] propNames = prefs.propertyNames();
                    int n = numProps = propNames == null ? 0 : propNames.length;
                    if (numProps <= 0) continue;
                    Preferences targetPrefs = target.getPreferences(key);
                    if (targetPrefs == null) {
                        targetPrefs = target.createPreferences(key);
                    }
                    for (int k = 0; k < numProps; ++k) {
                        String propName = propNames[k];
                        try {
                            Object value = prefs.getObject(propName);
                            if (value == null) continue;
                            targetPrefs.setObject(propName, value);
                            continue;
                        }
                        catch (Throwable e) {
                            logger.severe("Failed to migrate preferences: " + key + ", propName=" + propName);
                            logger.log(Level.SEVERE, e.getMessage(), e);
                            ++errorCount;
                        }
                    }
                    target.savePreferences(targetPrefs);
                    continue;
                }
                catch (Throwable e) {
                    logger.severe("Failed to migrate preferences: " + key);
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    ++errorCount;
                }
            }
            logger.info("Migrated preferences: " + numKeys + ", error=" + errorCount);
        }
        finally {
            legacyReg.close();
        }
    }

    public void migrateLegacyPreferences(PreferencesRegistry reg) throws Exception {
        if (reg.containsKey("infection.softwareupdate")) {
            this.migrateLegacyPreferences01(reg);
        }
    }

    protected void migrateLegacyPreferences01(PreferencesRegistry reg) throws Exception {
        reg.removePreferences("platform.update");
        reg.removePreferences("platform.look-and-feel");
        String[][] mig = new String[][]{{"infection.softwareupdate", "platform.update"}, {"infection.lookAndFeel", "platform.look-and-feel"}, {"infection.workbench", "platform.workbench"}, {"infection.workspace", "platform.workspace"}, {"infection.instance", "platform.instance"}, {"infection.audio", "platform.audio"}, {"heap.manager", "heap-manager"}, {"media.manager", "media-manager"}, {"com.spacekiller.util.media.server.services", "media-server"}, {"infection.perspective.InfectionPerspective", "InfectionPerspective"}, {"infection.perspective.SpaceKillerPerspective", "SpaceKillerPerspective"}, {"infection.perspective.WaxLabPerspective", "WaxLabPerspective"}};
        int num = mig.length;
        for (int i = 0; i < num; ++i) {
            String oldKey = mig[i][0];
            String newKey = mig[i][1];
            this.renamePreferences(reg, oldKey, newKey);
        }
        this.renamePerspective(reg, "InfectionPerspective", "perspective.infection");
        this.renamePerspective(reg, "SpaceKillerPerspective", "perspective.spacekiller");
        this.renamePerspective(reg, "WaxLabPerspective", "perspective.waxmonster");
    }

    protected void renamePreferences(PreferencesRegistry reg, String oldKey, String newKey) {
        try {
            if (!reg.containsKey(oldKey)) {
                return;
            }
            if (reg.containsKey(newKey)) {
                return;
            }
            logger.info("renamePreferences: " + oldKey + " -> " + newKey);
            Preferences oldPrefs = reg.verifyPreferences(oldKey);
            if (oldPrefs == null) {
                return;
            }
            Preferences newPrefs = reg.createPreferences(newKey);
            this.copyPreferences(oldPrefs, newPrefs);
            reg.savePreferences(newPrefs);
            reg.removePreferences(oldKey);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void copyPreferences(Preferences oldPrefs, Preferences newPrefs) throws Exception {
        String[] names;
        for (String name : names = oldPrefs.propertyNames()) {
            newPrefs.setObject(name, oldPrefs.getObject(name));
        }
    }

    protected void renamePerspective(PreferencesRegistry reg, String oldKey, String newKey) {
        try {
            Object persName;
            if (!reg.containsKey(oldKey)) {
                return;
            }
            if (reg.containsKey(newKey)) {
                return;
            }
            logger.info("renamePerspective: " + oldKey + " -> " + newKey);
            this.renamePreferences(reg, oldKey, newKey);
            Preferences workbenchPrefs = reg.verifyPreferences("platform.workbench");
            if (workbenchPrefs != null && oldKey.equals(persName = workbenchPrefs.getObject("active.perspective"))) {
                workbenchPrefs.setObject("active.perspective", (Object)newKey);
                reg.savePreferences(workbenchPrefs);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

