/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform.legacy;

import com.spacekiller.infection.platform.legacy.LegacyPreferences;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LegacyPreferencesRegistry
implements PreferencesRegistry {
    private static final int FILE_MAGIC = 678687786;
    private static final int FILE_VERSION = 0;
    private static final int FILE_END = 876462343;
    private static final int TAG_ENTRY_INDEX = 142542644;
    private static final byte[] EMPTY_BUF = new byte[0];
    private static final int INDEX_HEADER_SIZE = 24;
    private File registryFile;
    private RandomAccessFile raf;
    private FileLock lock;
    private long length;
    private List indexes = new ArrayList();
    private int defaultIndexLength = 65536;
    private static final Logger logger = Logger.getLogger(LegacyPreferencesRegistry.class.getName());

    protected LegacyPreferencesRegistry(File regFile) throws Exception {
        this.setRegistryFile(regFile);
        boolean exists = regFile.exists();
        this.raf = new RandomAccessFile(regFile, "rw");
        this.lock = this.raf.getChannel().tryLock();
        if (this.lock == null) {
            this.raf.close();
            throw new Exception("Registry file is locked by another process: " + regFile);
        }
        if (exists) {
            this.loadPreferencesRegistry();
            this.length = this.raf.length();
        } else {
            this.writeHeader();
            this.length = this.raf.length();
        }
    }

    protected synchronized void loadPreferencesRegistry() throws Exception {
        this.indexes.clear();
        this.raf.seek(0L);
        int magic = this.raf.readInt();
        if (magic != 678687786) {
            throw new StreamCorruptedException("Invalid registry file: magic=" + magic + " != " + 678687786);
        }
        int version = this.raf.readInt();
        if (version != 0) {
            throw new StreamCorruptedException("Unsupported registry file: version=" + version + " != " + 0);
        }
        long o = this.raf.readLong();
        long pointer = this.raf.getFilePointer();
        if (o != 0L && o != pointer) {
            throw new StreamCorruptedException("Invalid first index offset: " + o + " != " + pointer);
        }
        while (o > 0L) {
            this.raf.seek(o);
            int tag = this.raf.readInt();
            long nextOfs = this.raf.readLong();
            if (nextOfs <= o && nextOfs != 0L) {
                throw new StreamCorruptedException("Invalid next page offset: " + nextOfs + " <= " + o);
            }
            switch (tag) {
                case 142542644: {
                    int numEntries = this.raf.readInt();
                    int indexLen = this.raf.readInt();
                    int bytesUsed = this.raf.readInt();
                    byte[] bytes = new byte[bytesUsed];
                    this.raf.readFully(bytes);
                    int avail = indexLen - bytesUsed;
                    Index index = new Index(o, indexLen, nextOfs, avail);
                    this.indexes.add(index);
                    ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
                    DataInputStream din = new DataInputStream(bin);
                    for (int i = 0; i < numEntries; ++i) {
                        String key = din.readUTF();
                        long entryOfs = din.readLong();
                        int entryLen = din.readInt();
                        Entry entry = new Entry(entryOfs, entryLen);
                        index.putEntry(key, entry);
                    }
                    din.close();
                    break;
                }
                case 876462343: {
                    break;
                }
                default: {
                    throw new StreamCorruptedException("Invalid tag: " + tag + " at offset " + o);
                }
            }
            if (tag == 876462343) break;
            o = nextOfs;
        }
    }

    protected File getRegistryFile() {
        return this.registryFile;
    }

    private void setRegistryFile(File registryFile) {
        this.registryFile = registryFile;
    }

    protected synchronized Entry getEntry(String key) throws Exception {
        int num = this.indexes.size();
        for (int c = 0; c < num; ++c) {
            Index index = (Index)this.indexes.get(c);
            Entry entry = index.getEntry(key);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public synchronized Preferences createPreferences(String key) throws Exception {
        if (key == null || key.length() < 1) {
            throw new Exception("Invalid preferences key: " + key);
        }
        Entry entry = this.getEntry(key);
        if (entry != null) {
            throw new Exception("Preferences already exist for key: " + key);
        }
        entry = this.createEntry(key);
        PreferencesImpl impl = new PreferencesImpl(key);
        return impl;
    }

    protected synchronized Entry createEntry(String key) throws Exception {
        long ofs = -1L;
        int len = 0;
        Entry entry = new Entry(ofs, len);
        int reqSpace = 26 + key.length() * 3;
        Index index = null;
        int numi = this.indexes.size();
        for (int c = numi - 1; c >= 0; --c) {
            Index x = (Index)this.indexes.get(c);
            if (x.available() < reqSpace) continue;
            index = x;
            break;
        }
        if (index == null) {
            index = this.allocateIndex(reqSpace);
        }
        index.putEntry(key, entry);
        this.writeIndex(index);
        return entry;
    }

    public String[] getKeys() {
        return this.getKeys("");
    }

    public synchronized String[] getKeys(String keyPrefix) {
        LinkedList<String> list = new LinkedList<String>();
        KeyEnumeration en = new KeyEnumeration(keyPrefix);
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            list.add(key);
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean containsKey(String key) throws Exception {
        return this.getEntry(key) != null;
    }

    public synchronized Preferences getPreferences(String key) throws Exception {
        try {
            return this.verifyPreferences(key);
        }
        catch (Exception e) {
            String msg = "Failed to load preferences for key: " + key;
            logger.log(Level.SEVERE, msg, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences verifyPreferences(String key) throws Exception {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        long ofs = entry.getOffset();
        int len = entry.getLength();
        byte[] buf = EMPTY_BUF;
        if (len > 0) {
            buf = new byte[len];
            this.raf.seek(ofs);
            this.raf.readFully(buf);
        }
        PreferencesImpl impl = new PreferencesImpl(key);
        if (len > 0) {
            ByteArrayInputStream bin = new ByteArrayInputStream(buf);
            try {
                ObjectInputStream oin = new ObjectInputStream(bin);
                impl.readExternal(oin);
            }
            finally {
                bin.close();
            }
        }
        return impl;
    }

    public void removePreferences(Preferences prefs) throws Exception {
        if (prefs instanceof PreferencesImpl) {
            PreferencesImpl impl = (PreferencesImpl)prefs;
            this.removePreferences(impl.getPrefKey());
        }
    }

    public synchronized void removePreferences(String key) throws Exception {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return;
        }
        Index index = this.getIndex(key);
        if (index == null) {
            return;
        }
        index.removeEntry(key);
        this.writeIndex(index);
    }

    public synchronized void close() throws Exception {
        if (this.lock != null) {
            this.lock.release();
            this.lock = null;
        }
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
        this.indexes = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected synchronized void writeHeader() throws Exception {
        this.raf.seek(0L);
        this.raf.writeInt(678687786);
        this.raf.writeInt(0);
        long firstIndexOfs = 0L;
        if (!this.indexes.isEmpty()) {
            Index first = (Index)this.indexes.get(0);
            firstIndexOfs = first.getOffset();
        }
        this.raf.writeLong(firstIndexOfs);
    }

    protected synchronized void writeIndexHeader(Index index) throws Exception {
        long ofs = index.getOffset();
        long nextOfs = index.getNextOffset();
        this.raf.seek(ofs);
        this.raf.writeInt(142542644);
        this.raf.writeLong(nextOfs);
    }

    protected synchronized void writeIndex(Index index) throws Exception {
        long ofs = index.getOffset();
        long nextOfs = index.getNextOffset();
        int indexLen = index.getLength();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        int numEntries = 0;
        Iterator i = index.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Entry entry = index.getEntry(key);
            if (entry == null) continue;
            dout.writeUTF(key);
            dout.writeLong(entry.offset);
            dout.writeInt(entry.length);
            ++numEntries;
        }
        dout.flush();
        bout.flush();
        byte[] bytes = bout.toByteArray();
        int newLen = bytes.length;
        if (newLen > indexLen) {
            throw new Exception("TODO index is full: " + index);
        }
        index.setAvailable(indexLen - newLen);
        this.raf.seek(ofs);
        this.raf.writeInt(142542644);
        this.raf.writeLong(nextOfs);
        this.raf.writeInt(numEntries);
        this.raf.writeInt(indexLen);
        this.raf.writeInt(bytes.length);
        this.raf.write(bytes);
    }

    protected synchronized void savePreferences(PreferencesImpl prefs) throws Exception {
        String key = prefs.getPrefKey();
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        prefs.writeExternal(oout);
        oout.flush();
        bout.flush();
        byte[] data = bout.toByteArray();
        long entryOfs = entry.getOffset();
        int entryLen = entry.getLength();
        if (entryLen != data.length) {
            entryOfs = this.allocate(data.length);
            entryLen = data.length;
            entry.setOffset(entryOfs);
            entry.setLength(entryLen);
            Index index = this.getIndex(key);
            this.writeIndex(index);
        }
        if (data.length > 0) {
            this.raf.seek(entryOfs);
            this.raf.write(data);
        }
    }

    protected Index getIndex(String key) {
        int num = this.indexes.size();
        for (int c = 0; c < num; ++c) {
            Index index = (Index)this.indexes.get(c);
            if (index.getEntry(key) == null) continue;
            return index;
        }
        return null;
    }

    protected synchronized long allocate(int len) {
        if (len <= 0) {
            return -1L;
        }
        long ofs = this.length;
        this.length += (long)len;
        return ofs;
    }

    protected synchronized Index allocateIndex(int minLen) throws Exception {
        int indexLen = Math.max(this.defaultIndexLength, minLen);
        long ofs = this.allocate(indexLen + 24);
        Index index = new Index(ofs, indexLen, 0L, indexLen);
        int num = this.indexes.size();
        this.indexes.add(index);
        if (num > 0) {
            Index last = (Index)this.indexes.get(num - 1);
            last.setNextOffset(ofs);
            this.writeIndexHeader(last);
        } else {
            this.writeHeader();
        }
        return index;
    }

    public void dumpPreferences(Preferences prefs, PrintStream out) throws Exception {
        out.println("Preferences: " + prefs);
        if (prefs == null) {
            return;
        }
        String[] keys = prefs.propertyNames();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Object value = prefs.getObject(key);
            out.println(" - " + key + " = " + value);
        }
    }

    public void savePreferences(Preferences prefs) throws Exception {
    }

    public void clearPreferences(Preferences prefs) throws Exception {
    }

    protected class PreferencesImpl
    extends LegacyPreferences {
        private String prefKey;

        public PreferencesImpl(String prefKey) {
            this.setPrefKey(prefKey);
        }

        @Override
        public synchronized void setObject(String key, Object value) {
            super.setObject(key, value);
            try {
                LegacyPreferencesRegistry.this.savePreferences(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected String getPrefKey() {
            return this.prefKey;
        }

        private void setPrefKey(String prefKey) {
            this.prefKey = prefKey;
        }
    }

    protected class KeyEnumeration
    implements Enumeration {
        private int index;
        private Iterator i;
        private String keyPrefix;
        private boolean hasNext;
        private String next;

        public KeyEnumeration(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            this.index = 0;
            this.i = null;
            if (this.index < LegacyPreferencesRegistry.this.indexes.size()) {
                this.i = ((Index)LegacyPreferencesRegistry.this.indexes.get(this.index)).getKeys();
            }
            this.scan();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext;
        }

        public Object nextElement() {
            String rc = this.next;
            this.scan();
            return rc;
        }

        private void scan() {
            while (this.i != null) {
                while (this.i.hasNext()) {
                    String k = (String)this.i.next();
                    if (!k.startsWith(this.keyPrefix)) continue;
                    this.hasNext = true;
                    this.next = k;
                    return;
                }
                ++this.index;
                if (this.index < LegacyPreferencesRegistry.this.indexes.size()) {
                    this.i = ((Index)LegacyPreferencesRegistry.this.indexes.get(this.index)).getKeys();
                    continue;
                }
                this.i = null;
                break;
            }
            this.hasNext = false;
        }
    }

    protected static class Entry {
        private long offset;
        private int length;

        public Entry(long ofs, int len) {
            this.setOffset(ofs);
            this.setLength(len);
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }
    }

    protected static class Index {
        private long offset;
        private int length;
        private long nextOffset;
        private int avail;
        private Map entries = new HashMap();

        public Index(long offset, int length, long nextOffset, int avail) {
            this.setOffset(offset);
            this.setLength(length);
            this.setNextOffset(nextOffset);
            this.setAvailable(avail);
        }

        public int getLength() {
            return this.length;
        }

        protected void setLength(int length) {
            this.length = length;
        }

        public long getNextOffset() {
            return this.nextOffset;
        }

        protected void setNextOffset(long nextOffset) {
            this.nextOffset = nextOffset;
        }

        public long getOffset() {
            return this.offset;
        }

        protected void setOffset(long offset) {
            this.offset = offset;
        }

        public Iterator getKeys() {
            return this.entries.keySet().iterator();
        }

        public Entry getEntry(String key) {
            return (Entry)this.entries.get(key);
        }

        public void putEntry(String key, Entry entry) {
            this.entries.put(key, entry);
        }

        public void removeEntry(String key) {
            this.entries.remove(key);
        }

        public int available() {
            return this.avail;
        }

        protected void setAvailable(int avail) {
            this.avail = avail;
        }
    }
}

