/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform.util;

import com.spacekiller.util.ClassDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Modifier;

public class ClassDescriptorImpl
implements ClassDescriptor,
Externalizable,
Serializable {
    private static final long serialVersionUID = 293902823232434L;
    private String className;
    private int modifiers;
    private int flags;
    private String outerClassName;
    private String superClassName;
    private String[] interfaceClassNames;

    public String getClassName() {
        return this.className;
    }

    public String[] getInterfaceClassNames() {
        return this.interfaceClassNames;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getOuterClassName() {
        return this.outerClassName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte ver = in.readByte();
        this.setClassName(in.readUTF());
        this.setModifiers(in.readInt());
        String s = in.readUTF();
        this.setOuterClassName(s.length() < 1 ? null : s);
        s = in.readUTF();
        this.setSuperClassName(s.length() < 1 ? null : s);
        int iCount = in.readInt();
        String[] iNames = new String[iCount];
        for (int i = 0; i < iCount; ++i) {
            iNames[i] = in.readUTF();
        }
        this.setInterfaceClassNames(iNames);
        if (ver < 1) {
            return;
        }
    }

    public void setClassName(String newClassName) {
        this.className = newClassName;
    }

    public void setInterfaceClassNames(String[] newInterfaceClassNames) {
        this.interfaceClassNames = newInterfaceClassNames;
    }

    public void setModifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    public void setOuterClassName(String newOuterClassName) {
        this.outerClassName = newOuterClassName;
    }

    public void setSuperClassName(String newSuperClassName) {
        this.superClassName = newSuperClassName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeUTF(this.getClassName());
        out.writeInt(this.getModifiers());
        String s = this.getOuterClassName();
        out.writeUTF(s == null ? "" : s);
        s = this.getSuperClassName();
        out.writeUTF(s == null ? "" : s);
        String[] iNames = this.getInterfaceClassNames();
        int iCount = iNames == null ? 0 : iNames.length;
        out.writeInt(iCount);
        for (int i = 0; i < iCount; ++i) {
            s = iNames[i];
            out.writeUTF(s == null ? "" : s);
        }
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isInnerClass() {
        return this.outerClassName != null;
    }

    public boolean hasMainMethod() {
        return (this.flags & 4) != 0;
    }

    public boolean hasDefaultConstructor() {
        return (this.flags & 1) != 0;
    }

    public boolean hasPublicConstructor() {
        return (this.flags & 2) != 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }
}

