/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform.util;

import com.spacekiller.infection.platform.util.ClassDescriptorImpl;
import com.spacekiller.infection.platform.util.ClassFile;
import com.spacekiller.util.ClassDescriptor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassScanner {
    private static final Logger logger = Logger.getLogger(ClassScanner.class.getName());

    public ClassDescriptor createClassDescriptor(String className, byte[] buf, int off, int len) throws Throwable {
        try {
            return this.createClassDescriptor1(className, buf, off, len);
        }
        catch (ClassFormatError e) {
            logger.fine("[1] Error analyzing class: " + className + " >> " + e);
            logger.log(Level.SEVERE, e.getMessage(), e);
            ClassDescriptorImpl descr = new ClassDescriptorImpl();
            descr.setClassName(className);
            descr.setSuperClassName(null);
            return descr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassDescriptor createClassDescriptor1(String className, byte[] buf, int off, int len) throws Throwable {
        ClassFile byteCode = new ClassFile();
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(buf, off, len));
        try {
            byteCode.read(className, din);
        }
        catch (ClassFormatError err) {
            logger.fine("DEBUG: Problem reading class: " + className + " => " + err);
            if (className.equals("java.util.ArrayList")) {
                logger.log(Level.SEVERE, err.getMessage(), err);
                byteCode.dump(System.out);
            }
            ClassDescriptor classDescriptor = this.createClassDescriptor2(className, byteCode, buf, off, len);
            return classDescriptor;
        }
        finally {
            din.close();
            din = null;
        }
        ClassDescriptorImpl descr = new ClassDescriptorImpl();
        int access = byteCode.getAccessFlags();
        descr.setModifiers(access);
        String className2 = byteCode.getClassName();
        if (!className.equals(className2)) {
            throw new Exception("[1] Unexpected class: " + className2 + " != " + className);
        }
        descr.setClassName(className2);
        descr.setSuperClassName(byteCode.getSuperClassName());
        descr.setInterfaceClassNames(byteCode.getInterfaceClassNames());
        int flags = byteCode.getOptionFlags();
        descr.setFlags(flags);
        int q = className.lastIndexOf("$");
        if (q > 0) {
            descr.setOuterClassName(className.substring(0, q));
        } else {
            descr.setOuterClassName(null);
        }
        return descr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassDescriptor createClassDescriptor2(String className, ClassFile failedByteCode, byte[] buf, int off, int len) throws Throwable {
        int j;
        String internalClassName = className.replace('.', '/');
        int consts = failedByteCode.getConstantCount();
        int[] indexes = new int[]{};
        for (j = 1; j < consts; ++j) {
            String s;
            Object obj = failedByteCode.getConstant(j);
            if (obj == null || !(obj instanceof String) || !(s = (String)obj).equals(internalClassName)) continue;
            int[] newIndexes = new int[indexes.length + 1];
            System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
            newIndexes[indexes.length] = j;
            indexes = newIndexes;
        }
        for (j = 0; j < indexes.length; ++j) {
            int classNameIndex = indexes[j];
            int classIndex = this.getClassIndexByClassNameIndex(failedByteCode, classNameIndex);
            if (classIndex < 1) continue;
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(buf, off, len));
            try {
                ClassFile byteCode = new ClassFile();
                byteCode.read2(className, din, classIndex, failedByteCode);
                ClassDescriptorImpl rc = new ClassDescriptorImpl();
                rc.setClassName(className);
                rc.setSuperClassName(byteCode.getSuperClassName());
                int mods = byteCode.getAccessFlags();
                rc.setModifiers(mods);
                int flags = byteCode.getOptionFlags();
                rc.setFlags(flags);
                ClassDescriptorImpl classDescriptorImpl = rc;
                return classDescriptorImpl;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            finally {
                din.close();
            }
        }
        throw new ClassFormatError("" + className);
    }

    protected String getClassFilePath(String className) {
        String path = className.replace('.', '/') + ".class";
        return path;
    }

    protected int getClassIndexByClassNameIndex(ClassFile byteCode, int classNameIndex) {
        int num = byteCode.getConstantCount();
        for (int c = 0; c < num; ++c) {
            Object o = byteCode.getConstant(c);
            if (o == null || !(o instanceof ClassFile.CONSTANT_Class_info)) continue;
            ClassFile.CONSTANT_Class_info cc = (ClassFile.CONSTANT_Class_info)o;
            if (cc.name_index != classNameIndex) continue;
            return c;
        }
        return -1;
    }
}

