/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.prefs;

import com.spacekiller.infection.platform.InfectionPreferencesConstants;
import com.spacekiller.infection.platform.SoftwareUpdater;
import com.spacekiller.infection.prefs.SoftwareUpdatePreferencesPanel;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.workbench.AbstractPreferencesPage;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.util.logging.Logger;

public class SoftwareUpdatePreferencesPage
extends AbstractPreferencesPage
implements InfectionPreferencesConstants {
    private PreferencesRegistry registry;
    private static final Logger logger = Logger.getLogger(SoftwareUpdatePreferencesPage.class.getName());

    public Component createComponent() {
        SoftwareUpdatePreferencesPanel panel = new SoftwareUpdatePreferencesPanel();
        return panel;
    }

    public void refreshPreferences(View view) throws Exception {
        SoftwareUpdatePreferencesPanel panel = this.getSoftwareUpdatePreferencesPanel(view);
        Preferences prefs = this.getPreferences();
        boolean autoUpdateEnabled = false;
        long autoUpdateInterval = 1L;
        boolean promptCheck = false;
        boolean promptDownload = false;
        boolean promptApply = false;
        if (prefs != null) {
            autoUpdateEnabled = prefs.getBoolean("autoUpdateEnabled");
            autoUpdateInterval = prefs.getLong("autoUpdatePeriod");
            promptCheck = prefs.getBoolean("promptCheck");
            promptDownload = prefs.getBoolean("promptDownload");
            promptApply = prefs.getBoolean("promptApply");
        }
        panel.getJCheckBoxAutoUpdateEnabled().setSelected(autoUpdateEnabled);
        panel.setUpdateFrequency(autoUpdateInterval);
        panel.getJCheckBoxPromptCheck().setSelected(promptCheck);
        panel.getJCheckBoxPromptDownload().setSelected(promptDownload);
        panel.getJCheckBoxPromptApply().setSelected(promptApply);
    }

    public void resetPreferences(View view) throws Exception {
        logger.fine("TODO: resetPreferences: " + view);
    }

    public void savePreferences(View view) throws Exception {
        SoftwareUpdatePreferencesPanel panel = this.getSoftwareUpdatePreferencesPanel(view);
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            prefs = this.getRegistry().createPreferences("platform.update");
        }
        prefs.setBoolean("autoUpdateEnabled", panel.getJCheckBoxAutoUpdateEnabled().isSelected());
        prefs.setLong("autoUpdatePeriod", panel.getUpdateFrequency());
        prefs.setBoolean("promptCheck", panel.getJCheckBoxPromptCheck().isSelected());
        prefs.setBoolean("promptDownload", panel.getJCheckBoxPromptDownload().isSelected());
        prefs.setBoolean("promptApply", panel.getJCheckBoxPromptApply().isSelected());
        this.getRegistry().savePreferences(prefs);
        SoftwareUpdater updater = SoftwareUpdater.getInstance();
        if (updater != null) {
            updater.refresh();
        }
    }

    protected PreferencesRegistry createRegistry() {
        return Platform.getInstance().getPreferencesRegistry();
    }

    protected PreferencesRegistry getRegistry() {
        if (this.registry == null) {
            this.setRegistry(this.createRegistry());
        }
        return this.registry;
    }

    protected void setRegistry(PreferencesRegistry registry) {
        this.registry = registry;
    }

    protected Preferences getPreferences() throws Exception {
        return this.getRegistry().getPreferences("platform.update");
    }

    protected SoftwareUpdatePreferencesPanel getSoftwareUpdatePreferencesPanel(View view) {
        Component comp = view.getComponent();
        if (comp != null && comp instanceof SoftwareUpdatePreferencesPanel) {
            return (SoftwareUpdatePreferencesPanel)comp;
        }
        return null;
    }
}

