/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.prefs;

import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.platform.InfectionPreferencesConstants;
import com.spacekiller.util.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SoftwareUpdatePreferencesPanel
extends JPanel
implements InfectionPreferencesConstants {
    private static final long serialVersionUID = 6614620276829869537L;
    private static final String FREQ_STARTUP = "Every startup";
    private static final String FREQ_DAILY = "Every day";
    private static final String FREQ_WEEKLY = "Every week";
    private static final String FREQ_MONTHLY = "Every month";
    private JCheckBox jCheckBoxAutoUpdateEnabled = null;
    private JButton jButtonSoftwareUpdate = null;
    private JPanel jPanel = null;
    private JCheckBox jCheckBoxPromptCheck = null;
    private JCheckBox jCheckBoxPromptDownload = null;
    private JCheckBox jCheckBoxPromptApply = null;
    private JLabel jLabel = null;
    private JComboBox jComboBoxFreq = null;
    private static final Logger logger = Logger.getLogger(SoftwareUpdatePreferencesPanel.class.getName());

    public SoftwareUpdatePreferencesPanel() {
        this.initialize();
        this.initSoftwareUpdatePreferencesPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(4, 8, 4, 8);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.anchor = 10;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridy = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(435, 305));
        this.add((Component)this.getJCheckBoxAutoUpdateEnabled(), gridBagConstraints);
        this.add((Component)this.getJButtonSoftwareUpdate(), gridBagConstraints1);
        this.add((Component)this.getJPanel(), gridBagConstraints2);
    }

    public JCheckBox getJCheckBoxAutoUpdateEnabled() {
        if (this.jCheckBoxAutoUpdateEnabled == null) {
            this.jCheckBoxAutoUpdateEnabled = new JCheckBox();
            this.jCheckBoxAutoUpdateEnabled.setText("Automatically check for software updates");
            this.jCheckBoxAutoUpdateEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SoftwareUpdatePreferencesPanel.this.checkEnable();
                }
            });
        }
        return this.jCheckBoxAutoUpdateEnabled;
    }

    private JButton getJButtonSoftwareUpdate() {
        if (this.jButtonSoftwareUpdate == null) {
            this.jButtonSoftwareUpdate = new JButton();
            this.jButtonSoftwareUpdate.setText("Software Update");
            this.jButtonSoftwareUpdate.setMargin(new Insets(4, 4, 4, 4));
            this.jButtonSoftwareUpdate.setToolTipText("Check for software updates..");
            this.jButtonSoftwareUpdate.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/platform/icons/install.gif")));
            this.jButtonSoftwareUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SoftwareUpdatePreferencesPanel.this.actionSoftwareUpdate();
                }
            });
        }
        return this.jButtonSoftwareUpdate;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Frequency:");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.anchor = 17;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanel.add((Component)this.getJCheckBoxPromptCheck(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJCheckBoxPromptDownload(), gridBagConstraints4);
            this.jPanel.add((Component)this.getJCheckBoxPromptApply(), gridBagConstraints5);
            this.jPanel.add((Component)this.jLabel, gridBagConstraints6);
            this.jPanel.add((Component)this.getJComboBoxFreq(), gridBagConstraints7);
        }
        return this.jPanel;
    }

    public JCheckBox getJCheckBoxPromptCheck() {
        if (this.jCheckBoxPromptCheck == null) {
            this.jCheckBoxPromptCheck = new JCheckBox();
            this.jCheckBoxPromptCheck.setText("Prompt before checking for updates");
            this.jCheckBoxPromptCheck.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.jCheckBoxPromptCheck;
    }

    public JCheckBox getJCheckBoxPromptDownload() {
        if (this.jCheckBoxPromptDownload == null) {
            this.jCheckBoxPromptDownload = new JCheckBox();
            this.jCheckBoxPromptDownload.setMargin(new Insets(0, 0, 0, 0));
            this.jCheckBoxPromptDownload.setText("Prompt before downloading updates");
        }
        return this.jCheckBoxPromptDownload;
    }

    public JCheckBox getJCheckBoxPromptApply() {
        if (this.jCheckBoxPromptApply == null) {
            this.jCheckBoxPromptApply = new JCheckBox();
            this.jCheckBoxPromptApply.setText("Prompt before applying updates");
            this.jCheckBoxPromptApply.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.jCheckBoxPromptApply;
    }

    protected JComboBox getJComboBoxFreq() {
        if (this.jComboBoxFreq == null) {
            this.jComboBoxFreq = new JComboBox();
            this.jComboBoxFreq.setOpaque(false);
        }
        return this.jComboBoxFreq;
    }

    public long getUpdateFrequency() {
        Object item = this.getJComboBoxFreq().getSelectedItem();
        if (item == null) {
            return 0L;
        }
        if (item == FREQ_STARTUP) {
            return 1L;
        }
        if (item == FREQ_DAILY) {
            return 86400000L;
        }
        if (item == FREQ_WEEKLY) {
            return 604800000L;
        }
        if (item == FREQ_MONTHLY) {
            return 2592000000L;
        }
        return 0L;
    }

    public void setUpdateFrequency(long millis) {
        if (millis == 1L) {
            this.getJComboBoxFreq().setSelectedItem(FREQ_STARTUP);
            return;
        }
        if (millis == 86400000L) {
            this.getJComboBoxFreq().setSelectedItem(FREQ_DAILY);
            return;
        }
        if (millis == 604800000L) {
            this.getJComboBoxFreq().setSelectedItem(FREQ_WEEKLY);
            return;
        }
        if (millis == 2592000000L) {
            this.getJComboBoxFreq().setSelectedItem(FREQ_MONTHLY);
            return;
        }
        this.getJComboBoxFreq().setSelectedItem("" + millis);
    }

    protected void initSoftwareUpdatePreferencesPanel() {
        this.getJComboBoxFreq().addItem(FREQ_STARTUP);
        this.getJComboBoxFreq().addItem(FREQ_DAILY);
        this.getJComboBoxFreq().addItem(FREQ_WEEKLY);
        this.getJComboBoxFreq().addItem(FREQ_MONTHLY);
        this.checkEnable();
    }

    protected void checkEnable() {
        boolean enabled = this.getJCheckBoxAutoUpdateEnabled().isSelected();
        this.getJComboBoxFreq().setEnabled(enabled);
        this.getJCheckBoxPromptCheck().setEnabled(enabled);
        this.getJCheckBoxPromptDownload().setEnabled(enabled);
        this.getJCheckBoxPromptApply().setEnabled(enabled);
    }

    protected void actionSoftwareUpdate() {
        try {
            Platform plat = Platform.getInstance();
            if (plat instanceof InfectionPlatform) {
                InfectionPlatform ip = (InfectionPlatform)plat;
                ip.openUpdateManager();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }
}

