/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.scratch.impl;

import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.thread.Work;
import com.waxmonster.scratch.AudioScratchModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CubicAudioScratchModel
implements AudioScratchModel {
    private static final Logger logger = Logger.getLogger(CubicAudioScratchModel.class.getName());
    public static final int MIN_BUFFER_COUNT = 5;
    public static final int DEFAULT_BUFFER_COUNT = 7;
    public static final int MIN_BUFFER_FRAMES = 16;
    protected final Loader loader;
    protected final Work loaderWork;
    protected final double bpm;
    protected final double dur;
    protected volatile double anc;
    protected volatile double ori;
    protected final int bufCount;
    protected final int bufFrames;
    protected final int halfCount;
    protected final int halfFrames;
    protected Buf frst;
    protected Buf last;
    protected int bsw;
    protected Buf buf;
    protected double[] arr;
    protected long ofs;
    protected final int nc;
    protected final SampleModel am;
    protected final float rate;
    protected final double fpm;

    public CubicAudioScratchModel(SampleModel audioModel, double startFramePos, double bpm, double duration, int bufFrames, int bufCount, ThreadPool loaderThreadPool, boolean batchMode, int asyncSleepMillis) throws IOException, InterruptedException {
        if (bufFrames < 16) {
            throw new IllegalArgumentException("Invalid scratch buffer size: " + bufFrames + " < " + 16 + " frames");
        }
        if (bufCount < 5) {
            throw new IllegalArgumentException("Invalid number of scratch buffers: " + bufCount + " < " + 5);
        }
        if (Double.isNaN(startFramePos)) {
            throw new IllegalArgumentException("Invalid start frame position: " + startFramePos);
        }
        this.bufCount = bufCount;
        this.bufFrames = bufFrames;
        this.halfCount = bufCount / 2;
        this.halfFrames = bufFrames / 2;
        this.bpm = bpm;
        this.dur = duration;
        this.anc = 0.0;
        this.nc = audioModel.getChannels();
        this.am = audioModel;
        this.rate = audioModel.getFrameRate();
        this.fpm = (double)this.rate / 1000.0;
        long framePos = (long)(startFramePos - (double)(bufCount * bufFrames / 2));
        int bufSamples = (bufFrames + 4) * this.nc;
        Buf firstBuf = null;
        Buf lastBuf = null;
        Buf mainBuf = null;
        for (int i = 0; i < bufCount; ++i) {
            Buf b = new Buf(new double[bufSamples]);
            b.ofs = framePos;
            b.end = framePos += (long)bufFrames;
            if (mainBuf == null && (double)framePos > startFramePos) {
                mainBuf = b;
            }
            if (firstBuf == null) {
                firstBuf = b;
            }
            if (lastBuf != null) {
                lastBuf.next = b;
            }
            b.prev = lastBuf;
            lastBuf = b;
        }
        lastBuf.next = firstBuf;
        firstBuf.prev = lastBuf;
        this.frst = firstBuf;
        this.last = lastBuf;
        this.buf = mainBuf;
        mainBuf.ready = true;
        this.load(mainBuf);
        Buf b = mainBuf.next;
        while (b != mainBuf) {
            b.ready = true;
            this.load(b);
            b = b.next;
        }
        if (batchMode) {
            SyncLoader syn = new SyncLoader();
            this.loader = syn;
            this.loaderWork = null;
        } else {
            AsyncLoader asy = new AsyncLoader(asyncSleepMillis);
            this.loader = asy;
            this.loaderWork = loaderThreadPool.start((Runnable)asy);
        }
        this.arr = this.buf.arr;
        this.ofs = this.buf.ofs;
    }

    public double getAnchor() {
        return this.anc;
    }

    public void setAnchor(double a) {
        this.anc = a;
    }

    public double getOrigin() {
        return this.ori;
    }

    public void setOrigin(double v) {
        this.ori = v;
    }

    public double getBPM() {
        return this.bpm;
    }

    public double getDuration() {
        return this.dur;
    }

    public float getFrameRate() {
        return this.rate;
    }

    public int getChannels() {
        return this.nc;
    }

    public SampleModel getAudioModel() {
        return this.am;
    }

    public void close() throws IOException {
        this.loader.stop();
        this.arr = null;
        this.buf = null;
        this.frst = null;
        this.last = null;
    }

    public void get(double p, double v, double[] dst, int off) {
        Buf r;
        Buf b;
        double x = (p = (p - this.anc) * this.fpm - 1.0) - (double)this.ofs;
        if (x >= (double)this.bufFrames) {
            b = this.buf.next;
            if ((double)b.end > p && (double)b.ofs <= p) {
                if (this.bsw < 1) {
                    ++this.bsw;
                } else {
                    r = this.frst;
                    r.ofs = this.last.end;
                    r.end = r.ofs + (long)this.bufFrames;
                    this.frst = r.next;
                    this.last = r;
                    this.loader.switched(r);
                }
            } else {
                b = this.loader.skipped(p);
            }
            this.buf = b;
            this.arr = b.arr;
            this.ofs = b.ofs;
            x = p - (double)this.ofs;
        } else if (x < 0.0) {
            b = this.buf.prev;
            if ((double)b.ofs <= p && (double)b.end > p) {
                if (this.bsw > -1) {
                    --this.bsw;
                } else {
                    r = this.last;
                    r.end = this.frst.ofs;
                    r.ofs = r.end - (long)this.bufFrames;
                    this.last = r.prev;
                    this.frst = r;
                    this.loader.switched(r);
                }
            } else {
                b = this.loader.skipped(p);
            }
            this.buf = b;
            this.arr = b.arr;
            this.ofs = b.ofs;
            x = p - (double)this.ofs;
        }
        int i = (int)x;
        double f = x - (double)i;
        double f2 = f * f;
        int x0 = i * this.nc;
        int x1 = x0 + this.nc;
        int x2 = x1 + this.nc;
        int x3 = x2 + this.nc;
        for (i = 0; i < this.nc; ++i) {
            double s0 = this.arr[x0++];
            double s1 = this.arr[x1++];
            double s2 = this.arr[x2++];
            double s3 = this.arr[x3++];
            double a = s3 - s2 - s0 + s1;
            double b2 = s0 - s1 - a;
            double c = s2 - s0;
            dst[off++] = (a * f * f2 + b2 * f2 + c * f + s1) * v;
        }
    }

    protected void load(Buf b) {
        long len;
        double[] a = b.arr;
        int idx = 0;
        int num = a.length;
        long pos = b.ofs * (long)this.nc;
        if (pos < 0L) {
            if (pos <= (long)(-num)) {
                if (b.dirty) {
                    Arrays.fill(a, 0.0);
                    b.dirty = false;
                }
                return;
            }
            idx = (int)(-pos);
            if (b.dirty) {
                Arrays.fill(a, 0, idx, 0.0);
            }
            num -= idx;
            pos = 0L;
        }
        if (pos + (long)num > (len = this.am.getSamples())) {
            if (pos >= len) {
                if (b.dirty) {
                    Arrays.fill(a, 0.0);
                    b.dirty = false;
                }
                return;
            }
            num = (int)(len - pos);
            if (b.dirty) {
                Arrays.fill(a, num, a.length, 0.0);
            }
        }
        b.dirty = true;
        try {
            this.am.get(pos, a, idx, num);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void load(Buf b, int i, int n) {
        long len;
        double[] a = b.arr;
        int idx = i * this.nc;
        int num = i + n >= this.bufFrames ? a.length - idx : n * this.nc;
        long pos = b.ofs * (long)this.nc + (long)idx;
        if (pos < 0L) {
            if (pos <= (long)(-num)) {
                if (b.dirty) {
                    Arrays.fill(a, idx, idx + num, 0.0);
                }
                return;
            }
            if (b.dirty) {
                Arrays.fill(a, idx, idx - (int)pos, 0.0);
            }
            idx -= (int)pos;
            num += (int)pos;
            pos = 0L;
        }
        if (pos + (long)num > (len = this.am.getSamples())) {
            if (pos >= len) {
                if (b.dirty) {
                    Arrays.fill(a, idx, idx + num, 0.0);
                }
                return;
            }
            if (b.dirty) {
                Arrays.fill(a, idx + (int)(len - pos), idx + num, 0.0);
            }
            num = (int)(len - pos);
        }
        b.dirty = true;
        try {
            this.am.get(pos, a, idx, num);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void reload(long p, long q) throws IOException {
        int i;
        Buf next;
        Buf prev;
        int n;
        Buf b = this.buf;
        long x = b.ofs;
        long z = x + (long)this.bufFrames;
        if (q <= x) {
            do {
                b = b.prev;
                z = b.end;
                if (z == x) continue;
                return;
            } while (q <= (x -= (long)this.bufFrames));
            n = (int)(q - x);
            if (p >= x) {
                int i2 = (int)(p - x);
                this.load(b, i2, n);
                return;
            }
            this.load(b, 0, n);
            prev = b.prev;
            next = null;
        } else if (p >= z) {
            do {
                b = b.next;
                x = b.ofs;
                if (x == z) continue;
                return;
            } while (p >= (z += (long)this.bufFrames));
            i = (int)(p - x);
            if (q <= z) {
                int n2 = (int)(q - p);
                this.load(b, i, n2);
                return;
            }
            n = (int)(z - p);
            this.load(b, i, n);
            prev = null;
            next = b.next;
        } else if (p >= x) {
            i = (int)(p - x);
            if (q <= z) {
                int n3 = (int)(q - p);
                this.load(b, i, n3);
                return;
            }
            this.load(b, i, this.bufFrames - i);
            next = b.next;
            prev = null;
        } else if (q <= z) {
            n = (int)(q - x);
            this.load(b, 0, n);
            prev = b.prev;
            next = null;
        } else {
            this.load(b, 0, this.bufFrames);
            prev = b.prev;
            next = b.next;
        }
        while (true) {
            long v;
            if (next != null) {
                v = next.ofs;
                if (q <= v || v != z) {
                    next = null;
                    continue;
                }
                if (q <= (z += (long)this.bufFrames)) {
                    n = (int)(q - v);
                    this.load(next, 0, n);
                    next = null;
                    continue;
                }
                this.load(next, 0, this.bufFrames);
                next = next.next;
                if (prev == null) {
                    continue;
                }
            } else if (prev == null) {
                return;
            }
            if (p >= (v = prev.end) || v != x) {
                prev = null;
                continue;
            }
            if (p >= (x -= (long)this.bufFrames)) {
                i = (int)(p - x);
                this.load(prev, i, this.bufFrames - i);
                prev = null;
                continue;
            }
            this.load(prev, 0, this.bufFrames);
            prev = prev.prev;
        }
    }

    protected class AsyncLoader
    extends Loader
    implements Runnable {
        private final int sleepMillis;
        private volatile boolean loop;
        private volatile Buf osb;
        private volatile int swc;
        private volatile int skc;

        public AsyncLoader(int sleepMillis) {
            this.sleepMillis = sleepMillis;
            this.loop = true;
            this.swc = 0;
            this.skc = 0;
        }

        @Override
        protected void switched(Buf b) {
            b.ready = false;
            if (this.osb == null) {
                this.osb = b;
            }
            ++this.swc;
        }

        @Override
        protected Buf skipped(double p) {
            long o = (long)p - (long)CubicAudioScratchModel.this.halfFrames;
            long z = o + (long)CubicAudioScratchModel.this.bufFrames;
            Buf b = CubicAudioScratchModel.this.buf;
            b.ready = false;
            b.ofs = o;
            b.end = z;
            this.osb = b;
            ++this.skc;
            ++this.swc;
            return b;
        }

        @Override
        protected void stop() {
            this.loop = false;
            Work work = CubicAudioScratchModel.this.loaderWork;
            if (work != null) {
                try {
                    work.join();
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int sm = this.sleepMillis;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("AsyncLoader started: " + this + " (sleepMillis=" + this.sleepMillis + ")");
            }
            try {
                int swo = 0;
                int sko = 0;
                block5: while (this.loop) {
                    Buf c;
                    if (swo == this.swc) {
                        Thread.sleep(sm);
                        continue;
                    }
                    swo = this.swc;
                    Buf b = this.osb;
                    if (b != null) {
                        this.osb = null;
                        if (sko == this.skc) {
                            if (!b.ready) {
                                b.ready = true;
                                CubicAudioScratchModel.this.load(b);
                                if (swo != this.swc) {
                                    continue;
                                }
                            }
                        } else {
                            sko = this.skc;
                            long o = b.ofs;
                            long z = b.end;
                            c = b;
                            Buf d = CubicAudioScratchModel.this.last;
                            while (c != d) {
                                c = c.next;
                                c.ofs = z;
                                c.end = z += (long)CubicAudioScratchModel.this.bufFrames;
                                c.ready = false;
                            }
                            c = b;
                            d = d.next;
                            while (c != d) {
                                c = c.prev;
                                c.end = o;
                                c.ofs = o -= (long)CubicAudioScratchModel.this.bufFrames;
                                c.ready = false;
                            }
                            if (!b.ready) {
                                b.ready = true;
                                CubicAudioScratchModel.this.load(b);
                                if (swo != this.swc) continue;
                            }
                        }
                    }
                    if ((b = CubicAudioScratchModel.this.buf) == null) continue;
                    if (!b.ready) {
                        b.ready = true;
                        CubicAudioScratchModel.this.load(b);
                        if (swo != this.swc) continue;
                    }
                    c = b.next;
                    while (c != b) {
                        if (!c.ready) {
                            c.ready = true;
                            CubicAudioScratchModel.this.load(c);
                            if (swo != this.swc) continue block5;
                        }
                        c = c.next;
                    }
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("AsyncLoader stopped: " + this);
                }
            }
        }
    }

    protected class SyncLoader
    extends Loader {
        @Override
        protected void switched(Buf b) {
            CubicAudioScratchModel.this.load(b);
        }

        @Override
        protected Buf skipped(double p) {
            Buf b = this.find(p);
            if (b == null) {
                long o = (long)p - (long)CubicAudioScratchModel.this.halfFrames;
                long z = o + (long)CubicAudioScratchModel.this.bufFrames;
                b = CubicAudioScratchModel.this.buf;
                b.ofs = o;
                b.end = z;
                CubicAudioScratchModel.this.load(b);
                while (b != CubicAudioScratchModel.this.last) {
                    b = b.next;
                    b.ofs = z;
                    b.end = z += (long)CubicAudioScratchModel.this.bufFrames;
                    CubicAudioScratchModel.this.load(b);
                }
                b = CubicAudioScratchModel.this.buf;
                while (b != CubicAudioScratchModel.this.frst) {
                    b = b.prev;
                    b.end = o;
                    b.ofs = o -= (long)CubicAudioScratchModel.this.bufFrames;
                    CubicAudioScratchModel.this.load(b);
                }
                return CubicAudioScratchModel.this.buf;
            }
            long o = b.ofs;
            long z = b.end;
            Buf u = b;
            for (int i = 0; i < CubicAudioScratchModel.this.halfCount; ++i) {
                u = u.next;
                if (u.ofs == z) {
                    z = u.end;
                    continue;
                }
                u.ofs = z;
                u.end = z += (long)CubicAudioScratchModel.this.bufFrames;
                CubicAudioScratchModel.this.load(u);
            }
            CubicAudioScratchModel.this.last = u;
            CubicAudioScratchModel.this.frst = u.next;
            u = b;
            while (u != CubicAudioScratchModel.this.frst) {
                u = u.prev;
                if (u.end == o) {
                    o = u.ofs;
                    continue;
                }
                u.end = o;
                u.ofs = o -= (long)CubicAudioScratchModel.this.bufFrames;
                CubicAudioScratchModel.this.load(u);
            }
            return b;
        }

        @Override
        protected void stop() {
        }

        protected Buf find(double p) {
            Buf b = CubicAudioScratchModel.this.buf;
            if (p < (double)b.ofs) {
                if (b != CubicAudioScratchModel.this.frst) {
                    b = b.prev;
                    while (p < (double)b.ofs && b != CubicAudioScratchModel.this.frst) {
                        b = b.prev;
                    }
                    return p >= (double)b.ofs && p < (double)b.end ? b : null;
                }
                return null;
            }
            if (p >= (double)b.end) {
                if (b != CubicAudioScratchModel.this.last) {
                    b = b.next;
                    while (p >= (double)b.end && b != CubicAudioScratchModel.this.last) {
                        b = b.next;
                    }
                    return p < (double)b.end && p >= (double)b.ofs ? b : null;
                }
                return null;
            }
            return b;
        }
    }

    protected abstract class Loader {
        protected Loader() {
        }

        protected abstract void switched(Buf var1);

        protected abstract Buf skipped(double var1);

        protected abstract void stop();
    }

    protected static class Buf {
        protected final double[] arr;
        protected boolean dirty;
        protected volatile boolean ready;
        protected volatile long ofs;
        protected volatile long end;
        protected Buf prev;
        protected Buf next;

        public Buf(double[] arr) {
            this.arr = arr;
        }

        public String toString() {
            return super.toString() + "[ofs=" + this.ofs + ", end=" + this.end + "]";
        }
    }
}

