/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.scratch.impl;

import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.thread.Work;
import com.waxmonster.scratch.TimecodeScratchModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CubicTimecodeScratchModel
implements TimecodeScratchModel {
    private static final Logger logger = Logger.getLogger(CubicTimecodeScratchModel.class.getName());
    public static final int MIN_BUFFER_COUNT = 5;
    public static final int DEFAULT_BUFFER_COUNT = 7;
    public static final int MIN_BUFFER_FRAMES = 16;
    protected final Loader loader;
    protected final Work loaderWork;
    protected final int bufCount;
    protected final int bufFrames;
    protected final int halfCount;
    protected final int halfFrames;
    protected Buf frst;
    protected Buf last;
    protected int bsw;
    protected Buf buf;
    protected double[] arr;
    protected long ofs;
    protected final SampleModel tm;
    protected final float rate;

    public CubicTimecodeScratchModel(SampleModel tcModel, double startFramePos, int bufFrames, int bufCount, ThreadPool loaderThreadPool, boolean batchMode, int asyncSleepMillis) throws IOException, InterruptedException {
        if (bufFrames < 16) {
            throw new IllegalArgumentException("Invalid scratch buffer size: " + bufFrames + " < " + 16 + " frames");
        }
        if (bufCount < 5) {
            throw new IllegalArgumentException("Invalid number of scratch buffers: " + bufCount + " < " + 5);
        }
        if (Double.isNaN(startFramePos)) {
            throw new IllegalArgumentException("Invalid start frame position: " + startFramePos);
        }
        this.bufCount = bufCount;
        this.bufFrames = bufFrames;
        this.halfCount = bufCount / 2;
        this.halfFrames = bufFrames / 2;
        this.tm = tcModel;
        this.rate = tcModel.getFrameRate();
        long framePos = (long)(startFramePos - (double)(bufCount * bufFrames / 2));
        Buf firstBuf = null;
        Buf lastBuf = null;
        Buf mainBuf = null;
        for (int i = 0; i < bufCount; ++i) {
            int samples = bufFrames + 4;
            Buf b = new Buf(new double[samples]);
            b.ofs = framePos;
            b.end = framePos += (long)bufFrames;
            if (mainBuf == null && (double)framePos > startFramePos) {
                mainBuf = b;
            }
            if (firstBuf == null) {
                firstBuf = b;
            }
            if (lastBuf != null) {
                lastBuf.next = b;
            }
            b.prev = lastBuf;
            lastBuf = b;
        }
        lastBuf.next = firstBuf;
        firstBuf.prev = lastBuf;
        this.frst = firstBuf;
        this.last = lastBuf;
        this.buf = mainBuf;
        mainBuf.ready = true;
        this.load(mainBuf);
        Buf b = mainBuf.next;
        while (b != mainBuf) {
            b.ready = true;
            this.load(b);
            b = b.next;
        }
        if (batchMode) {
            SyncLoader syn = new SyncLoader();
            this.loader = syn;
            this.loaderWork = null;
        } else {
            AsyncLoader asy = new AsyncLoader(asyncSleepMillis);
            this.loader = asy;
            this.loaderWork = loaderThreadPool.start((Runnable)asy);
        }
        this.arr = this.buf.arr;
        this.ofs = this.buf.ofs;
    }

    public float getFrameRate() {
        return this.rate;
    }

    public void close() throws IOException {
        this.loader.stop();
        this.arr = null;
        this.buf = null;
        this.frst = null;
        this.last = null;
    }

    public double get(double p) {
        Buf r;
        Buf b;
        double x = p - (double)this.ofs - 1.0;
        if (x >= (double)this.bufFrames) {
            b = this.buf.next;
            if ((double)b.end > p && (double)b.ofs <= p) {
                if (this.bsw < 1) {
                    ++this.bsw;
                } else {
                    r = this.frst;
                    r.ofs = this.last.end;
                    r.end = r.ofs + (long)this.bufFrames;
                    this.frst = r.next;
                    this.last = r;
                    this.loader.switched(r);
                }
            } else {
                b = this.loader.skipped(p);
            }
            this.buf = b;
            this.arr = b.arr;
            this.ofs = b.ofs;
            x = p - (double)this.ofs;
        } else if (x < 0.0) {
            b = this.buf.prev;
            if ((double)b.ofs <= p && (double)b.end > p) {
                if (this.bsw > -1) {
                    --this.bsw;
                } else {
                    r = this.last;
                    r.end = this.frst.ofs;
                    r.ofs = r.end - (long)this.bufFrames;
                    this.last = r.prev;
                    this.frst = r;
                    this.loader.switched(r);
                }
            } else {
                b = this.loader.skipped(p);
            }
            this.buf = b;
            this.arr = b.arr;
            this.ofs = b.ofs;
            x = p - (double)this.ofs;
        }
        int i = (int)x;
        double f = x - (double)i;
        double f2 = f * f;
        double s0 = this.arr[i];
        double s1 = this.arr[i + 1];
        double s2 = this.arr[i + 2];
        double s3 = this.arr[i + 3];
        double a = s3 - s2 - s0 + s1;
        double b2 = s0 - s1 - a;
        double c = s2 - s0;
        return a * f * f2 + b2 * f2 + c * f + s1;
    }

    protected void load(Buf b) throws IOException {
        long len;
        double[] a = b.arr;
        int num = a.length;
        int idx = 0;
        long pos = b.ofs;
        if (pos < 0L) {
            if (pos <= (long)(-num)) {
                if (b.dirty) {
                    Arrays.fill(a, 0.0);
                    b.dirty = false;
                }
                return;
            }
            idx = (int)(-pos);
            if (b.dirty) {
                Arrays.fill(a, 0, idx, 0.0);
            }
            pos = 0L;
            num -= idx;
        }
        if (pos + (long)num > (len = this.tm.getSamples())) {
            if (pos >= len) {
                if (b.dirty) {
                    Arrays.fill(a, 0.0);
                    b.dirty = false;
                }
                return;
            }
            num = (int)(len - pos);
            if (b.dirty) {
                Arrays.fill(a, num, a.length, 0.0);
            }
        }
        b.dirty = true;
        this.tm.get(pos, a, idx, num);
    }

    public void reload(long p, long q) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected class AsyncLoader
    extends Loader
    implements Runnable {
        private final int sleepMillis;
        private volatile boolean loop;
        private volatile Buf osb;
        private volatile int swc;
        private volatile int skc;

        public AsyncLoader(int sleepMillis) {
            this.sleepMillis = sleepMillis;
            this.loop = true;
            this.swc = 0;
            this.skc = 0;
        }

        @Override
        protected void switched(Buf b) {
            b.ready = false;
            if (this.osb == null) {
                this.osb = b;
            }
            ++this.swc;
        }

        @Override
        protected Buf skipped(double p) {
            long o = (long)p - (long)CubicTimecodeScratchModel.this.halfFrames;
            long z = o + (long)CubicTimecodeScratchModel.this.bufFrames;
            Buf b = CubicTimecodeScratchModel.this.buf;
            b.ready = false;
            b.ofs = o;
            b.end = z;
            this.osb = b;
            ++this.skc;
            ++this.swc;
            return b;
        }

        @Override
        protected void stop() {
            this.loop = false;
            Work work = CubicTimecodeScratchModel.this.loaderWork;
            if (work != null) {
                try {
                    work.join();
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int sm = this.sleepMillis;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("AsyncLoader started: " + this + " (sleepMillis=" + this.sleepMillis + ")");
            }
            try {
                int swo = 0;
                int sko = 0;
                block5: while (this.loop) {
                    Buf c;
                    if (swo == this.swc) {
                        Thread.sleep(sm);
                        continue;
                    }
                    swo = this.swc;
                    Buf b = this.osb;
                    if (b != null) {
                        this.osb = null;
                        if (sko == this.skc) {
                            if (!b.ready) {
                                b.ready = true;
                                CubicTimecodeScratchModel.this.load(b);
                                if (swo != this.swc) {
                                    continue;
                                }
                            }
                        } else {
                            sko = this.skc;
                            long o = b.ofs;
                            long z = b.end;
                            c = b;
                            Buf d = CubicTimecodeScratchModel.this.last;
                            while (c != d) {
                                c = c.next;
                                c.ofs = z;
                                c.end = z += (long)CubicTimecodeScratchModel.this.bufFrames;
                                c.ready = false;
                            }
                            c = b;
                            d = d.next;
                            while (c != d) {
                                c = c.prev;
                                c.end = o;
                                c.ofs = o -= (long)CubicTimecodeScratchModel.this.bufFrames;
                                c.ready = false;
                            }
                            if (!b.ready) {
                                b.ready = true;
                                CubicTimecodeScratchModel.this.load(b);
                                if (swo != this.swc) continue;
                            }
                        }
                    }
                    if ((b = CubicTimecodeScratchModel.this.buf) == null) continue;
                    if (!b.ready) {
                        b.ready = true;
                        CubicTimecodeScratchModel.this.load(b);
                        if (swo != this.swc) continue;
                    }
                    c = b.next;
                    while (c != b) {
                        if (!c.ready) {
                            c.ready = true;
                            CubicTimecodeScratchModel.this.load(c);
                            if (swo != this.swc) continue block5;
                        }
                        c = c.next;
                    }
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("AsyncLoader stopped: " + this);
                }
            }
        }
    }

    protected class SyncLoader
    extends Loader {
        protected SyncLoader() {
        }

        @Override
        protected void switched(Buf b) {
            try {
                CubicTimecodeScratchModel.this.load(b);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected Buf skipped(double p) {
            try {
                Buf b = this.find(p);
                if (b == null) {
                    long o = (long)p - (long)CubicTimecodeScratchModel.this.halfFrames;
                    long z = o + (long)CubicTimecodeScratchModel.this.bufFrames;
                    b = CubicTimecodeScratchModel.this.buf;
                    b.ofs = o;
                    b.end = z;
                    CubicTimecodeScratchModel.this.load(b);
                    while (b != CubicTimecodeScratchModel.this.last) {
                        b = b.next;
                        b.ofs = z;
                        b.end = z += (long)CubicTimecodeScratchModel.this.bufFrames;
                        CubicTimecodeScratchModel.this.load(b);
                    }
                    b = CubicTimecodeScratchModel.this.buf;
                    while (b != CubicTimecodeScratchModel.this.frst) {
                        b = b.prev;
                        b.end = o;
                        b.ofs = o -= (long)CubicTimecodeScratchModel.this.bufFrames;
                        CubicTimecodeScratchModel.this.load(b);
                    }
                    return CubicTimecodeScratchModel.this.buf;
                }
                long o = b.ofs;
                long z = b.end;
                Buf u = b;
                for (int i = 0; i < CubicTimecodeScratchModel.this.halfCount; ++i) {
                    u = u.next;
                    if (u.ofs == z) {
                        z = u.end;
                        continue;
                    }
                    u.ofs = z;
                    u.end = z += (long)CubicTimecodeScratchModel.this.bufFrames;
                    CubicTimecodeScratchModel.this.load(u);
                }
                CubicTimecodeScratchModel.this.last = u;
                CubicTimecodeScratchModel.this.frst = u.next;
                u = b;
                while (u != CubicTimecodeScratchModel.this.frst) {
                    u = u.prev;
                    if (u.end == o) {
                        o = u.ofs;
                        continue;
                    }
                    u.end = o;
                    u.ofs = o -= (long)CubicTimecodeScratchModel.this.bufFrames;
                    CubicTimecodeScratchModel.this.load(u);
                }
                return b;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void stop() {
        }

        protected Buf find(double p) {
            Buf b = CubicTimecodeScratchModel.this.buf;
            if (p < (double)b.ofs) {
                if (b != CubicTimecodeScratchModel.this.frst) {
                    b = b.prev;
                    while (p < (double)b.ofs && b != CubicTimecodeScratchModel.this.frst) {
                        b = b.prev;
                    }
                    return p >= (double)b.ofs && p < (double)b.end ? b : null;
                }
                return null;
            }
            if (p >= (double)b.end) {
                if (b != CubicTimecodeScratchModel.this.last) {
                    b = b.next;
                    while (p >= (double)b.end && b != CubicTimecodeScratchModel.this.last) {
                        b = b.next;
                    }
                    return p < (double)b.end && p >= (double)b.ofs ? b : null;
                }
                return null;
            }
            return b;
        }
    }

    protected abstract class Loader {
        protected Loader() {
        }

        protected abstract void switched(Buf var1);

        protected abstract Buf skipped(double var1);

        protected abstract void stop();
    }

    protected static class Buf {
        protected final double[] arr;
        protected boolean dirty;
        protected volatile boolean ready;
        protected volatile long ofs;
        protected volatile long end;
        protected Buf prev;
        protected Buf next;

        public Buf(double[] arr) {
            this.arr = arr;
        }

        public String toString() {
            return super.toString() + "[ofs=" + this.ofs + ", end=" + this.end + "]";
        }
    }
}

