/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.scratch.impl;

import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioSlice;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.scratch.ScratchModel;
import com.waxmonster.scratch.TimecodeScratchModel;
import com.waxmonster.scratch.impl.AbstractAudioScratchPlayer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultAudioScratchPlayer
extends AbstractAudioScratchPlayer {
    public static final double DEFAULT_NEEDLE_SKIP_THRESHOLD = 10.0;
    public static final double MIN_NEEDLE_SKIP_THRESHOLD = 2.0;
    public static final double MAX_PITCH = 8.0;
    public static final double MIN_PITCH = -8.0;
    private static final Logger logger = Logger.getLogger(DefaultAudioScratchPlayer.class.getName());
    private final TimecodeScratchModel tm;
    private volatile AudioScratchModel asm;
    private final double[] out;
    private final int nc;
    private final float rate;
    private final double tpo;
    private final double nvf;
    private double vvf;
    private double volume;
    private double pitch;
    private double primaryPitch;
    private double secondaryPitch;
    private int pitchMode;
    private double pitchCustom;
    private double pitchBPM;
    private PitchDeck pitchDeck;
    private final double skipFwd;
    private final double skipBwd;
    private double tim;
    private double pos;
    private double vel;
    private double ctp;
    private double ori;
    private double vol;
    private AudioSlice slice;
    private boolean loop;
    private double loopPos;
    private double loopLen;

    public DefaultAudioScratchPlayer(TimecodeScratchModel timecodeScratchModel, double tcStartFramePos, double tcInitVelocity, double tcInitVolume, AudioScratchModel audioScratchModel, double startTrackPos, double volume, int pitchMode, double pitchCustom, double pitchBPM, PitchDeck pitchDeck, DoubleArraySampleBuffer target, double skipThreshold) {
        this.tm = timecodeScratchModel;
        this.out = target.array();
        this.rate = target.getFrameRate();
        this.nc = target.getChannels();
        double timecodeRate = timecodeScratchModel.getFrameRate();
        this.tpo = timecodeRate / (double)this.rate;
        this.nvf = (double)this.rate / 1000.0;
        this.setVolume(volume);
        this.pitchCustom = pitchCustom;
        this.pitchBPM = pitchBPM;
        this.pitchDeck = pitchDeck;
        this.secondaryPitch = 1.0;
        this.pitchMode = -1;
        this.setPitchMode(pitchMode);
        if (skipThreshold < 2.0) {
            throw new IllegalArgumentException("Invalid needle skip threshold: " + skipThreshold + " < " + 2.0);
        }
        this.skipFwd = skipThreshold * 1000.0 / (double)this.rate;
        this.skipBwd = -this.skipFwd;
        this.tim = tcStartFramePos;
        this.pos = this.tm.get(this.tim);
        this.vel = tcInitVelocity;
        this.vol = tcInitVolume;
        this.ctp = startTrackPos;
        this.setAudioScratchModel(audioScratchModel);
    }

    public void process(long time, int f) throws AudioException {
        int o = 0;
        for (int i = 0; i < f; ++i) {
            double d;
            this.ctp += this.vel * this.pitch;
            if (this.loop) {
                AudioSlice as;
                double clp = this.ctp - this.loopPos;
                if (clp < 0.0) {
                    as = this.slice;
                    if (as != null) {
                        as = as.getPrev();
                    }
                    this.slice = as;
                    if (as != null) {
                        this.loopPos = as.getOffset();
                        this.loopLen = as.getLength();
                        clp = (this.loopLen + clp) % this.loopLen;
                    } else {
                        this.loop = false;
                    }
                } else if (clp >= this.loopLen) {
                    as = this.slice;
                    if (as != null) {
                        as = as.getNext();
                    }
                    this.slice = as;
                    if (as != null) {
                        clp -= this.loopLen;
                        this.loopPos = as.getOffset();
                        this.loopLen = as.getLength();
                        clp %= this.loopLen;
                    } else {
                        this.loop = false;
                    }
                }
                this.ctp = this.loopPos + clp;
            }
            this.asm.get(this.ctp, this.vol, this.out, o);
            o += this.nc;
            this.tim += this.tpo;
            double p = this.tm.get(this.tim);
            if (p != p) {
                p = this.pos;
            }
            if ((d = p - this.pos) > this.skipFwd || d < this.skipBwd) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Needle skip: d=" + d + ", p=" + p + ", t=" + this.tim);
                }
                this.pos = p;
                this.ctp += d * this.pitch;
                this.vel = 0.0;
                this.vol = 0.0;
                continue;
            }
            this.vel = (this.vel * 3.0 + d) / 4.0;
            this.pos += this.vel;
            this.vol = Math.abs(this.vel) * this.vvf;
        }
    }

    public void shutdown() throws AudioException {
        try {
            this.asm.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            this.tm.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public final int getChannels() {
        return this.nc;
    }

    public final float getFrameRate() {
        return this.rate;
    }

    public AudioScratchModel getAudioScratchModel() {
        return this.asm;
    }

    public ScratchModel getScratchModel() {
        return this.asm;
    }

    public void setAudioScratchModel(AudioScratchModel model) {
        int chs = model.getChannels();
        if (chs != this.nc) {
            throw new IllegalArgumentException("Invalid number of audio model channels: " + chs + " != " + this.nc);
        }
        this.asm = model;
        switch (this.pitchMode) {
            case 2: {
                this.applyPitchBPM();
                break;
            }
            case 3: {
                this.applyPitchDeck();
            }
        }
    }

    public double getPosition() {
        return this.pos;
    }

    public double getVelocity() {
        return this.vel;
    }

    public double getOffset() {
        return this.ctp;
    }

    public double getOrigin() {
        return this.ori;
    }

    public void setOrigin(double v) {
        this.ori = v;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
        this.vvf = this.nvf * volume;
    }

    public double getPitch() {
        return this.pitch;
    }

    protected void applyPitch() {
        this.pitch = this.primaryPitch * this.secondaryPitch;
    }

    public int getPitchMode() {
        return this.pitchMode;
    }

    public void setPitchMode(int mode) {
        if (this.pitchMode == mode) {
            return;
        }
        this.pitchMode = mode;
        switch (mode) {
            case 2: {
                this.applyPitchBPM();
                break;
            }
            case 3: {
                this.applyPitchDeck();
                break;
            }
            case 1: {
                this.primaryPitch = this.pitchCustom;
                this.applyPitch();
                break;
            }
            default: {
                this.primaryPitch = 1.0;
                this.applyPitch();
            }
        }
    }

    public double getPitchCustom() {
        return this.pitchCustom;
    }

    public void setPitchCustom(double factor) {
        this.pitchCustom = factor;
        if (this.pitchMode == 1) {
            this.primaryPitch = factor;
            this.applyPitch();
        }
    }

    public double getPitchBPM() {
        return this.pitchBPM;
    }

    public void setPitchBPM(double pitchBPM) {
        this.pitchBPM = pitchBPM;
        if (this.pitchMode == 2) {
            this.applyPitchBPM();
        }
    }

    public PitchDeck getPitchDeck() {
        return this.pitchDeck;
    }

    public void setPitchDeck(PitchDeck pitchDeck) {
        this.pitchDeck = pitchDeck;
        if (this.pitchMode == 3) {
            this.applyPitchDeck();
        }
    }

    public double getSecondaryPitch() {
        return this.secondaryPitch;
    }

    public void setSecondaryPitch(double factor) {
        if (this.secondaryPitch == factor) {
            return;
        }
        this.secondaryPitch = factor;
        this.applyPitch();
    }

    protected void applyPitchBPM() {
        double sourceBPM = this.asm.getBPM();
        if (sourceBPM > 0.0) {
            double factor = this.pitchBPM / sourceBPM;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("applyPitchBPM: sourceBPM=" + sourceBPM + ", targetBPM=" + this.pitchBPM + ", pitch=" + factor);
            }
            if (factor >= -8.0 && factor <= 8.0) {
                this.primaryPitch = factor;
                this.applyPitch();
                return;
            }
        }
        this.primaryPitch = this.pitchCustom;
        this.applyPitch();
    }

    protected void applyPitchDeck() {
        double deckBPM;
        PitchDeck deck;
        double sourceBPM = this.asm.getBPM();
        if (sourceBPM > 0.0 && (deck = this.pitchDeck) != null && (deckBPM = deck.getDeckBPM()) > 0.0) {
            double factor = deckBPM / sourceBPM;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("applyPitchDeck: sourceBPM=" + sourceBPM + ", targetBPM=" + deckBPM + ", pitch=" + factor);
            }
            if (factor >= -8.0 && factor <= 8.0) {
                this.primaryPitch = factor;
                this.applyPitch();
                return;
            }
        }
        this.primaryPitch = this.pitchCustom;
        this.applyPitch();
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public double getLoopPosition() {
        return this.loopPos;
    }

    public void setLoopPosition(double loopPos) {
        this.loopPos = loopPos;
    }

    public double getLoopLength() {
        return this.loopLen;
    }

    public void setLoopLength(double loopLen) {
        this.loopLen = loopLen;
    }

    public AudioSlice getSlice() {
        return this.slice;
    }

    public void setSlice(AudioSlice slice) {
        this.slice = slice;
        if (slice == null) {
            this.loop = false;
        } else {
            this.loopPos = slice.getOffset();
            this.loopLen = slice.getLength();
            this.loop = true;
        }
    }
}

