/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.scratch.impl;

import com.waxmonster.fader.FaderCurve;
import com.waxmonster.scratch.ScratchMeta;

public class DefaultScratchMeta
implements ScratchMeta {
    protected int type;
    protected int size;
    protected byte[] data;

    protected DefaultScratchMeta() {
    }

    public DefaultScratchMeta(int type, int size, byte[] data) {
        this();
        this.type = type;
        this.size = size;
        this.data = data;
    }

    public String toString() {
        return super.toString() + "[type=0x" + Integer.toHexString(this.type) + ", size=" + this.size + "]";
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }

    public int getSize() {
        return this.size;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    protected byte[] getData() {
        return this.data;
    }

    protected void setData(byte[] data) {
        this.data = data;
    }

    public void read(int ofs, byte[] dst, int off, int len) throws ArrayIndexOutOfBoundsException {
        System.arraycopy(this.data, ofs, dst, off, len);
    }

    public static ScratchMeta parseScratchMeta(int type, int size, byte[] data) {
        switch (type) {
            case 128: {
                return new LoadSongImpl(type, size, data);
            }
            case 144: {
                return new SetLineFaderModeImpl(type, size, data);
            }
            case 145: {
                return new SetLineFaderCurveImpl(type, size, data);
            }
            case 146: {
                return new SetCrossFaderModeImpl(type, size, data);
            }
            case 147: {
                return new SetCrossFaderCurveImpl(type, size, data);
            }
            case 160: {
                return new SetCuePointImpl(type, size, data);
            }
        }
        return new DefaultScratchMeta(type, size, data);
    }

    public static class SetCuePointImpl
    extends CuePointImpl
    implements ScratchMeta.SetCuePoint {
        public SetCuePointImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static abstract class CuePointImpl
    extends DefaultScratchMeta
    implements ScratchMeta.CuePoint {
        protected int cuePoint;

        public CuePointImpl(int type, int size, byte[] data) {
            super(type, size, data);
            if (size > 0) {
                this.cuePoint = data[0] & 0xFF;
            }
        }

        public int getCuePoint() {
            return this.cuePoint;
        }
    }

    public static class SetCrossFaderCurveImpl
    extends SetFaderCurveImpl
    implements ScratchMeta.SetCrossFaderCurve {
        public SetCrossFaderCurveImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class SetCrossFaderModeImpl
    extends SetFaderModeImpl
    implements ScratchMeta.SetCrossFaderMode {
        public SetCrossFaderModeImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class SetLineFaderCurveImpl
    extends SetFaderCurveImpl
    implements ScratchMeta.SetLineFaderCurve {
        public SetLineFaderCurveImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class SetLineFaderModeImpl
    extends SetFaderModeImpl
    implements ScratchMeta.SetLineFaderMode {
        public SetLineFaderModeImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static abstract class SetFaderCurveImpl
    extends DefaultScratchMeta
    implements ScratchMeta.SetFaderCurve {
        protected FaderCurve faderCurve;

        public SetFaderCurveImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }

        public FaderCurve getFaderCurve() {
            return this.faderCurve;
        }
    }

    public static abstract class SetFaderModeImpl
    extends DefaultScratchMeta
    implements ScratchMeta.SetFaderMode {
        protected int faderMode = 1;

        public SetFaderModeImpl(int type, int size, byte[] data) {
            super(type, size, data);
            if (size > 0) {
                this.faderMode = data[0] & 0xFF;
            }
        }

        public int getFaderMode() {
            return this.faderMode;
        }
    }

    public static class LoadSongImpl
    extends DefaultScratchMeta
    implements ScratchMeta.LoadSong {
        public LoadSongImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }
}

