/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.scratch.impl;

import com.waxmonster.scratch.ScratchMeta;
import com.waxmonster.scratch.ScratchMetaModel;
import com.waxmonster.scratch.ScratchMetaNode;
import com.waxmonster.scratch.ScratchMetaNodeConsumer;
import com.waxmonster.scratch.impl.DefaultScratchMetaNode;

public class DefaultScratchMetaModel
implements ScratchMetaModel {
    protected DefaultScratchMetaNode[] nodes;
    protected int size;
    protected DefaultScratchMetaNode scratchFirst;
    protected DefaultScratchMetaNode scratchLast;

    public DefaultScratchMetaModel(int initCapacity) {
        this.nodes = new DefaultScratchMetaNode[initCapacity];
        this.size = 0;
    }

    public ScratchMetaNode scratchFirst() {
        return this.scratchFirst;
    }

    public ScratchMetaNode scratchLast() {
        return this.scratchLast;
    }

    public ScratchMetaNode scratchPrev(ScratchMetaNode node) {
        return ((DefaultScratchMetaNode)node).scratchPrev;
    }

    public ScratchMetaNode scratchNext(ScratchMetaNode node) {
        return ((DefaultScratchMetaNode)node).scratchNext;
    }

    public boolean isEmpty() {
        return this.size < 1;
    }

    public int getNodeCount() {
        return this.size;
    }

    protected ScratchMetaNode getNodeAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index < this.size) {
            return this.nodes[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    protected int nodeIndex(long tick) {
        int lo = 0;
        int hi = this.size - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            if (this.nodes[i].tick < tick) {
                lo = i + 1;
                continue;
            }
            hi = i - 1;
        }
        return lo;
    }

    protected int nodeIndex(ScratchMetaNode node) {
        if (node == null) {
            return -1;
        }
        DefaultScratchMetaNode n = (DefaultScratchMetaNode)node;
        long t = n.tick;
        int index = this.nodeIndex(t);
        int siz = this.size;
        for (int i = index; i < siz; ++i) {
            DefaultScratchMetaNode x = this.nodes[i];
            if (x == node) {
                return i;
            }
            if (x.tick != t) break;
        }
        return -1;
    }

    public boolean containsNode(ScratchMetaNode node) {
        return this.nodeIndex(node) >= 0;
    }

    public ScratchMetaNode newNode(long tick, ScratchMeta meta) {
        return new DefaultScratchMetaNode(tick, meta);
    }

    public int getNodeCount(long ofs, long end) {
        throw new UnsupportedOperationException("TODO");
    }

    public int getNodes(long ofs, long end, ScratchMetaNodeConsumer dst) {
        throw new UnsupportedOperationException("TODO");
    }

    public int getNodes(long ofs, long end, ScratchMetaNode[] dst, int x, int z) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean addNode(ScratchMetaNode node) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean removeNode(ScratchMetaNode node) {
        throw new UnsupportedOperationException("TODO");
    }

    public int removeNodes(long ofs, long end) {
        throw new UnsupportedOperationException("TODO");
    }

    public int removeAllNodes() {
        throw new UnsupportedOperationException("TODO");
    }

    public void checkIntegrity() throws IllegalStateException {
        throw new UnsupportedOperationException("TODO");
    }
}

