/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.scratch.impl;

import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioSlice;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.scratch.ScratchModel;
import com.waxmonster.scratch.TimecodeScratchModel;
import com.waxmonster.scratch.impl.AbstractAudioScratchPlayer;
import com.waxmonster.scratch.impl.DefaultAudioScratchPlayer;

public class RealAudioScratchPlayer
extends AbstractAudioScratchPlayer {
    private final int nc;
    private final float rate;
    private final AbstractAudioScratchPlayer asp;
    private AudioScratchModel asm;
    private double[] tb;
    private long tp;
    private int tn;

    public RealAudioScratchPlayer(double[] timecodeBuffer, DoubleArraySampleBuffer audioOutput, double skipThreshold, AudioScratchModel audioScratchModel, double startFramePos, double volume, int pitchMode, double pitchFactor, double pitchBPM, PitchDeck pitchDeck) throws AudioException {
        if (audioOutput == null) {
            throw new NullPointerException("audioOutput is null");
        }
        int outputChannels = audioOutput.getChannels();
        if (outputChannels < 1) {
            throw new AudioException("Invalid number of audio output channels: " + outputChannels + " < 1");
        }
        float outputFrameRate = audioOutput.getFrameRate();
        this.nc = audioOutput.getChannels();
        this.rate = audioOutput.getFrameRate();
        this.asm = audioScratchModel;
        TsModel tsModel = new TsModel(outputFrameRate);
        this.tb = timecodeBuffer;
        this.tn = 1;
        this.tp = 0L;
        double tcStartFramePos = 0.0;
        double tcInitVelocity = 0.0;
        double tcInitVolume = 0.0;
        this.asp = this.createAudioScratchPlayer(audioOutput, tsModel, tcStartFramePos, tcInitVelocity, tcInitVolume, audioScratchModel, startFramePos, volume, pitchMode, pitchFactor, pitchBPM, pitchDeck, skipThreshold);
    }

    protected AbstractAudioScratchPlayer createAudioScratchPlayer(DoubleArraySampleBuffer audioOutput, TsModel tsModel, double tcStartFramePos, double tcInitVelocity, double tcInitVolume, AudioScratchModel audioScratchModel, double startTrackPos, double volume, int pitchMode, double pitchFactor, double pitchBPM, PitchDeck pitchDeck, double skipThreshold) {
        return new DefaultAudioScratchPlayer(tsModel, tcStartFramePos, tcInitVelocity, tcInitVolume, audioScratchModel, startTrackPos, volume, pitchMode, pitchFactor, pitchBPM, pitchDeck, audioOutput, skipThreshold);
    }

    public void process(long time, int frames) throws AudioException {
        this.tp += (long)this.tn;
        this.tn = frames;
        this.asp.process(time, frames);
    }

    public void shutdown() throws AudioException {
        this.tn = 0;
        this.tp = 0L;
        this.asp.shutdown();
    }

    public final int getChannels() {
        return this.nc;
    }

    public final float getFrameRate() {
        return this.rate;
    }

    public ScratchModel getScratchModel() {
        return this.asm;
    }

    public AudioScratchModel getAudioScratchModel() {
        return this.asm;
    }

    public synchronized void setAudioScratchModel(AudioScratchModel model) {
        if (model == this.asm) {
            return;
        }
        this.asp.setAudioScratchModel(model);
        this.asm = model;
    }

    public double getPosition() {
        return this.asp.getPosition();
    }

    public double getVelocity() {
        return this.asp.getVelocity();
    }

    public double getOffset() {
        return this.asp.getOffset();
    }

    public double getOrigin() {
        return this.asp.getOrigin();
    }

    public void setOrigin(double v) {
        this.asp.setOrigin(v);
    }

    public double getVolume() {
        return this.asp.getVolume();
    }

    public void setVolume(double volume) {
        this.asp.setVolume(volume);
    }

    public double getPitch() {
        return this.asp.getPitch();
    }

    public int getPitchMode() {
        return this.asp.getPitchMode();
    }

    public void setPitchMode(int pm) {
        this.asp.setPitchMode(pm);
    }

    public double getPitchCustom() {
        return this.asp.getPitchCustom();
    }

    public void setPitchCustom(double pitch) {
        this.asp.setPitchCustom(pitch);
    }

    public double getPitchBPM() {
        return this.asp.getPitchBPM();
    }

    public void setPitchBPM(double bpm) {
        this.asp.setPitchBPM(bpm);
    }

    public PitchDeck getPitchDeck() {
        return this.asp.getPitchDeck();
    }

    public void setPitchDeck(PitchDeck deck) {
        this.asp.setPitchDeck(deck);
    }

    public double getSecondaryPitch() {
        return this.asp.getSecondaryPitch();
    }

    public void setSecondaryPitch(double factor) {
        this.asp.setSecondaryPitch(factor);
    }

    public AudioSlice getSlice() {
        return this.asp.getSlice();
    }

    public void setSlice(AudioSlice slice) {
        this.asp.setSlice(slice);
    }

    protected class TsModel
    implements TimecodeScratchModel {
        private final float rate;

        public TsModel(float frameRate) {
            this.rate = frameRate;
        }

        public float getFrameRate() {
            return this.rate;
        }

        public void close() {
        }

        public void reload(long p, long q) {
            throw new UnsupportedOperationException();
        }

        public double get(double p) {
            int i = (int)(p - (double)RealAudioScratchPlayer.this.tp);
            if (i < 0) {
                throw new IllegalArgumentException("get: p=" + p + ", i=" + i + " < 0");
            }
            if (i >= RealAudioScratchPlayer.this.tn) {
                throw new IllegalArgumentException("get: p=" + p + ", i=" + i + " >= " + RealAudioScratchPlayer.this.tn);
            }
            return RealAudioScratchPlayer.this.tb[i];
        }
    }
}

