/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.system.Helpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileOrPackedInputStream
extends InputStream {
    protected InputStream stream;
    private ZipEntry entry;

    public FileOrPackedInputStream(File file) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            try {
                this.stream = this.tryForZippedFile(file.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new FileNotFoundException(file.getCanonicalPath());
            }
        } else {
            this.stream = new FileInputStream(file);
        }
    }

    public FileOrPackedInputStream(String fileName) throws IOException, FileNotFoundException {
        this(new File(fileName));
    }

    public FileOrPackedInputStream(URL fromUrl) throws IOException, FileNotFoundException {
        try {
            this.stream = fromUrl.openStream();
        }
        catch (AccessControlException ex) {
            throw new AccessControlException("[FileOrPackedInputStream] Access denied: " + fromUrl.toString());
        }
        catch (Exception ex) {
            this.stream = this.tryForZippedFile(fromUrl);
        }
    }

    private InputStream tryForZippedFile(URL fromUrl) throws IOException {
        int slashIndex;
        String path = fromUrl.toString();
        String fileNamePortion = "";
        while (path != null && path.length() != 0 && (slashIndex = path.lastIndexOf(47)) >= 0) {
            ZipEntry entry;
            fileNamePortion = Helpers.createStringFromURLString(path.substring(slashIndex)) + fileNamePortion;
            path = path.substring(0, slashIndex);
            URL newUrl = new URL(path);
            ZipInputStream input = null;
            try {
                input = new ZipInputStream(newUrl.openStream());
            }
            catch (Throwable e) {
                continue;
            }
            String zipEntryName = fileNamePortion.substring(1);
            while ((entry = input.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().equals(zipEntryName)) continue;
                this.entry = entry;
                return input;
            }
        }
        throw new FileNotFoundException(fromUrl.toString());
    }

    public ZipEntry getEntry() {
        return this.entry;
    }

    @Override
    public int available() throws IOException {
        if (this.entry == null) {
            return this.stream.available();
        }
        return (int)this.entry.getSize();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }
}

