/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.SoundOutputStreamImpl;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.system.Log;
import java.io.File;
import javax.sound.sampled.AudioFormat;

public class GaplessSoundOutputStreamImpl
extends SoundOutputStreamImpl {
    public GaplessSoundOutputStreamImpl() {
    }

    public GaplessSoundOutputStreamImpl(AudioFormat audioFormat, AudioProcessor audioProcessor, File exportFile, boolean playDuringExport, boolean keepSilent) {
        super(audioFormat, audioProcessor, exportFile, playDuringExport, keepSilent);
    }

    @Override
    protected synchronized void openSourceLine() {
        try {
            if (this.audioFormat != null && (this.sourceLine == null || this.sourceLine != null && !this.sourceLine.getFormat().matches(this.audioFormat))) {
                super.openSourceLine();
            } else if (this.sourceLine != null) {
                if (!this.sourceLine.isOpen()) {
                    this.sourceLine.open();
                }
                if (!this.sourceLine.isRunning()) {
                    this.sourceLine.start();
                }
            }
        }
        catch (Exception ex) {
            this.sourceLine = null;
            Log.error("Error occured when opening audio device", ex);
        }
    }

    @Override
    public synchronized void open() {
        this.close();
        if (this.playDuringExport || this.exportFile == null) {
            this.openSourceLine();
        } else {
            this.openAudioProcessor();
        }
        this.openExportFile();
    }

    @Override
    public synchronized void close() {
        if (!this.playDuringExport && this.exportFile != null) {
            this.closeAudioProcessor();
        }
        this.closeExportFile();
    }

    @Override
    public synchronized void closeAllDevices() {
        super.close();
    }

    @Override
    public synchronized void changeAudioFormatTo(AudioFormat newAudioFormat) {
        if (this.audioFormat == null || !this.audioFormat.matches(newAudioFormat)) {
            super.changeAudioFormatTo(newAudioFormat);
        }
    }
}

