/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.PowerPackerFile;
import de.quippy.javamod.io.RandomAccessInputStreamImpl;
import de.quippy.javamod.io.XpkSqsh;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ModfileInputStream
extends RandomAccessInputStreamImpl {
    private String fileName;

    public ModfileInputStream(File file) throws FileNotFoundException, IOException {
        super(file);
        this.fileName = file.getAbsolutePath();
        this.checkForPackedFiles();
    }

    public ModfileInputStream(String fileName) throws FileNotFoundException, IOException {
        super(fileName);
        this.fileName = fileName;
        this.checkForPackedFiles();
    }

    public ModfileInputStream(URL fromUrl) throws IOException, FileNotFoundException, MalformedURLException {
        super(fromUrl);
        this.fileName = Helpers.createLocalFileStringFromURL(fromUrl, false);
        this.checkForPackedFiles();
    }

    public String getFileName() {
        return this.fileName;
    }

    private void checkForPackedFiles() {
        try {
            if (PowerPackerFile.isPowerPacker(this)) {
                PowerPackerFile ppFile = new PowerPackerFile(this);
                this.close();
                this.tmpFile = null;
                this.raFile = null;
                this.buffer = ppFile.getBuffer();
                this.bufferLength = this.buffer.length;
                this.readPointer = 0;
            } else if (XpkSqsh.isXPK_SQSH(this)) {
                XpkSqsh xpkSqshFile = new XpkSqsh(this);
                this.close();
                this.tmpFile = null;
                this.raFile = null;
                this.buffer = xpkSqshFile.getBuffer();
                this.bufferLength = this.buffer.length;
                this.readPointer = 0;
            }
        }
        catch (IOException ex) {
            Log.error("ModfileInputStream::checkForPowerPackerFile", ex);
        }
    }

    public String readString(int strLength) throws IOException {
        byte[] buffer = new byte[strLength];
        int read = this.read(buffer, 0, strLength);
        return Helpers.retrieveAsString(buffer, 0, read);
    }

    public int readByteAsInt() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readMotorolaWord() throws IOException {
        return (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readIntelWord() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8;
    }

    public int readMotorolaDWord() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readIntelDWord() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 24;
    }
}

