/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class PowerPackerFile {
    private byte[] buffer;

    public PowerPackerFile(RandomAccessInputStream input) throws IOException {
        this.buffer = this.readAndUnpack(input);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public static boolean isPowerPacker(RandomAccessInputStream input) throws IOException {
        long pos = input.getFilePointer();
        input.seek(0L);
        byte[] ppId = new byte[4];
        input.read(ppId, 0, 4);
        input.seek(pos);
        return Helpers.retrieveAsString(ppId, 0, 4).equals("PP20");
    }

    private void pp20DoUnpack(RandomAccessInputStream source, byte[] buffer) throws IOException {
        BitBuffer bitBuffer = new BitBuffer(source, (int)source.getLength() - 4);
        source.seek(source.getLength() - 1L);
        int skip = source.read();
        bitBuffer.getBits(skip);
        int nBytesLeft = buffer.length;
        block0: while (nBytesLeft > 0) {
            int nofs;
            int n;
            if (bitBuffer.getBits(1) == 0) {
                int code;
                for (n = 1; n < nBytesLeft; n += code) {
                    code = bitBuffer.getBits(2);
                    if (code == 3) continue;
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    buffer[--nBytesLeft] = (byte)bitBuffer.getBits(8);
                }
                if (nBytesLeft == 0) break;
            }
            source.seek(n + 3);
            int nbits = source.read();
            if (n == 4) {
                int code;
                nofs = bitBuffer.getBits(bitBuffer.getBits(1) != 0 ? nbits : 7);
                for (n = bitBuffer.getBits(2) + 1; n < nBytesLeft; n += code) {
                    code = bitBuffer.getBits(3);
                    if (code == 7) continue;
                    break;
                }
            } else {
                nofs = bitBuffer.getBits(nbits);
            }
            for (int i = 0; i <= n; ++i) {
                byte by = buffer[nBytesLeft - 1] = nBytesLeft + nofs < buffer.length ? buffer[nBytesLeft + nofs] : (byte)0;
                if (--nBytesLeft == 0) continue block0;
            }
        }
    }

    private byte[] readAndUnpack(RandomAccessInputStream source) throws IOException {
        source.seek(0L);
        int PP20ID = source.read() << 24 | source.read() << 16 | source.read() << 8 | source.read();
        int length = (int)source.getLength();
        if (length < 256 || PP20ID != 1347433008) {
            throw new IOException("Not a powerpacker file!");
        }
        source.seek(length - 4);
        int destLen = source.read() << 16 | source.read() << 8 | source.read();
        if (destLen < 512 || destLen > 0x400000 || destLen > length << 3) {
            throw new IOException("Length of " + length + " is not supported!");
        }
        byte[] dstBuffer = new byte[destLen];
        this.pp20DoUnpack(source, dstBuffer);
        return dstBuffer;
    }

    private static class BitBuffer {
        private RandomAccessInputStream source;
        private int filePointer;
        private int bitCount;
        private int bitBuffer;

        public BitBuffer(RandomAccessInputStream source, int filePointer) {
            this.source = source;
            this.filePointer = filePointer;
            this.bitCount = 0;
            this.bitBuffer = 0;
        }

        public int getBits(int n) throws IOException {
            int result = 0;
            for (int i = 0; i < n; ++i) {
                if (this.bitCount == 0) {
                    this.bitCount = 8;
                    if (this.filePointer > 3) {
                        --this.filePointer;
                    }
                    this.source.seek(this.filePointer);
                    this.bitBuffer = this.source.read();
                }
                result = result << 1 | this.bitBuffer & 1;
                this.bitBuffer >>= 1;
                --this.bitCount;
            }
            return result;
        }
    }
}

