/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.system.Log;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class RandomAccessInputStreamImpl
extends InputStream
implements RandomAccessInputStream {
    protected RandomAccessFile raFile = null;
    protected File localFile = null;
    protected File tmpFile = null;
    protected int mark = 0;
    protected byte[] buffer = null;
    protected int readPointer = 0;
    protected int bufferLength = 0;

    public RandomAccessInputStreamImpl(File file) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            file = this.unpackFromZIPFile(file.toURI().toURL());
        }
        this.localFile = file;
        this.raFile = new RandomAccessFile(this.localFile, "r");
    }

    public RandomAccessInputStreamImpl(String fileName) throws IOException, FileNotFoundException {
        this(new File(fileName));
    }

    public RandomAccessInputStreamImpl(URL fromUrl) throws IOException, FileNotFoundException {
        if (fromUrl.getProtocol().equalsIgnoreCase("file")) {
            try {
                File file = new File(fromUrl.toURI());
                if (!file.exists()) {
                    file = this.unpackFromZIPFile(fromUrl);
                }
                this.localFile = file;
                this.raFile = new RandomAccessFile(this.localFile, "r");
            }
            catch (URISyntaxException uriEx) {
                throw new MalformedURLException(uriEx.getMessage());
            }
        }
        FileOrPackedInputStream inputStream = new FileOrPackedInputStream(fromUrl);
        try {
            this.tmpFile = this.copyFullStream(inputStream);
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException ex) {
                Log.error("IGNORED", ex);
            }
            this.localFile = this.tmpFile;
            this.raFile = new RandomAccessFile(this.localFile, "r");
        }
        catch (Throwable ex) {
            int size = ((InputStream)inputStream).available();
            if (size < 1024) {
                size = 1024;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(size);
            this.copyFullStream(inputStream, out);
            ((InputStream)inputStream).close();
            out.close();
            this.buffer = out.toByteArray();
            this.bufferLength = this.buffer.length;
            this.readPointer = 0;
            this.raFile = null;
            this.localFile = null;
        }
    }

    private File unpackFromZIPFile(URL fromUrl) throws IOException, FileNotFoundException {
        FileOrPackedInputStream input = new FileOrPackedInputStream(fromUrl);
        return this.copyFullStream(input);
    }

    private File copyFullStream(InputStream input) throws IOException {
        this.tmpFile = File.createTempFile("JavaMod", "ReadFile");
        this.tmpFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(this.tmpFile);
        this.copyFullStream(input, out);
        out.close();
        return this.tmpFile;
    }

    private void copyFullStream(InputStream inputStream, OutputStream out) throws IOException {
        int len;
        byte[] input = new byte[8192];
        while ((len = inputStream.read(input, 0, 8192)) != -1) {
            out.write(input, 0, len);
        }
    }

    @Override
    public File getFile() {
        return this.localFile;
    }

    @Override
    public int available() throws IOException {
        if (this.raFile != null) {
            return (int)(this.raFile.length() - this.raFile.getFilePointer());
        }
        return this.bufferLength - this.readPointer;
    }

    @Override
    public void close() throws IOException {
        boolean ok;
        if (this.raFile != null) {
            this.raFile.close();
        }
        super.close();
        if (this.tmpFile != null && !(ok = this.tmpFile.delete())) {
            Log.error("Could not delete temporary file: " + this.tmpFile.getCanonicalPath());
        }
        this.raFile = null;
        this.buffer = null;
        this.bufferLength = 0;
        this.readPointer = 0;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.raFile != null ? (int)this.raFile.getFilePointer() : this.readPointer;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.raFile != null) {
            return this.raFile.read();
        }
        return this.readPointer < this.bufferLength ? this.buffer[this.readPointer++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.raFile != null) {
            return this.raFile.read(b, off, len);
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readPointer >= this.bufferLength) {
            return -1;
        }
        if (this.readPointer + len > this.bufferLength) {
            len = this.bufferLength - this.readPointer;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.readPointer, b, off, len);
        this.readPointer += len;
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.raFile != null) {
            this.raFile.seek(this.mark);
        } else {
            this.readPointer = this.mark;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.raFile != null) {
            return this.raFile.skipBytes((int)n);
        }
        if ((long)this.readPointer + n > (long)this.bufferLength) {
            n = this.bufferLength - this.readPointer;
        }
        if (n < 0L) {
            return 0L;
        }
        this.readPointer = (int)((long)this.readPointer + n);
        return n;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public long getFilePointer() throws IOException {
        if (this.raFile != null) {
            return this.raFile.getFilePointer();
        }
        return this.readPointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.raFile != null) {
            this.raFile.seek(pos);
        } else {
            this.readPointer = (int)pos;
        }
    }

    @Override
    public byte readByte() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readByte();
        }
        return (byte)this.read();
    }

    @Override
    public long getLength() throws IOException {
        if (this.raFile != null) {
            return this.raFile.length();
        }
        return this.bufferLength;
    }

    @Override
    public long length() throws IOException {
        return this.getLength();
    }

    @Override
    public int readFully(byte[] b) throws IOException {
        if (this.raFile != null) {
            this.raFile.readFully(b);
            return b.length;
        }
        return this.read(b);
    }

    @Override
    public int readFully(byte[] b, int offs, int len) throws IOException {
        if (this.raFile != null) {
            this.raFile.readFully(b, offs, len);
            return len;
        }
        return this.read(b, offs, len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readBoolean();
        }
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        if (this.raFile != null) {
            return this.raFile.readChar();
        }
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)(ch1 << 8 | ch2);
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        if (this.raFile != null) {
            return this.raFile.readShort();
        }
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)(ch1 << 8 | ch2);
    }

    @Override
    public double readDouble() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readDouble();
        }
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readFloat();
        }
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        if (this.raFile != null) {
            return this.raFile.readInt();
        }
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4;
    }

    @Override
    public String readLine() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readLine();
        }
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public long readLong() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readLong();
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readUnsignedByte();
        }
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        if (this.raFile != null) {
            return this.raFile.readUnsignedShort();
        }
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return ch1 << 8 | ch2;
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        if (this.raFile != null) {
            return this.raFile.readUTF();
        }
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }
}

