/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.SoundOutputStream;
import de.quippy.javamod.io.wav.WaveFile;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class SoundOutputStreamImpl
implements SoundOutputStream {
    protected AudioProcessor audioProcessor;
    protected AudioFormat audioFormat;
    protected File exportFile;
    protected float currentVolume;
    protected float currentBalance;
    protected SourceDataLine sourceLine;
    protected WaveFile waveExportFile;
    protected boolean playDuringExport;
    protected boolean keepSilent;

    protected SoundOutputStreamImpl() {
    }

    public SoundOutputStreamImpl(AudioFormat audioFormat, AudioProcessor audioProcessor, File exportFile, boolean playDuringExport, boolean keepSilent) {
        this();
        this.audioFormat = audioFormat;
        this.audioProcessor = audioProcessor;
        this.exportFile = exportFile;
        this.playDuringExport = playDuringExport;
        this.keepSilent = keepSilent;
    }

    protected synchronized void openSourceLine() {
        if (this.audioFormat != null) {
            try {
                this.closeSourceLine();
                this.closeAudioProcessor();
                DataLine.Info sourceLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
                if (AudioSystem.isLineSupported(sourceLineInfo)) {
                    sourceLineInfo.getFormats();
                    this.sourceLine = (SourceDataLine)AudioSystem.getLine(sourceLineInfo);
                    this.sourceLine.open();
                    this.sourceLine.start();
                    this.setVolume(this.currentVolume);
                    this.setBalance(this.currentBalance);
                    this.openAudioProcessor();
                } else {
                    Log.info("Audioformat is not supported");
                }
            }
            catch (Exception ex) {
                this.sourceLine = null;
                Log.error("Error occured when opening audio device", ex);
            }
        }
    }

    protected synchronized void openAudioProcessor() {
        if (this.audioProcessor != null) {
            if (this.sourceLine != null) {
                this.audioProcessor.initializeProcessor(this.sourceLine);
                this.audioProcessor.setUseInternalCounter(this.keepSilent);
            } else {
                this.audioProcessor.initializeProcessor(this.audioFormat);
                this.audioProcessor.setUseInternalCounter(true);
            }
        }
    }

    protected synchronized void openExportFile() {
        if (this.exportFile != null) {
            this.waveExportFile = new WaveFile();
            if (this.waveExportFile.openForWrite(this.exportFile, this.audioFormat) != 0) {
                this.waveExportFile = null;
                Log.error("Creation of exportfile was NOT successfull!");
            }
        }
    }

    protected synchronized void closeSourceLine() {
        if (this.sourceLine != null) {
            this.stopLine();
            this.sourceLine.close();
            this.sourceLine = null;
        }
    }

    protected synchronized void closeAudioProcessor() {
        if (this.audioProcessor != null) {
            this.audioProcessor.stop();
        }
    }

    protected synchronized void closeExportFile() {
        if (this.waveExportFile != null) {
            this.waveExportFile.close();
        }
    }

    @Override
    public synchronized void open() {
        this.close();
        if (this.playDuringExport || this.exportFile == null) {
            this.openSourceLine();
        }
        this.openAudioProcessor();
        this.openExportFile();
    }

    @Override
    public synchronized void close() {
        this.closeSourceLine();
        this.closeAudioProcessor();
        this.closeExportFile();
    }

    @Override
    public synchronized void closeAllDevices() {
        this.close();
    }

    @Override
    public synchronized boolean isInitialized() {
        return this.sourceLine != null && this.sourceLine.isOpen() || this.exportFile != null;
    }

    @Override
    public synchronized void startLine() {
        if (this.sourceLine != null) {
            this.sourceLine.flush();
            this.sourceLine.start();
        }
    }

    @Override
    public synchronized void stopLine() {
        if (this.sourceLine != null) {
            if (this.sourceLine.isRunning()) {
                this.sourceLine.drain();
            }
            this.sourceLine.stop();
        }
    }

    protected synchronized void writeSampleDataInternally(byte[] samples, int start, int length) {
        if (this.sourceLine != null && !this.keepSilent) {
            this.sourceLine.write(samples, start, length);
        }
        if (this.waveExportFile != null) {
            this.waveExportFile.writeSamples(samples, start, length);
        }
    }

    @Override
    public synchronized void writeSampleData(byte[] samples, int start, int length) {
        if (this.audioProcessor != null) {
            int anzSamples = this.audioProcessor.writeSampleData(samples, start, length);
            this.writeSampleDataInternally(this.audioProcessor.getResultSampleBuffer(), 0, anzSamples);
        } else {
            this.writeSampleDataInternally(samples, start, length);
        }
    }

    @Override
    public synchronized void setInternalFramePosition(long newFramePosition) {
        if (this.audioProcessor != null) {
            this.audioProcessor.setInternalFramePosition(newFramePosition);
        }
    }

    @Override
    public synchronized long getFramePosition() {
        if (this.audioProcessor != null) {
            return this.audioProcessor.getFramePosition();
        }
        if (this.sourceLine != null) {
            return this.sourceLine.getLongFramePosition();
        }
        return -1L;
    }

    @Override
    public synchronized void setVolume(float gain) {
        if (this.currentVolume != gain) {
            this.currentVolume = gain;
            if (this.sourceLine != null && this.sourceLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                FloatControl gainControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.MASTER_GAIN);
                float dB = (float)Helpers.getDBValueFrom(gain);
                if (dB > gainControl.getMaximum()) {
                    dB = gainControl.getMaximum();
                } else if (dB < gainControl.getMinimum()) {
                    dB = gainControl.getMinimum();
                }
                gainControl.setValue(dB);
            }
        }
    }

    @Override
    public synchronized void setBalance(float balance) {
        if (this.currentBalance != balance) {
            FloatControl balanceControl;
            this.currentBalance = balance;
            if (this.sourceLine != null && this.sourceLine.isControlSupported(FloatControl.Type.BALANCE) && balance <= (balanceControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.BALANCE)).getMaximum() && balance >= balanceControl.getMinimum()) {
                balanceControl.setValue(balance);
            }
        }
    }

    @Override
    public synchronized void setAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessor = audioProcessor;
    }

    @Override
    public synchronized void setExportFile(File exportFile) {
        this.exportFile = exportFile;
    }

    @Override
    public synchronized void setWaveExportFile(WaveFile waveExportFile) {
        this.waveExportFile = waveExportFile;
    }

    @Override
    public synchronized void setPlayDuringExport(boolean playDuringExport) {
        this.playDuringExport = playDuringExport;
    }

    @Override
    public synchronized void setKeepSilent(boolean keepSilent) {
        this.keepSilent = keepSilent;
    }

    @Override
    public boolean matches(SoundOutputStream otherStream) {
        return this.getAudioFormat().matches(otherStream.getAudioFormat());
    }

    @Override
    public synchronized AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    @Override
    public synchronized void changeAudioFormatTo(AudioFormat newAudioFormat) {
        boolean reOpen = this.sourceLine != null && this.sourceLine.isOpen();
        this.close();
        this.audioFormat = newAudioFormat;
        if (reOpen) {
            this.open();
        }
    }
}

