/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.RandomAccessInputStream;
import java.io.IOException;

public class XpkSqsh {
    private static final int HEADER_LENGTH = 36;
    private static final byte[] OCTETS = new byte[]{2, 3, 4, 5, 6, 7, 8, 0, 3, 2, 4, 5, 6, 7, 8, 0, 4, 3, 5, 2, 6, 7, 8, 0, 5, 4, 6, 2, 3, 7, 8, 0, 6, 5, 7, 2, 3, 4, 8, 0, 7, 6, 8, 2, 3, 4, 5, 0, 8, 7, 6, 2, 3, 4, 5, 0};
    private byte[] buffer;

    public XpkSqsh(RandomAccessInputStream input) throws IOException {
        this.buffer = this.readAndUnpack(input);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public static boolean isXPK_SQSH(RandomAccessInputStream input) throws IOException {
        long pos = input.getFilePointer();
        input.seek(0L);
        byte[] xpkSqshId = new byte[12];
        input.read(xpkSqshId, 0, 12);
        input.seek(pos);
        if (xpkSqshId[0] != 88 || xpkSqshId[1] != 80 || xpkSqshId[2] != 75 || xpkSqshId[3] != 70) {
            return false;
        }
        return xpkSqshId[8] == 83 && xpkSqshId[9] == 81 && xpkSqshId[10] == 83 && xpkSqshId[11] == 72;
    }

    private byte[] readAndUnpack(RandomAccessInputStream source) throws IOException {
        source.seek(0L);
        return this.unpackData(source);
    }

    private boolean testData(byte[] a) {
        if (a.length < 12) {
            return false;
        }
        if (88 != a[0] || 80 != a[1] || 75 != a[2] || 70 != a[3]) {
            return false;
        }
        return 83 == a[8] && 81 == a[9] && 83 == a[10] && 72 == a[11];
    }

    private int getLength(byte[] a, int i) {
        return (a[i] & 0x7F) << 24 | (a[i + 1] & 0xFF) << 16 | (a[i + 2] & 0xFF) << 8 | a[i + 3] & 0xFF;
    }

    public byte[] unpackData(RandomAccessInputStream source) throws IOException {
        byte[] dst;
        byte[] data = new byte[16];
        source.read(data, 0, 16);
        int orig_length = this.getLength(data, 4);
        int target_length = this.getLength(data, 12);
        if (this.testData(data) && (long)orig_length == source.getLength() - 8L && this.unpack(source, dst = new byte[target_length], 36)) {
            return dst;
        }
        return null;
    }

    private boolean unpack(RandomAccessInputStream source, byte[] dst, int srcPos) throws IOException {
        int unpackedLength;
        source.seek(srcPos);
        for (int dstPos = 0; dstPos < dst.length; dstPos += unpackedLength) {
            int chunkType = source.read() & 0xFF;
            int headerChecksum = source.read() & 0xFF;
            int dataChecksum = (source.read() & 0xFF) << 8 | source.read() & 0xFF;
            int packedLength = (source.read() & 0xFF) << 8 | source.read() & 0xFF;
            unpackedLength = (source.read() & 0xFF) << 8 | source.read() & 0xFF;
            headerChecksum ^= chunkType;
            headerChecksum ^= dataChecksum >> 8 ^ dataChecksum & 0xFF;
            headerChecksum ^= packedLength >> 8 ^ packedLength & 0xFF;
            if ((headerChecksum ^= unpackedLength >> 8 ^ unpackedLength & 0xFF) != 0) {
                return false;
            }
            packedLength = packedLength + 3 & 0xFFFC;
            if (source.getFilePointer() + (long)packedLength + 1L > source.getLength()) {
                return false;
            }
            byte[] src = new byte[packedLength];
            if (source.read(src, 0, packedLength) != packedLength) {
                return false;
            }
            for (int i = 0; i < packedLength; i += 2) {
                dataChecksum ^= (src[i] & 0xFF) << 8 | src[i + 1] & 0xFF;
            }
            if (dataChecksum != 0) {
                return false;
            }
            if (dstPos + unpackedLength > dst.length) {
                return false;
            }
            if (chunkType == 0) {
                System.arraycopy(src, 0, dst, dstPos, unpackedLength);
                continue;
            }
            if (chunkType == 1) {
                if (this.unsqsh(src, 0, dst, dstPos, dstPos + unpackedLength)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean unsqsh(byte[] src, int srcPos, byte[] dst, int dstPos, int dstEnd) {
        if (dstEnd - dstPos != ((src[srcPos] & 0xFF) << 8 | src[srcPos + 1] & 0xFF)) {
            return false;
        }
        int expandCounter = 0;
        int expandCount = 0;
        int bitCount = 0;
        if (dstPos >= dst.length) {
            return false;
        }
        int n = dstPos++;
        byte by = src[srcPos + 2];
        dst[n] = by;
        byte last = by;
        BitData data = new BitData(src, srcPos + 3);
        while (dstPos < dstEnd) {
            boolean b1;
            boolean bl = b1 = data.getBit() == 1;
            if (b1 && expandCounter < 8 || !b1 && expandCounter >= 8 && data.getBit() == 0) {
                int count = this.getCopyCount(data);
                dstPos = this.copyBlock(data, dst, dstPos, count);
                last = dst[dstPos - 1];
                expandCounter -= count < 3 || expandCounter == 0 ? 0 : (count == 3 || expandCounter == 1 ? 1 : 2);
            } else {
                int n2 = expandCounter < 8 ? 8 : (bitCount = b1 ? bitCount : this.getExpandBitCount(data, bitCount));
                if (expandCounter >= 8 && (bitCount != 8 || expandCount >= 20)) {
                    if (bitCount != 8) {
                        if (dstPos < dst.length) {
                            int n3 = dstPos++;
                            byte by2 = (byte)(last - data.getSignBits(bitCount));
                            dst[n3] = by2;
                            last = by2;
                        }
                        if (dstPos < dst.length) {
                            int n4 = dstPos++;
                            byte by3 = (byte)(last - data.getSignBits(bitCount));
                            dst[n4] = by3;
                            last = by3;
                        }
                        if (dstPos < dst.length) {
                            int n5 = dstPos++;
                            byte by4 = (byte)(last - data.getSignBits(bitCount));
                            dst[n5] = by4;
                            last = by4;
                        }
                    }
                    if (dstPos < dst.length) {
                        int n6 = dstPos++;
                        byte by5 = (byte)(last - data.getSignBits(bitCount));
                        dst[n6] = by5;
                        last = by5;
                    }
                    expandCount += 8;
                }
                if (dstPos < dst.length) {
                    int n7 = dstPos++;
                    byte by6 = (byte)(last - data.getSignBits(bitCount));
                    dst[n7] = by6;
                    last = by6;
                }
                expandCounter += expandCounter < 31 ? 1 : 0;
            }
            expandCount -= expandCount / 8;
        }
        return true;
    }

    private int copyBlock(BitData data, byte[] dst, int dstPos, int count) {
        int bitCount = this.getCopyOffsetBitCount(data);
        int offsetBase = this.getCopyOffsetBase(bitCount);
        int winPos = dstPos - 1 - offsetBase - data.getBits(bitCount);
        for (int i = 0; i < count; ++i) {
            if (dstPos + i >= dst.length) continue;
            dst[dstPos + i] = dst[winPos + i];
        }
        return Math.min(dst.length, dstPos + count);
    }

    private int getCopyCount(BitData data) {
        if (data.getBit() == 0) {
            return 2 + data.getBit();
        }
        if (data.getBit() == 0) {
            return 4 + data.getBit();
        }
        if (data.getBit() == 0) {
            return 6 + data.getBit();
        }
        if (data.getBit() == 0) {
            return 8 + data.getBits(3);
        }
        return 16 + data.getBits(5);
    }

    private int getExpandBitCount(BitData data, int bitCount) {
        if (data.getBit() == 0) {
            return OCTETS[8 * bitCount - 15];
        }
        if (data.getBit() == 0) {
            return OCTETS[8 * bitCount - 14];
        }
        return OCTETS[8 * bitCount + data.getBits(2) - 13];
    }

    private int getCopyOffsetBitCount(BitData data) {
        if (data.getBit() == 1) {
            return 12;
        }
        if (data.getBit() == 1) {
            return 14;
        }
        return 8;
    }

    private int getCopyOffsetBase(int bitCount) {
        if (bitCount == 12) {
            return 256;
        }
        if (bitCount == 14) {
            return 4352;
        }
        return 0;
    }

    private class BitData {
        private final byte[] p;
        private final int base;
        private int i;

        public BitData(byte[] data, int index) {
            this.p = data;
            this.base = index;
            this.i = 0;
        }

        public int getBit() {
            int r = this.p[this.base + this.i / 8] >> 7 - this.i % 8 & 1;
            ++this.i;
            return r;
        }

        public int getBits(int count) {
            int b = 0;
            for (int k = 0; k < count; ++k) {
                b = b << 1 | this.getBit();
            }
            return b;
        }

        public int getSignBits(int count) {
            return this.getBits(count) << 32 - count >> 32 - count;
        }
    }
}

