/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io.wav;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.io.wav.RiffFile;
import de.quippy.javamod.system.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.sampled.UnsupportedAudioFileException;

public class RMIFile
extends RiffFile {
    private static int fourCC(byte[] br) {
        return br[0] << 24 & 0xFF000000 | br[1] << 16 & 0xFF0000 | br[2] << 8 & 0xFF00 | br[3] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Sequence open(URL url) throws UnsupportedAudioFileException {
        FileOrPackedInputStream rmiInput = null;
        try {
            Sequence sequence;
            ByteArrayInputStream input;
            block31: {
                Sequence result;
                int readLength;
                rmiInput = new FileOrPackedInputStream(url);
                byte[] br = new byte[8];
                ((InputStream)rmiInput).read(br, 0, 8);
                int chkID = br[0] << 24 & 0xFF000000 | br[1] << 16 & 0xFF0000 | br[2] << 8 & 0xFF00 | br[3] & 0xFF;
                if (chkID != RMIFile.fourCC("RIFF")) {
                    throw new UnsupportedAudioFileException("File is not a RMI RIFF file");
                }
                ((InputStream)rmiInput).read(br, 0, 4);
                if (RMIFile.fourCC(br) != RMIFile.fourCC("RMID")) {
                    throw new UnsupportedAudioFileException("File is not a RMI RIFF file");
                }
                ((InputStream)rmiInput).read(br, 0, 8);
                int dataID = br[0] << 24 & 0xFF000000 | br[1] << 16 & 0xFF0000 | br[2] << 8 & 0xFF00 | br[3] & 0xFF;
                int dataSize = br[7] << 24 & 0xFF000000 | br[6] << 16 & 0xFF0000 | br[5] << 8 & 0xFF00 | br[4] & 0xFF;
                if (dataID != RMIFile.fourCC("data")) {
                    throw new UnsupportedAudioFileException("File is not a RMI RIFF file");
                }
                byte[] buffer = new byte[dataSize];
                for (int fullSize = 0; fullSize < dataSize && (readLength = ((InputStream)rmiInput).read(buffer, fullSize, dataSize - fullSize)) != -1; fullSize += readLength) {
                }
                input = null;
                input = new ByteArrayInputStream(buffer);
                sequence = result = MidiSystem.getSequence(input);
                if (input == null) break block31;
                try {
                    input.close();
                }
                catch (Exception ex) {
                    Log.error("IGNORED", ex);
                }
            }
            return sequence;
            catch (Exception ex) {
                try {
                    try {
                        Log.error("[RMIFile]", ex);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Exception ex2) {
                                Log.error("IGNORED", ex2);
                            }
                        }
                    }
                }
                catch (IOException ex3) {
                    Log.error("[RMIFile]", ex3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (rmiInput != null) {
                try {
                    ((InputStream)rmiInput).close();
                }
                catch (Exception ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
        return null;
    }
}

