/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main;

import de.quippy.javamod.main.JavaModMainBase;
import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mod.ModContainer;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class CommandLine
extends JavaModMainBase
implements PlayThreadEventListener {
    private URL modFileName;
    private File wavFileName;
    private boolean shuffle;
    private boolean repeat;
    private float initialVolume = 1.0f;
    private MultimediaContainer currentContainer;
    private PlayThread playerThread = null;
    private PlayList currentPlayList = null;

    public CommandLine() {
        super(false);
    }

    private static void showHelp() {
        Log.info("java -jar ./javamod [-rx] [-b{8,16,24}] [-s{+,-}] [-i{+,-}] [-w{+,-}] [-n{+,-}] [-m{+,-}] [-l{+,-}] [-h{+,-}] [-j{+,-}] [-v0.0-1.0]");
        Log.info("                    [-eWAVFILE] MODFILE\n");
        Log.info("-rx        : use Samplerate x (8000/11025/22050/44100/96000...");
        Log.info("                               anything allowed, your soundhardware supports)");
        Log.info("-b8/16/24  : #Bits per sample");
        Log.info("-s+/-      : Stereo/Mono");
        Log.info("-i0/1/2/3  : interpolation: 0:none; 1:linear; 2:cubic spline; 3:fir interpolation");
        Log.info("-tms       : ms of buffer size (30 is minimum)");
        Log.info("-w+/-      : do/don't wide stereo mix");
        Log.info("-n+/-      : do/don't noise reduction");
        Log.info("-m+/-      : do/don't mega bass");
        Log.info("-l0/1/2    : set infinit loop handling: 0:original; 1:fade out; 2:ignore");
        Log.info("-h+/-      : do/don't shuffle playlists after loading");
        Log.info("-j+/-      : do/don't repeat playlist");
        Log.info("-v0.0-1.0  : set volume");
        Log.info("-eWAVEFILE : export to wave file");
    }

    private void parseParameters(String[] args) {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String op = args[i].substring(2);
                switch (args[i].toLowerCase().charAt(1)) {
                    case 'i': {
                        props.setProperty("javamod.player.ISP", Integer.toString(Integer.parseInt(op.substring(0, 1))));
                        break;
                    }
                    case 's': {
                        props.setProperty("javamod.player.stereo", op.charAt(0) == '+' ? "2" : "1");
                        break;
                    }
                    case 'w': {
                        props.setProperty("javamod.player.widestereomix", op.charAt(0) == '+' ? "TRUE" : "FALSE");
                        break;
                    }
                    case 'n': {
                        props.setProperty("javamod.player.noisereduction", op.charAt(0) == '+' ? "TRUE" : "FALSE");
                        break;
                    }
                    case 'm': {
                        props.setProperty("javamod.player.megabass", op.charAt(0) == '+' ? "TRUE" : "FALSE");
                        break;
                    }
                    case 'l': {
                        props.setProperty("javamod.player.noloops", Integer.toString(Integer.parseInt(op.substring(0, 1))));
                        break;
                    }
                    case 't': {
                        props.setProperty("javamod.player.msbuffersize", Integer.toString(Integer.parseInt(op.substring(0, 1))));
                        break;
                    }
                    case 'h': {
                        this.shuffle = op.charAt(0) == '+';
                        break;
                    }
                    case 'j': {
                        this.repeat = op.charAt(0) == '+';
                        break;
                    }
                    case 'b': {
                        int sampleSizeInBits = Integer.parseInt(op);
                        if (sampleSizeInBits != 8 && sampleSizeInBits != 16 && sampleSizeInBits != 24) {
                            throw new RuntimeException("samplesize of " + sampleSizeInBits + " is not supported");
                        }
                        props.setProperty("javamod.player.bitspersample", Integer.toString(sampleSizeInBits));
                        break;
                    }
                    case 'r': {
                        props.setProperty("javamod.player.frequency", Integer.toString(Integer.parseInt(op)));
                        break;
                    }
                    case 'e': {
                        this.wavFileName = new File(op);
                        break;
                    }
                    case 'v': {
                        this.initialVolume = Float.parseFloat(op);
                    }
                    default: {
                        throw new RuntimeException("Unknown parameter: " + args[i].charAt(1));
                    }
                }
                continue;
            }
            String fileName = args[i];
            try {
                this.modFileName = new URL(fileName);
                continue;
            }
            catch (MalformedURLException ex) {
                try {
                    this.modFileName = new File(fileName).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException exe) {
                    Log.error("This is not parsable: " + fileName, ex);
                    System.exit(-1);
                }
            }
        }
        MultimediaContainerManager.configureContainer(props);
    }

    @Override
    public void playThreadEventOccured(PlayThread thread) {
        if (!thread.isRunning() && thread.getHasFinishedNormaly()) {
            if (this.currentPlayList != null && this.currentPlayList.next()) {
                this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
            } else {
                System.exit(0);
            }
        }
    }

    private void doStartPlaying() {
        if (this.currentContainer != null) {
            this.doStopPlaying();
            if (this.currentContainer instanceof ModContainer) {
                System.out.println(((ModContainer)this.currentContainer).getCurrentMod().toString());
            }
            Mixer mixer = this.createNewMixer();
            mixer.setExportFile(this.wavFileName);
            this.playerThread = new PlayThread(mixer, this);
            this.playerThread.start();
        }
    }

    private void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.playerThread = null;
        }
    }

    private Mixer createNewMixer() {
        Mixer mixer = this.currentContainer.createNewMixer();
        if (mixer != null) {
            mixer.setVolume(this.initialVolume);
        }
        return mixer;
    }

    private void loadMultimediaOrPlayListFile(URL mediaPLSFileURL) {
        this.currentPlayList = null;
        try {
            if (PlayList.isPlaylistFile(mediaPLSFileURL)) {
                this.currentPlayList = PlayList.createFromFile(mediaPLSFileURL, this.shuffle, this.repeat);
                if (this.currentPlayList.next()) {
                    mediaPLSFileURL = this.currentPlayList.getCurrentEntry().getFile();
                }
            }
            if (mediaPLSFileURL != null) {
                this.loadMultimediaFile(mediaPLSFileURL);
            }
        }
        catch (Throwable ex) {
            Log.error("[MainForm::loadMultimediaOrPlayListFile]", ex);
            this.currentPlayList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMultimediaFile(URL mediaFileURL) {
        try {
            MultimediaContainer newContainer;
            if (mediaFileURL != null && (newContainer = MultimediaContainerManager.getMultimediaContainer(mediaFileURL)) != null) {
                this.currentContainer = newContainer;
            }
        }
        catch (Throwable ex) {
            Log.error("[MainForm::loadMultimediaFile] Loading of " + mediaFileURL + " failed!", ex);
            this.currentContainer = null;
        }
        finally {
            if (this.playerThread != null) {
                this.doStartPlaying();
            }
        }
    }

    public static void main(String[] args) {
        block4: {
            Log.info("Java Mod Player V2.3 \u00c2\u00a9 by Daniel Becker since 2006\n");
            try {
                if (args.length == 0) {
                    CommandLine.showHelp();
                    break block4;
                }
                CommandLine me = new CommandLine();
                me.parseParameters(args);
                me.loadMultimediaOrPlayListFile(me.modFileName);
                me.doStartPlaying();
                while (true) {
                    Thread.sleep(1L);
                }
            }
            catch (Exception ex) {
                Log.error("Error occured:", ex);
                CommandLine.showHelp();
                System.exit(-1);
            }
        }
    }
}

