/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.applet;

import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mod.ModMixer;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.applet.Applet;
import java.awt.HeadlessException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class JavaModAppletBase
extends Applet
implements PlayThreadEventListener {
    private static final long serialVersionUID = 7586730327373678282L;
    protected URL[] modFileName = null;
    protected boolean shuffle;
    protected boolean repeat;
    protected boolean autostart;
    protected float initialVolume;
    protected MultimediaContainer currentContainer;
    protected PlayThread playerThread = null;
    protected PlayList currentPlayList = null;

    @Override
    public void init() {
        try {
            this.parseParameters();
            this.initGui();
            this.loadMultimediaOrPlayListFile(this.modFileName);
            if (this.autostart) {
                this.doStartPlaying();
            }
        }
        catch (Exception ex) {
            Log.error("Error occured:", ex);
        }
    }

    @Override
    public abstract void playThreadEventOccured(PlayThread var1);

    protected abstract void setPlayListIcons();

    protected abstract void setNewSongName(String var1);

    protected abstract void initGui();

    protected PlayList getCurrentPlayList() {
        return this.currentPlayList;
    }

    public URL[] getModFileNames() {
        return this.modFileName;
    }

    public MultimediaContainer getCurrentContainer() {
        return this.currentContainer;
    }

    protected void parseParameters() {
        Properties props = new Properties();
        String value = this.getParameter("i");
        if (value != null) {
            props.setProperty("javamod.player.ISP", Integer.toString(Integer.parseInt(value)));
        }
        if ((value = this.getParameter("s")) != null) {
            props.setProperty("javamod.player.stereo", value.charAt(0) == '+' ? "2" : "1");
        }
        if ((value = this.getParameter("w")) != null) {
            props.setProperty("javamod.player.widestereomix", value.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((value = this.getParameter("n")) != null) {
            props.setProperty("javamod.player.noisereduction", value.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((value = this.getParameter("l")) != null) {
            props.setProperty("javamod.player.noloops", Integer.toString(Integer.parseInt(value)));
        }
        if ((value = this.getParameter("m")) != null) {
            props.setProperty("javamod.player.megabass", value.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((value = this.getParameter("r")) != null) {
            props.setProperty("javamod.player.frequency", Integer.toString(Integer.parseInt(value)));
        }
        if ((value = this.getParameter("t")) != null) {
            props.setProperty("javamod.player.msbuffersize", Integer.toString(Integer.parseInt(value)));
        }
        if ((value = this.getParameter("h")) != null) {
            boolean bl = this.shuffle = value.charAt(0) == '+';
        }
        if ((value = this.getParameter("j")) != null) {
            boolean bl = this.repeat = value.charAt(0) == '+';
        }
        this.autostart = (value = this.getParameter("a")) != null ? value.charAt(0) == '+' : true;
        value = this.getParameter("v");
        this.initialVolume = value != null ? Float.parseFloat(value) : 1.0f;
        value = this.getParameter("b");
        if (value != null) {
            int sampleSizeInBits = Integer.parseInt(value);
            if (sampleSizeInBits != 8 && sampleSizeInBits != 16 && sampleSizeInBits != 24) {
                throw new RuntimeException("samplesize of " + sampleSizeInBits + " is not supported");
            }
            props.setProperty("javamod.player.bitspersample", Integer.toString(sampleSizeInBits));
        }
        MultimediaContainerManager.configureContainer(props);
        value = this.getParameter("file");
        try {
            if (value != null) {
                ArrayList<URL> files = new ArrayList<URL>();
                StringTokenizer tok = new StringTokenizer(value, ",");
                while (tok.hasMoreTokens()) {
                    URL url = Helpers.createURLfromString(tok.nextToken().trim());
                    if (url == null) continue;
                    files.add(url);
                }
                this.modFileName = files.toArray(new URL[files.size()]);
            }
        }
        catch (Throwable ex) {
            Log.error("[Applet::parseParameters]", ex);
        }
    }

    protected Mixer createNewMixer() {
        Mixer mixer = this.currentContainer.createNewMixer();
        if (mixer != null) {
            mixer.setVolume(this.initialVolume);
        }
        return mixer;
    }

    protected void removeMixer() {
    }

    protected boolean loadMultimediaOrPlayListFile(URL[] mediaPLSFileURL) {
        this.currentPlayList = null;
        try {
            this.currentPlayList = PlayList.createNewListWithFiles(mediaPLSFileURL, this.shuffle, this.repeat);
            return this.doNextPlayListEntry();
        }
        catch (Throwable ex) {
            Log.error("[Applet::loadMultimediaOrPlayListFile]", ex);
            this.currentPlayList = null;
            return false;
        }
    }

    protected boolean loadMultimediaFile(URL mediaFileURL) {
        try {
            MultimediaContainer newContainer;
            if (mediaFileURL != null && (newContainer = MultimediaContainerManager.getMultimediaContainer(mediaFileURL)) != null) {
                this.currentContainer = newContainer;
                this.setNewSongName(this.currentContainer.getSongName());
            }
        }
        catch (Throwable ex) {
            Log.error("[Applet::loadMultimediaFile] Loading of " + mediaFileURL + " failed!", ex);
            return false;
        }
        this.setPlayListIcons();
        if (this.playerThread != null) {
            this.doStartPlaying();
        }
        return true;
    }

    public int getPlayingPosition() {
        BasicModMixer modMixer;
        Mixer mixer;
        if (this.playerThread != null && (mixer = this.playerThread.getCurrentMixer()) != null && mixer instanceof ModMixer && (modMixer = ((ModMixer)mixer).getModMixer()) != null) {
            return modMixer.getCurrentPatternPosition();
        }
        return -1;
    }

    public boolean doNextPlayListEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && this.currentPlayList.hasNext() && !ok) {
            this.currentPlayList.next();
            ok = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
        }
        return ok;
    }

    public boolean doPrevPlayListEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && this.currentPlayList.hasPrevious() && !ok) {
            this.currentPlayList.previous();
            ok = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
        }
        return ok;
    }

    public void doStartPlaying() {
        if (this.currentContainer != null) {
            this.doStopPlaying();
            this.playerThread = new PlayThread(this.createNewMixer(), this);
            this.playerThread.start();
        }
    }

    public void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.playerThread = null;
            this.removeMixer();
        }
    }

    public void doPausePlaying() {
        if (this.playerThread != null) {
            this.playerThread.pausePlay();
        }
    }

    public void clearPlaylist() {
        this.currentPlayList = null;
        this.setPlayListIcons();
    }

    public void addFileToPlayList(String urlString) {
        URL url = Helpers.createURLfromString(urlString);
        if (url != null) {
            if (this.currentPlayList == null) {
                this.loadMultimediaOrPlayListFile(new URL[]{url});
            } else {
                this.currentPlayList.addEntry(new PlayListEntry(url, this.currentPlayList));
            }
        }
    }

    public void playFile(String urlString) {
        URL url = Helpers.createURLfromString(urlString);
        if (url != null) {
            this.loadMultimediaOrPlayListFile(new URL[]{url});
        }
    }

    static {
        try {
            Helpers.registerAllClasses();
        }
        catch (ClassNotFoundException ex) {
            Log.error("JavaModMainBase: a class moved?!", ex);
        }
    }
}

