/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class EffectsPanel
extends JPanel {
    private static final long serialVersionUID = -3590575857860754245L;
    private JCheckBox passThrough = null;
    private JTabbedPane tabbedPane = null;
    private JPanel[] effectPanels;
    private AudioProcessor audioProcessor;

    public EffectsPanel(JPanel[] effectPanels, AudioProcessor audioProcessor) {
        this.effectPanels = effectPanels;
        this.audioProcessor = audioProcessor;
        this.initialize();
    }

    public void setAudioProcessor(AudioProcessor newAudioProcessor) {
        this.audioProcessor = newAudioProcessor;
    }

    private void initialize() {
        this.setName("effectsTabbedPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPassThrough(), Helpers.getGridBagConstraint(0, 0, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getTabbedPane(), Helpers.getGridBagConstraint(0, 1, 1, 0, 1, 10, 1.0, 1.0));
    }

    public JCheckBox getPassThrough() {
        if (this.passThrough == null) {
            this.passThrough = new JCheckBox();
            this.passThrough.setName("passThrough");
            this.passThrough.setText("activate effects");
            this.passThrough.setFont(Helpers.getDialogFont());
            if (this.audioProcessor != null) {
                this.passThrough.setSelected(this.audioProcessor.isDspEnabled());
            }
            this.passThrough.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if ((e.getStateChange() == 1 || e.getStateChange() == 2) && EffectsPanel.this.audioProcessor != null) {
                        EffectsPanel.this.audioProcessor.setDspEnabled(EffectsPanel.this.getPassThrough().isSelected());
                    }
                }
            });
        }
        return this.passThrough;
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1, 1);
            this.tabbedPane.setFont(Helpers.getDialogFont());
            for (int i = 0; i < this.effectPanels.length; ++i) {
                JPanel effectPanel = this.effectPanels[i];
                if (effectPanel == null) continue;
                JScrollPane containerScroller = new JScrollPane();
                containerScroller.setName("scrollPane_Effect_" + effectPanel.getName());
                containerScroller.setViewportView(effectPanel);
                this.tabbedPane.add(effectPanel.getName(), containerScroller);
            }
        }
        return this.tabbedPane;
    }
}

