/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.io.GaplessSoundOutputStreamImpl;
import de.quippy.javamod.io.SoundOutputStream;
import de.quippy.javamod.main.gui.EffectsPanel;
import de.quippy.javamod.main.gui.JavaModAbout;
import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.gui.PlayerConfigPanel;
import de.quippy.javamod.main.gui.SimpleTextViewerDialog;
import de.quippy.javamod.main.gui.UrlDialog;
import de.quippy.javamod.main.gui.components.LEDScrollPanel;
import de.quippy.javamod.main.gui.components.RoundSlider;
import de.quippy.javamod.main.gui.components.SAMeterPanel;
import de.quippy.javamod.main.gui.components.SeekBarPanel;
import de.quippy.javamod.main.gui.components.SeekBarPanelListener;
import de.quippy.javamod.main.gui.components.SimpleProgessDialog;
import de.quippy.javamod.main.gui.components.VUMeterPanel;
import de.quippy.javamod.main.gui.playlist.PlayListGUI;
import de.quippy.javamod.main.gui.playlist.PlaylistGUIChangeListener;
import de.quippy.javamod.main.gui.tools.FileChooserFilter;
import de.quippy.javamod.main.gui.tools.FileChooserResult;
import de.quippy.javamod.main.gui.tools.PlaylistDropListener;
import de.quippy.javamod.main.gui.tools.PlaylistDropListenerCallBack;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.mixer.dsp.DspProcessorCallBack;
import de.quippy.javamod.mixer.dsp.iir.GraphicEQ;
import de.quippy.javamod.mixer.dsp.iir.GraphicEqGUI;
import de.quippy.javamod.mixer.dsp.pitchshift.PitchShift;
import de.quippy.javamod.mixer.dsp.pitchshift.PitchShiftGUI;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import de.quippy.javamod.system.LogMessageCallBack;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class MainForm
extends JFrame
implements DspProcessorCallBack,
PlayThreadEventListener,
MultimediaContainerEventListener,
PlaylistGUIChangeListener,
PlaylistDropListenerCallBack {
    private static final long serialVersionUID = -2737074464335059959L;
    private static final String DEFAULTICONPATH = "/de/quippy/javamod/main/gui/ressources/quippy_the_kangaroo_icon.gif";
    public static final String BUTTONPLAY_INACTIVE = "/de/quippy/javamod/main/gui/ressources/play.gif";
    public static final String BUTTONPLAY_ACTIVE = "/de/quippy/javamod/main/gui/ressources/play_aktiv.gif";
    public static final String BUTTONPLAY_NORMAL = "/de/quippy/javamod/main/gui/ressources/play_normal.gif";
    public static final String BUTTONPAUSE_INACTIVE = "/de/quippy/javamod/main/gui/ressources/pause.gif";
    public static final String BUTTONPAUSE_ACTIVE = "/de/quippy/javamod/main/gui/ressources/pause_aktiv.gif";
    public static final String BUTTONPAUSE_NORMAL = "/de/quippy/javamod/main/gui/ressources/pause_normal.gif";
    public static final String BUTTONSTOP_INACTIVE = "/de/quippy/javamod/main/gui/ressources/stop.gif";
    public static final String BUTTONSTOP_ACTIVE = "/de/quippy/javamod/main/gui/ressources/stop_aktiv.gif";
    public static final String BUTTONSTOP_NORMAL = "/de/quippy/javamod/main/gui/ressources/stop_normal.gif";
    public static final String BUTTONPREV_INACTIVE = "/de/quippy/javamod/main/gui/ressources/prev.gif";
    public static final String BUTTONPREV_ACTIVE = "/de/quippy/javamod/main/gui/ressources/prev_aktiv.gif";
    public static final String BUTTONPREV_NORMAL = "/de/quippy/javamod/main/gui/ressources/prev_normal.gif";
    public static final String BUTTONNEXT_INACTIVE = "/de/quippy/javamod/main/gui/ressources/next.gif";
    public static final String BUTTONNEXT_ACTIVE = "/de/quippy/javamod/main/gui/ressources/next_aktiv.gif";
    public static final String BUTTONNEXT_NORMAL = "/de/quippy/javamod/main/gui/ressources/next_normal.gif";
    private static final String PROPERTYFILENAME = ".javamod.properties";
    private static final String PROPERTY_SEARCHPATH = "javamod.path.loadpath";
    private static final String PROPERTY_EXPORTPATH = "javamod.path.exportpath";
    private static final String PROPERTY_LOOKANDFEEL = "javamod.lookandfeel.classname";
    private static final String PROPERTY_LASTLOADED = "javamod.path.lastloaded";
    private static final String PROPERTY_SYSTEMTRAY = "javamod.systemtray";
    private static final String PROPERTY_MAINDIALOG_POS = "javamod.dialog.position.main";
    private static final String PROPERTY_SETUPDIALOG_POS = "javamod.dialog.position.setup";
    private static final String PROPERTY_PROPERTIESDIALOG_POS = "javamod.dialog.position.properties";
    private static final String PROPERTY_PLAYLISTDIALOG_POS = "javamod.dialog.position.playlist";
    private static final String PROPERTY_EFFECTDIALOG_POS = "javamod.dialog.position.equalizer";
    private static final String PROPERTY_MAINDIALOG_SIZE = "javamod.dialog.size.main";
    private static final String PROPERTY_SETUPDIALOG_SIZE = "javamod.dialog.size.setup";
    private static final String PROPERTY_PROPERTIESDIALOG_SIZE = "javamod.dialog.size.properties";
    private static final String PROPERTY_PLAYLISTDIALOG_SIZE = "javamod.dialog.size.playlist";
    private static final String PROPERTY_EFFECTDIALOG_SIZE = "javamod.dialog.size.equalizer";
    private static final String PROPERTY_VOLUME_VALUE = "javamod.dialog.volume.value";
    private static final String PROPERTY_BALANCE_VALUE = "javamod.dialog.balance.value";
    private static final String PROPERTY_SETUPDIALOG_VISABLE = "javamod.dialog.open.setup";
    private static final String PROPERTY_PROPERTIESDIALOG_VISABLE = "javamod.dialog.open.properties";
    private static final String PROPERTY_PLAYLIST_VISABLE = "javamod.dialog.open.playlist";
    private static final String PROPERTY_EFFECT_VISABLE = "javamod.dialog.open.equalizer";
    private static final String PROPERTY_EFFECTS_PASSTHROUGH = "javamod.player.effects.passthrough";
    private static final String PROPERTY_EQUALIZER_PREAMP = "javamod.player.equalizer.preamp";
    private static final String PROPERTY_EQUALIZER_BAND_PREFIX = "javamod.player.equalizer.band.";
    private static final String PROPERTY_EQUALIZER_ISACTIVE = "javamod.player.equalizer.isactive";
    private static final String PROPERTY_PITCHSHIFT_ISACTIVE = "javamod.player.pitchshift.isactive";
    private static final String PROPERTY_PITCHSHIFT_PITCH = "javamod.player.pitchshift.pitch";
    private static final String PROPERTY_PITCHSHIFT_SAMPLESCALE = "javamod.player.pitchshift.scale";
    private static final String PROPERTY_PITCHSHIFT_FRAMESIZE = "javamod.player.pitchshift.framesize";
    private static final String PROPERTY_PITCHSHIFT_OVERSAMPLING = "javamod.player.pitchshift.oversampling";
    private static final int PROPERTY_LASTLOADED_MAXENTRIES = 10;
    private static final String WINDOW_TITLE = "Java Mod Player V2.3";
    private static final String WINDOW_NAME = "JavaMod";
    private static FileFilter[] fileFilterExport;
    private static FileFilter[] fileFilterLoad;
    private ImageIcon buttonPlay_Active = null;
    private ImageIcon buttonPlay_Inactive = null;
    private ImageIcon buttonPlay_normal = null;
    private ImageIcon buttonPause_Active = null;
    private ImageIcon buttonPause_Inactive = null;
    private ImageIcon buttonPause_normal = null;
    private ImageIcon buttonStop_Active = null;
    private ImageIcon buttonStop_Inactive = null;
    private ImageIcon buttonStop_normal = null;
    private ImageIcon buttonPrev_Active = null;
    private ImageIcon buttonPrev_Inactive = null;
    private ImageIcon buttonPrev_normal = null;
    private ImageIcon buttonNext_Active = null;
    private ImageIcon buttonNext_Inactive = null;
    private ImageIcon buttonNext_normal = null;
    private JButton button_Play = null;
    private JButton button_Pause = null;
    private JButton button_Stop = null;
    private JButton button_Prev = null;
    private JButton button_Next = null;
    private RoundSlider volumeSlider = null;
    private JLabel volumeLabel = null;
    private RoundSlider balanceSlider = null;
    private JLabel balanceLabel = null;
    private JPanel baseContentPane = null;
    private JPanel mainContentPane = null;
    private JPanel musicDataPane = null;
    private JPanel playerControlPane = null;
    private JPanel playerDataPane = null;
    private JDialog modInfoDialog = null;
    private JDialog playerSetUpDialog = null;
    private JDialog playlistDialog = null;
    private JDialog equalizerDialog = null;
    private PlayerConfigPanel playerConfigPanel = null;
    private JPanel modInfoPane = null;
    private JPanel playerSetUpPane = null;
    private JPanel playlistPane = null;
    private JPanel effectPane = null;
    private Point mainDialogLocation = null;
    private Dimension mainDialogSize = null;
    private Point modInfoDialogLocation = null;
    private Dimension modInfoDialogSize = null;
    private boolean modInfoDialogVisable = false;
    private Point playerSetUpDialogLocation = null;
    private Dimension playerSetUpDialogSize = null;
    private boolean playerSetUpDialogVisable = false;
    private Point playlistDialogLocation = null;
    private Dimension playlistDialogSize = null;
    private boolean playlistDialogVisable = false;
    private Point effectsDialogLocation = null;
    private Dimension effectsDialogSize = null;
    private boolean effectDialogVisable = false;
    private SimpleProgessDialog downloadDialog = null;
    private VUMeterPanel vuLMeterPanel = null;
    private VUMeterPanel vuRMeterPanel = null;
    private SAMeterPanel saLMeterPanel = null;
    private SAMeterPanel saRMeterPanel = null;
    private LEDScrollPanel ledScrollPanel = null;
    private SeekBarPanel seekBarPanel = null;
    private JTextField messages = null;
    private JMenuBar baseMenuBar = null;
    private JMenu menu_File = null;
    private JMenu menu_View = null;
    private JMenu menu_LookAndFeel = null;
    private JMenu menu_Help = null;
    private JMenu menu_File_RecentFiles = null;
    private JMenuItem menu_File_openMod = null;
    private JMenuItem menu_File_openURL = null;
    private JMenuItem menu_File_exportWave = null;
    private JMenuItem menu_File_Close = null;
    private JMenuItem menu_View_Info = null;
    private JMenuItem menu_View_Setup = null;
    private JMenuItem menu_View_Playlist = null;
    private JMenuItem menu_View_GraphicEQ = null;
    private JCheckBoxMenuItem menu_View_UseSystemTray = null;
    private JMenuItem menu_Help_CheckUpdate = null;
    private JMenuItem menu_Help_ShowVersionHistory = null;
    private JMenuItem menu_Help_About = null;
    private JCheckBoxMenuItem[] menu_LookAndFeel_Items = null;
    private MenuItem aboutItem = null;
    private MenuItem playItem = null;
    private MenuItem pauseItem = null;
    private MenuItem stopItem = null;
    private MenuItem prevItem = null;
    private MenuItem nextItem = null;
    private MenuItem closeItem = null;
    private TrayIcon javaModTrayIcon = null;
    private JavaModAbout about = null;
    private UrlDialog urlDialog = null;
    private SimpleTextViewerDialog simpleTextViewerDialog = null;
    private PlayListGUI playlistGUI = null;
    private EffectsPanel effectGUI = null;
    private GraphicEqGUI equalizerGUI = null;
    private PitchShiftGUI pitchShiftGUI = null;
    private MultimediaContainer currentContainer;
    private PlayThread playerThread;
    private PlayList currentPlayList = null;
    private GraphicEQ currentEqualizer;
    private PitchShift currentPitchShift;
    private ArrayList<DropTarget> dropTargetList;
    private AudioProcessor audioProcessor;
    private transient SoundOutputStream soundOutputStream;
    private String propertyFilePath;
    private String searchPath;
    private String exportPath;
    private String uiClassName;
    private boolean useSystemTray = false;
    private float currentVolume;
    private float currentBalance;
    private ArrayList<URL> lastLoaded;
    private ArrayList<Window> windows;
    private boolean inExportMode;
    private final transient MakeMainWindowVisible makeMainWindowVisiable = new MakeMainWindowVisible();

    public MainForm() throws HeadlessException {
        this.propertyFilePath = Helpers.HOMEDIR;
        this.currentEqualizer = new GraphicEQ();
        this.currentPitchShift = new PitchShift();
        this.audioProcessor = new AudioProcessor(2048, 70);
        this.audioProcessor.addListener(this);
        this.audioProcessor.addEffectListener(this.currentEqualizer);
        this.audioProcessor.addEffectListener(this.currentPitchShift);
        this.inExportMode = false;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropertyFile() {
        Properties props = new Properties();
        try {
            boolean isActive;
            File propertyFile = new File(this.propertyFilePath + File.separator + PROPERTYFILENAME);
            if (propertyFile.exists()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(propertyFile);
                    props.load(fis);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ex) {
                            Log.error("IGNORED", ex);
                        }
                    }
                }
            }
            this.searchPath = props.getProperty(PROPERTY_SEARCHPATH, Helpers.HOMEDIR);
            this.exportPath = props.getProperty(PROPERTY_EXPORTPATH, Helpers.HOMEDIR);
            this.uiClassName = props.getProperty(PROPERTY_LOOKANDFEEL, UIManager.getSystemLookAndFeelClassName());
            this.useSystemTray = Boolean.parseBoolean(props.getProperty(PROPERTY_SYSTEMTRAY, "FALSE"));
            this.currentVolume = Float.parseFloat(props.getProperty(PROPERTY_VOLUME_VALUE, "1.0"));
            this.currentBalance = Float.parseFloat(props.getProperty(PROPERTY_BALANCE_VALUE, "0.0"));
            this.lastLoaded = new ArrayList(10);
            for (int i = 0; i < 10; ++i) {
                String url = props.getProperty("javamod.path.lastloaded." + i, null);
                if (url != null) {
                    this.lastLoaded.add(new URL(url));
                    continue;
                }
                this.lastLoaded.add(null);
            }
            this.setDSPEnabled(Boolean.parseBoolean(props.getProperty(PROPERTY_EFFECTS_PASSTHROUGH, "FALSE")));
            this.mainDialogLocation = Helpers.getPointFromString(props.getProperty(PROPERTY_MAINDIALOG_POS, "-1x-1"));
            this.mainDialogSize = Helpers.getDimensionFromString(props.getProperty(PROPERTY_MAINDIALOG_SIZE, "320x410"));
            this.playerSetUpDialogLocation = Helpers.getPointFromString(props.getProperty(PROPERTY_SETUPDIALOG_POS, "-1x-1"));
            this.playerSetUpDialogSize = Helpers.getDimensionFromString(props.getProperty(PROPERTY_SETUPDIALOG_SIZE, "720x230"));
            this.playerSetUpDialogVisable = Boolean.parseBoolean(props.getProperty(PROPERTY_SETUPDIALOG_VISABLE, "false"));
            this.modInfoDialogLocation = Helpers.getPointFromString(props.getProperty(PROPERTY_PROPERTIESDIALOG_POS, "-1x-1"));
            this.modInfoDialogSize = Helpers.getDimensionFromString(props.getProperty(PROPERTY_PROPERTIESDIALOG_SIZE, "520x630"));
            this.modInfoDialogVisable = Boolean.parseBoolean(props.getProperty(PROPERTY_PROPERTIESDIALOG_VISABLE, "false"));
            this.playlistDialogLocation = Helpers.getPointFromString(props.getProperty(PROPERTY_PLAYLISTDIALOG_POS, "-1x-1"));
            this.playlistDialogSize = Helpers.getDimensionFromString(props.getProperty(PROPERTY_PLAYLISTDIALOG_SIZE, "400x400"));
            this.playlistDialogVisable = Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYLIST_VISABLE, "false"));
            this.effectsDialogLocation = Helpers.getPointFromString(props.getProperty(PROPERTY_EFFECTDIALOG_POS, "-1x-1"));
            this.effectsDialogSize = Helpers.getDimensionFromString(props.getProperty(PROPERTY_EFFECTDIALOG_SIZE, "560x470"));
            this.effectDialogVisable = Boolean.parseBoolean(props.getProperty(PROPERTY_EFFECT_VISABLE, "false"));
            if (this.currentEqualizer != null) {
                isActive = Boolean.parseBoolean(props.getProperty(PROPERTY_EQUALIZER_ISACTIVE, "FALSE"));
                this.currentEqualizer.setIsActive(isActive);
                float preAmpValueDB = Float.parseFloat(props.getProperty(PROPERTY_EQUALIZER_PREAMP, "0.0"));
                this.currentEqualizer.setPreAmp(preAmpValueDB);
                for (int i = 0; i < this.currentEqualizer.getBandCount(); ++i) {
                    float bandValueDB = Float.parseFloat(props.getProperty(PROPERTY_EQUALIZER_BAND_PREFIX + Integer.toString(i), "0.0"));
                    this.currentEqualizer.setBand(i, bandValueDB);
                }
            }
            if (this.currentPitchShift != null) {
                isActive = Boolean.parseBoolean(props.getProperty(PROPERTY_PITCHSHIFT_ISACTIVE, "FALSE"));
                this.currentPitchShift.setIsActive(isActive);
                float pitchValue = Float.parseFloat(props.getProperty(PROPERTY_PITCHSHIFT_PITCH, "1.0"));
                this.currentPitchShift.setPitchScale(pitchValue);
                float scaleValue = Float.parseFloat(props.getProperty(PROPERTY_PITCHSHIFT_SAMPLESCALE, "1.0"));
                this.currentPitchShift.setSampleScale(scaleValue);
                int overSampling = Integer.parseInt(props.getProperty(PROPERTY_PITCHSHIFT_OVERSAMPLING, "32"));
                this.currentPitchShift.setFFTOversampling(overSampling);
                int frameSize = Integer.parseInt(props.getProperty(PROPERTY_PITCHSHIFT_FRAMESIZE, "8192"));
                this.currentPitchShift.setFFTFrameSize(frameSize);
            }
            MultimediaContainerManager.configureContainer(props);
        }
        catch (Throwable ex) {
            Log.error("[MainForm]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertyFile() {
        try {
            File propertyFile;
            int i;
            Properties props = new Properties();
            MultimediaContainerManager.getContainerConfigs(props);
            props.setProperty(PROPERTY_SEARCHPATH, this.searchPath);
            props.setProperty(PROPERTY_EXPORTPATH, this.exportPath);
            props.setProperty(PROPERTY_LOOKANDFEEL, this.uiClassName);
            props.setProperty(PROPERTY_SYSTEMTRAY, Boolean.toString(this.useSystemTray));
            props.setProperty(PROPERTY_VOLUME_VALUE, Float.toString(this.currentVolume));
            props.setProperty(PROPERTY_BALANCE_VALUE, Float.toString(this.currentBalance));
            for (i = 0; i < 10; ++i) {
                URL element = this.lastLoaded.get(i);
                if (element == null) continue;
                props.setProperty("javamod.path.lastloaded." + i, element.toString());
            }
            props.setProperty(PROPERTY_EFFECTS_PASSTHROUGH, Boolean.toString(this.isDSPEnabled()));
            props.setProperty(PROPERTY_MAINDIALOG_POS, Helpers.getStringFromPoint(this.getLocation()));
            props.setProperty(PROPERTY_MAINDIALOG_SIZE, Helpers.getStringFromDimension(this.getSize()));
            props.setProperty(PROPERTY_SETUPDIALOG_POS, Helpers.getStringFromPoint(this.getPlayerSetUpDialog().getLocation()));
            props.setProperty(PROPERTY_SETUPDIALOG_SIZE, Helpers.getStringFromDimension(this.getPlayerSetUpDialog().getSize()));
            props.setProperty(PROPERTY_SETUPDIALOG_VISABLE, Boolean.toString(this.getPlayerSetUpDialog().isVisible()));
            props.setProperty(PROPERTY_PROPERTIESDIALOG_POS, Helpers.getStringFromPoint(this.getModInfoDialog().getLocation()));
            props.setProperty(PROPERTY_PROPERTIESDIALOG_SIZE, Helpers.getStringFromDimension(this.getModInfoDialog().getSize()));
            props.setProperty(PROPERTY_PROPERTIESDIALOG_VISABLE, Boolean.toString(this.getModInfoDialog().isVisible()));
            props.setProperty(PROPERTY_PLAYLISTDIALOG_POS, Helpers.getStringFromPoint(this.getPlaylistDialog().getLocation()));
            props.setProperty(PROPERTY_PLAYLISTDIALOG_SIZE, Helpers.getStringFromDimension(this.getPlaylistDialog().getSize()));
            props.setProperty(PROPERTY_PLAYLIST_VISABLE, Boolean.toString(this.getPlaylistDialog().isVisible()));
            props.setProperty(PROPERTY_EFFECTDIALOG_POS, Helpers.getStringFromPoint(this.getEffectDialog().getLocation()));
            props.setProperty(PROPERTY_EFFECTDIALOG_SIZE, Helpers.getStringFromDimension(this.getEffectDialog().getSize()));
            props.setProperty(PROPERTY_EFFECT_VISABLE, Boolean.toString(this.getEffectDialog().isVisible()));
            if (this.currentEqualizer != null) {
                props.setProperty(PROPERTY_EQUALIZER_ISACTIVE, Boolean.toString(this.currentEqualizer.isActive()));
                props.setProperty(PROPERTY_EQUALIZER_PREAMP, Float.toString(this.currentEqualizer.getPreAmpDB()));
                for (i = 0; i < this.currentEqualizer.getBandCount(); ++i) {
                    props.setProperty(PROPERTY_EQUALIZER_BAND_PREFIX + Integer.toString(i), Float.toString(this.currentEqualizer.getBand(i)));
                }
            }
            if (this.currentPitchShift != null) {
                props.setProperty(PROPERTY_PITCHSHIFT_ISACTIVE, Boolean.toString(this.currentPitchShift.isActive()));
                props.setProperty(PROPERTY_PITCHSHIFT_PITCH, Float.toString(this.currentPitchShift.getPitchScale()));
                props.setProperty(PROPERTY_PITCHSHIFT_SAMPLESCALE, Float.toString(this.currentPitchShift.getSampleScale()));
                props.setProperty(PROPERTY_PITCHSHIFT_FRAMESIZE, Integer.toString(this.currentPitchShift.getFftFrameSize()));
                props.setProperty(PROPERTY_PITCHSHIFT_OVERSAMPLING, Integer.toString(this.currentPitchShift.getFFTOversampling()));
            }
            if ((propertyFile = new File(this.propertyFilePath + File.separator + PROPERTYFILENAME)).exists()) {
                boolean ok = propertyFile.delete();
                if (ok) {
                    ok = propertyFile.createNewFile();
                }
                if (!ok) {
                    Log.error("Could not create property file: " + propertyFile.getCanonicalPath());
                }
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(propertyFile);
                props.store(fos, WINDOW_TITLE);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ex) {
                        Log.error("IGNORED", ex);
                    }
                }
            }
        }
        catch (Throwable ex) {
            Log.error("MainForm]", ex);
        }
    }

    private UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        return UIManager.getInstalledLookAndFeels();
    }

    private void createFileFilter() {
        HashMap<String, String[]> extensionMap = MultimediaContainerManager.getSupportedFileExtensionsPerContainer();
        ArrayList<FileChooserFilter> chooserFilterArray = new ArrayList<FileChooserFilter>(extensionMap.size() + 1);
        Set<String> containerNameSet = extensionMap.keySet();
        for (String containerName : containerNameSet) {
            String[] extensions = extensionMap.get(containerName);
            StringBuilder fileText = new StringBuilder(containerName);
            fileText.append(" (");
            int ende = extensions.length - 1;
            for (int i = 0; i <= ende; ++i) {
                fileText.append("*.").append(extensions[i]);
                if (i >= ende) continue;
                fileText.append(", ");
            }
            fileText.append(')');
            chooserFilterArray.add(new FileChooserFilter(extensions, fileText.toString()));
        }
        chooserFilterArray.add(PlayList.PLAYLIST_FILE_FILTER);
        String[] containerExtensions = MultimediaContainerManager.getSupportedFileExtensions();
        String[] fullSupportedExtensions = new String[containerExtensions.length + PlayList.SUPPORTEDPLAYLISTS.length];
        System.arraycopy(PlayList.SUPPORTEDPLAYLISTS, 0, fullSupportedExtensions, 0, PlayList.SUPPORTEDPLAYLISTS.length);
        System.arraycopy(containerExtensions, 0, fullSupportedExtensions, PlayList.SUPPORTEDPLAYLISTS.length, containerExtensions.length);
        chooserFilterArray.add(new FileChooserFilter(fullSupportedExtensions, "All playable files"));
        fileFilterLoad = new FileFilter[chooserFilterArray.size()];
        chooserFilterArray.toArray(fileFilterLoad);
        fileFilterExport = new FileFilter[1];
        MainForm.fileFilterExport[0] = new FileChooserFilter(AudioFileFormat.Type.WAVE.getExtension(), AudioFileFormat.Type.WAVE.toString());
    }

    private void initialize() {
        Log.addLogListener(new LogMessageCallBack(){

            @Override
            public void debug(String message) {
                MainForm.this.showMessage(message);
            }

            @Override
            public void info(String message) {
                MainForm.this.showMessage(message);
            }

            @Override
            public void error(String message, Throwable ex) {
                if (ex != null) {
                    MainForm.this.showMessage(message + '|' + ex.toString());
                } else {
                    MainForm.this.showMessage(message);
                }
            }
        });
        this.readPropertyFile();
        this.setSystemTray();
        this.setName(WINDOW_NAME);
        this.setTitle(WINDOW_TITLE);
        this.getTrayIcon().setToolTip(WINDOW_TITLE);
        URL iconURL = MainForm.class.getResource(DEFAULTICONPATH);
        if (iconURL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(iconURL));
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainForm.this.doClose();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                if (MainForm.this.useSystemTray) {
                    MainForm.this.setVisible(false);
                }
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                if (MainForm.this.useSystemTray) {
                    MainForm.this.setVisible(true);
                }
            }
        });
        this.setSize(this.mainDialogSize);
        this.setPreferredSize(this.mainDialogSize);
        this.setJMenuBar(this.getBaseMenuBar());
        this.setContentPane(this.getBaseContentPane());
        this.setPlayListIcons();
        this.addMouseWheelListener(new MouseWheelVolumeControl());
        this.pack();
        this.createAllWindows();
        this.updateLookAndFeel(this.uiClassName);
        if (this.mainDialogLocation == null || this.mainDialogLocation.getX() == -1.0 || this.mainDialogLocation.getY() == -1.0) {
            this.mainDialogLocation = Helpers.getFrameCenteredLocation(this, null);
        }
        this.setLocation(this.mainDialogLocation);
        this.getModInfoDialog().setVisible(this.modInfoDialogVisable);
        this.getPlaylistDialog().setVisible(this.playlistDialogVisable);
        this.getEffectDialog().setVisible(this.effectDialogVisable);
        this.getPlayerSetUpDialog().setVisible(this.playerSetUpDialogVisable);
        this.dropTargetList = new ArrayList();
        PlaylistDropListener myListener = new PlaylistDropListener(this);
        Helpers.registerDropListener(this.dropTargetList, this, myListener);
        MultimediaContainerManager.addMultimediaContainerEventListener(this);
        this.createFileFilter();
        this.currentContainer = null;
        this.showMessage("Ready...");
    }

    private void createAllWindows() {
        this.windows = new ArrayList();
        this.windows.add(this.getJavaModAbout());
        this.windows.add(this.getModInfoDialog());
        this.windows.add(this.getPlayerSetUpDialog());
        this.windows.add(this.getURLDialog());
        this.windows.add(this.getShowVersion_Text());
        this.windows.add(this.getPlaylistDialog());
        this.windows.add(this.getEffectDialog());
    }

    @Override
    public void playlistRecieved(DropTargetDropEvent dtde, PlayList dropResult, URL addToLastLoaded) {
        if (addToLastLoaded != null) {
            this.addFileToLastLoaded(addToLastLoaded);
        }
        if (dropResult != null) {
            this.doStopPlaying();
            this.currentPlayList = dropResult;
            this.getPlaylistGUI().setNewPlaylist(this.currentPlayList);
            boolean ok = this.doNextPlayListEntry();
            if (this.playerThread == null && ok) {
                this.doStartPlaying();
            }
        }
    }

    @Override
    public void playListChanged(PlayList newPlayList) {
        if (newPlayList != null) {
            if (newPlayList != this.currentPlayList) {
                boolean playListWasEmpty = this.currentPlayList == null;
                this.currentPlayList = newPlayList;
                if (playListWasEmpty) {
                    this.doNextPlayListEntry();
                }
            }
            this.setPlayListIcons();
        }
    }

    private void setLookAndFeel(String lookAndFeelClassName) {
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (Throwable e) {
            this.showMessage("The selected Look&Feel is not supported or not reachable through the classpath. Switching to system default...");
            try {
                lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeelClassName);
            }
            catch (Throwable e1) {
                Log.error("[MainForm]", e1);
            }
        }
    }

    private void updateLookAndFeel(String lookAndFeelClassName) {
        this.setLookAndFeel(lookAndFeelClassName);
        MultimediaContainerManager.updateLookAndFeel();
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
        for (Window window : this.windows) {
            SwingUtilities.updateComponentTreeUI(window);
            window.pack();
        }
    }

    private void changeInfoPane() {
        this.getModInfoPane().removeAll();
        this.getModInfoPane().add((Component)this.getCurrentContainer().getInfoPanel(), "Center");
        this.getModInfoDialog().pack();
        this.getModInfoDialog().repaint();
    }

    private void changeConfigPane() {
        this.getPlayerConfigPanel().selectTabForContainer(this.getCurrentContainer());
    }

    private void changeExportMenu() {
        this.getMenu_File_exportWave().setEnabled(this.getCurrentContainer().canExport());
    }

    public boolean isDSPEnabled() {
        if (this.audioProcessor != null) {
            return this.audioProcessor.isDspEnabled();
        }
        return false;
    }

    public void setDSPEnabled(boolean dspEnabled) {
        if (this.audioProcessor != null) {
            this.audioProcessor.setDspEnabled(dspEnabled);
        }
    }

    public JMenuBar getBaseMenuBar() {
        if (this.baseMenuBar == null) {
            this.baseMenuBar = new JMenuBar();
            this.baseMenuBar.setName("baseMenuBar");
            this.baseMenuBar.add(this.getMenu_File());
            this.baseMenuBar.add(this.getMenu_View());
            this.baseMenuBar.add(this.getMenu_LookAndFeel());
            this.baseMenuBar.add(this.getMenu_Help());
        }
        return this.baseMenuBar;
    }

    public JMenu getMenu_File() {
        if (this.menu_File == null) {
            this.menu_File = new JMenu();
            this.menu_File.setName("menu_File");
            this.menu_File.setMnemonic('f');
            this.menu_File.setText("File");
            this.menu_File.setFont(Helpers.getDialogFont());
            this.menu_File.add(this.getMenu_File_openMod());
            this.menu_File.add(this.getMenu_File_openURL());
            this.menu_File.add(this.getMenu_File_exportWave());
            this.menu_File.add(new JSeparator());
            this.menu_File.add(this.getMenu_File_RecentFiles());
            this.menu_File.add(new JSeparator());
            this.menu_File.add(this.getMenu_File_Close());
        }
        return this.menu_File;
    }

    public JMenu getMenu_View() {
        if (this.menu_View == null) {
            this.menu_View = new JMenu();
            this.menu_View.setName("menu_View");
            this.menu_View.setMnemonic('v');
            this.menu_View.setText("View");
            this.menu_View.setFont(Helpers.getDialogFont());
            this.menu_View.add(this.getMenu_View_Info());
            this.menu_View.add(this.getMenu_View_Setup());
            this.menu_View.add(this.getMenu_View_Playlist());
            this.menu_View.add(this.getMenu_View_GraphicEQ());
            this.menu_View.add(new JSeparator());
            this.menu_View.add(this.getMenu_View_UseSystemTray());
        }
        return this.menu_View;
    }

    public JMenu getMenu_LookAndFeel() {
        if (this.menu_LookAndFeel == null) {
            this.menu_LookAndFeel = new JMenu();
            this.menu_LookAndFeel.setName("menu_LookAndFeel");
            this.menu_LookAndFeel.setMnemonic('l');
            this.menu_LookAndFeel.setText("Look&Feel");
            this.menu_LookAndFeel.setFont(Helpers.getDialogFont());
            String currentUIClassName = UIManager.getLookAndFeel().getClass().getName();
            UIManager.LookAndFeelInfo[] lookAndFeels = this.getInstalledLookAndFeels();
            this.menu_LookAndFeel_Items = new JCheckBoxMenuItem[lookAndFeels.length];
            for (int i = 0; i < lookAndFeels.length; ++i) {
                this.menu_LookAndFeel_Items[i] = new JCheckBoxMenuItem();
                this.menu_LookAndFeel_Items[i].setName("newMenuItem_" + i);
                this.menu_LookAndFeel_Items[i].setText(lookAndFeels[i].getName());
                this.menu_LookAndFeel_Items[i].setFont(Helpers.getDialogFont());
                this.menu_LookAndFeel_Items[i].setToolTipText("Change to " + lookAndFeels[i].getName() + " look and feel");
                String uiClassName = lookAndFeels[i].getClassName();
                if (uiClassName.equals(currentUIClassName)) {
                    this.menu_LookAndFeel_Items[i].setSelected(true);
                }
                this.menu_LookAndFeel_Items[i].addActionListener(new LookAndFeelChanger(this.menu_LookAndFeel_Items[i], uiClassName));
                this.menu_LookAndFeel.add(this.menu_LookAndFeel_Items[i]);
            }
        }
        return this.menu_LookAndFeel;
    }

    private JMenu getMenu_Help() {
        if (this.menu_Help == null) {
            this.menu_Help = new JMenu();
            this.menu_Help.setName("menu_Help");
            this.menu_Help.setMnemonic('h');
            this.menu_Help.setText("Help");
            this.menu_Help.setFont(Helpers.getDialogFont());
            this.menu_Help.add(this.getMenu_Help_CheckUpdate());
            this.menu_Help.add(this.getMenu_Help_ShowVersionHistory());
            this.menu_Help.add(new JSeparator());
            this.menu_Help.add(this.getMenu_Help_About());
        }
        return this.menu_Help;
    }

    private JMenuItem getMenu_File_openMod() {
        if (this.menu_File_openMod == null) {
            this.menu_File_openMod = new JMenuItem();
            this.menu_File_openMod.setName("menu_File_openMod");
            this.menu_File_openMod.setMnemonic('o');
            this.menu_File_openMod.setText("Open Sound File...");
            this.menu_File_openMod.setFont(Helpers.getDialogFont());
            this.menu_File_openMod.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doOpenFile();
                }
            });
        }
        return this.menu_File_openMod;
    }

    private JMenuItem getMenu_File_openURL() {
        if (this.menu_File_openURL == null) {
            this.menu_File_openURL = new JMenuItem();
            this.menu_File_openURL.setName("menu_File_openURL");
            this.menu_File_openURL.setMnemonic('u');
            this.menu_File_openURL.setText("Open an URL...");
            this.menu_File_openURL.setFont(Helpers.getDialogFont());
            this.menu_File_openURL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doOpenURL();
                }
            });
        }
        return this.menu_File_openURL;
    }

    private JMenuItem getMenu_File_exportWave() {
        if (this.menu_File_exportWave == null) {
            this.menu_File_exportWave = new JMenuItem();
            this.menu_File_exportWave.setName("menu_File_exportWave");
            this.menu_File_exportWave.setMnemonic('e');
            this.menu_File_exportWave.setText("Export to wave...");
            this.menu_File_exportWave.setFont(Helpers.getDialogFont());
            this.menu_File_exportWave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doExportToWave();
                }
            });
        }
        return this.menu_File_exportWave;
    }

    private JMenu getMenu_File_RecentFiles() {
        if (this.menu_File_RecentFiles == null) {
            this.menu_File_RecentFiles = new JMenu();
            this.menu_File_RecentFiles.setName("menu_File_RecentFiles");
            this.menu_File_RecentFiles.setMnemonic('r');
            this.menu_File_RecentFiles.setText("Recent files");
            this.menu_File_RecentFiles.setFont(Helpers.getDialogFont());
            this.createRecentFileMenuItems();
        }
        return this.menu_File_RecentFiles;
    }

    private void createRecentFileMenuItems() {
        JMenu recent = this.getMenu_File_RecentFiles();
        recent.removeAll();
        int index = 1;
        for (int i = 0; i < 10; ++i) {
            URL element = this.lastLoaded.get(i);
            if (element == null) continue;
            String displayName = null;
            if (element.getProtocol().equalsIgnoreCase("file")) {
                try {
                    File f = new File(element.toURI());
                    displayName = f.getAbsolutePath();
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
            }
            if (displayName == null) {
                displayName = this.lastLoaded.get(i).toString();
            }
            JMenuItem lastLoadURL = new JMenuItem();
            lastLoadURL.setName("menu_File_RecentFiles_File" + i);
            lastLoadURL.setText((index < 10 ? "  " : "") + index++ + " " + displayName);
            lastLoadURL.setFont(Helpers.getDialogFont());
            lastLoadURL.setToolTipText(element.toString());
            lastLoadURL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        URL url = new URL(((JMenuItem)e.getSource()).getToolTipText());
                        MainForm.this.loadMultimediaOrPlayListFile(url);
                    }
                    catch (Exception ex) {
                        Log.error("Load recent error", ex);
                    }
                }
            });
            recent.add(lastLoadURL);
        }
    }

    private JMenuItem getMenu_File_Close() {
        if (this.menu_File_Close == null) {
            this.menu_File_Close = new JMenuItem();
            this.menu_File_Close.setName("menu_File_Close");
            this.menu_File_Close.setMnemonic('c');
            this.menu_File_Close.setText("Close");
            this.menu_File_Close.setFont(Helpers.getDialogFont());
            this.menu_File_Close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doClose();
                }
            });
        }
        return this.menu_File_Close;
    }

    private JMenuItem getMenu_View_Info() {
        if (this.menu_View_Info == null) {
            this.menu_View_Info = new JMenuItem();
            this.menu_View_Info.setName("menu_View_Info");
            this.menu_View_Info.setMnemonic('p');
            this.menu_View_Info.setText("Properties...");
            this.menu_View_Info.setFont(Helpers.getDialogFont());
            this.menu_View_Info.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.getModInfoDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_Info;
    }

    private JMenuItem getMenu_View_Setup() {
        if (this.menu_View_Setup == null) {
            this.menu_View_Setup = new JMenuItem();
            this.menu_View_Setup.setName("menu_View_Setup");
            this.menu_View_Setup.setMnemonic('s');
            this.menu_View_Setup.setText("Setup...");
            this.menu_View_Setup.setFont(Helpers.getDialogFont());
            this.menu_View_Setup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.getPlayerSetUpDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_Setup;
    }

    private JMenuItem getMenu_View_Playlist() {
        if (this.menu_View_Playlist == null) {
            this.menu_View_Playlist = new JMenuItem();
            this.menu_View_Playlist.setName("menu_View_Playlist");
            this.menu_View_Playlist.setMnemonic('p');
            this.menu_View_Playlist.setText("Playlist...");
            this.menu_View_Playlist.setFont(Helpers.getDialogFont());
            this.menu_View_Playlist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.getPlaylistDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_Playlist;
    }

    private JMenuItem getMenu_View_GraphicEQ() {
        if (this.menu_View_GraphicEQ == null) {
            this.menu_View_GraphicEQ = new JMenuItem();
            this.menu_View_GraphicEQ.setName("menu_View_GraphicEQ");
            this.menu_View_GraphicEQ.setMnemonic('e');
            this.menu_View_GraphicEQ.setText("Effect...");
            this.menu_View_GraphicEQ.setFont(Helpers.getDialogFont());
            this.menu_View_GraphicEQ.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.getEffectDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_GraphicEQ;
    }

    private JCheckBoxMenuItem getMenu_View_UseSystemTray() {
        if (this.menu_View_UseSystemTray == null) {
            this.menu_View_UseSystemTray = new JCheckBoxMenuItem();
            this.menu_View_UseSystemTray.setName("menu_View_UseSystemTray");
            this.menu_View_UseSystemTray.setMnemonic('t');
            this.menu_View_UseSystemTray.setText("Use system tray");
            this.menu_View_UseSystemTray.setFont(Helpers.getDialogFont());
            this.menu_View_UseSystemTray.setEnabled(SystemTray.isSupported());
            this.menu_View_UseSystemTray.setSelected(this.useSystemTray);
            this.menu_View_UseSystemTray.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.useSystemTray = MainForm.this.getMenu_View_UseSystemTray().isSelected();
                    MainForm.this.setSystemTray();
                }
            });
        }
        return this.menu_View_UseSystemTray;
    }

    private JMenuItem getMenu_Help_CheckUpdate() {
        if (this.menu_Help_CheckUpdate == null) {
            this.menu_Help_CheckUpdate = new JMenuItem();
            this.menu_Help_CheckUpdate.setName("menu_Help_CheckUpdate");
            this.menu_Help_CheckUpdate.setMnemonic('c');
            this.menu_Help_CheckUpdate.setText("Check for update...");
            this.menu_Help_CheckUpdate.setFont(Helpers.getDialogFont());
            this.menu_Help_CheckUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doCheckUpdate();
                }
            });
        }
        return this.menu_Help_CheckUpdate;
    }

    private JMenuItem getMenu_Help_ShowVersionHistory() {
        if (this.menu_Help_ShowVersionHistory == null) {
            this.menu_Help_ShowVersionHistory = new JMenuItem();
            this.menu_Help_ShowVersionHistory.setName("menu_Help_showVersionHistory");
            this.menu_Help_ShowVersionHistory.setMnemonic('s');
            this.menu_Help_ShowVersionHistory.setText("Show version history...");
            this.menu_Help_ShowVersionHistory.setFont(Helpers.getDialogFont());
            this.menu_Help_ShowVersionHistory.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimpleTextViewerDialog dialog = MainForm.this.getShowVersion_Text();
                    dialog.setDisplayTextFromURL("http://www.quippy.de/download.php?file=./modplayer/javamod_version.txt");
                    dialog.setVisible(true);
                }
            });
        }
        return this.menu_Help_ShowVersionHistory;
    }

    private JMenuItem getMenu_Help_About() {
        if (this.menu_Help_About == null) {
            this.menu_Help_About = new JMenuItem();
            this.menu_Help_About.setName("menu_Help_About");
            this.menu_Help_About.setMnemonic('a');
            this.menu_Help_About.setText("About...");
            this.menu_Help_About.setFont(Helpers.getDialogFont());
            this.menu_Help_About.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doShowAbout();
                }
            });
        }
        return this.menu_Help_About;
    }

    private MenuItem getAboutItem() {
        if (this.aboutItem == null) {
            this.aboutItem = new MenuItem("About");
            this.aboutItem.setFont(Helpers.getDialogFont());
            this.aboutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doShowAbout();
                }
            });
        }
        return this.aboutItem;
    }

    private MenuItem getPlayItem() {
        if (this.playItem == null) {
            this.playItem = new MenuItem("Play");
            this.playItem.setFont(Helpers.getDialogFont());
            this.playItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doStartPlaying();
                }
            });
        }
        return this.playItem;
    }

    private MenuItem getPauseItem() {
        if (this.pauseItem == null) {
            this.pauseItem = new MenuItem("Pause");
            this.pauseItem.setFont(Helpers.getDialogFont());
            this.pauseItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doPausePlaying();
                }
            });
        }
        return this.pauseItem;
    }

    private MenuItem getStopItem() {
        if (this.stopItem == null) {
            this.stopItem = new MenuItem("Stop");
            this.stopItem.setFont(Helpers.getDialogFont());
            this.stopItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doStopPlaying();
                }
            });
        }
        return this.stopItem;
    }

    private MenuItem getPrevItem() {
        if (this.prevItem == null) {
            this.prevItem = new MenuItem("Previous");
            this.prevItem.setFont(Helpers.getDialogFont());
            this.prevItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doPrevPlayListEntry();
                }
            });
        }
        return this.prevItem;
    }

    private MenuItem getNextItem() {
        if (this.nextItem == null) {
            this.nextItem = new MenuItem("Next");
            this.nextItem.setFont(Helpers.getDialogFont());
            this.nextItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doNextPlayListEntry();
                }
            });
        }
        return this.nextItem;
    }

    private MenuItem getCloseItem() {
        if (this.closeItem == null) {
            this.closeItem = new MenuItem("Close");
            this.closeItem.setFont(Helpers.getDialogFont());
            this.closeItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doClose();
                }
            });
        }
        return this.closeItem;
    }

    private TrayIcon getTrayIcon() {
        URL iconURL;
        if (this.javaModTrayIcon == null && (iconURL = MainForm.class.getResource(DEFAULTICONPATH)) != null) {
            this.javaModTrayIcon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(iconURL));
            this.javaModTrayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        MainForm me = MainForm.this;
                        me.setVisible(true);
                        me.setExtendedState(me.getExtendedState() & 0xFFFFFFFE);
                    }
                }
            });
            PopupMenu popUp = new PopupMenu();
            popUp.add(this.getAboutItem());
            popUp.addSeparator();
            popUp.add(this.getPlayItem());
            popUp.add(this.getPauseItem());
            popUp.add(this.getStopItem());
            popUp.add(this.getPrevItem());
            popUp.add(this.getNextItem());
            popUp.addSeparator();
            popUp.add(this.getCloseItem());
            this.javaModTrayIcon.setPopupMenu(popUp);
        }
        return this.javaModTrayIcon;
    }

    private void setSystemTray() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            try {
                tray.remove(this.getTrayIcon());
                if (this.useSystemTray) {
                    tray.add(this.getTrayIcon());
                }
            }
            catch (AWTException e) {
                Log.error("TrayIcon could not be added.", e);
            }
        }
    }

    public JPanel getBaseContentPane() {
        if (this.baseContentPane == null) {
            this.baseContentPane = new JPanel();
            this.baseContentPane.setName("baseContentPane");
            this.baseContentPane.setLayout(new BorderLayout());
            this.baseContentPane.add((Component)this.getMessages(), "South");
            this.baseContentPane.add((Component)this.getMainContentPane(), "Center");
        }
        return this.baseContentPane;
    }

    public JTextField getMessages() {
        if (this.messages == null) {
            this.messages = new JTextField();
            this.messages.setName("messages");
            this.messages.setEditable(false);
            this.messages.setFont(Helpers.getDialogFont());
        }
        return this.messages;
    }

    public JPanel getMainContentPane() {
        if (this.mainContentPane == null) {
            this.mainContentPane = new JPanel();
            this.mainContentPane.setName("mainContentPane");
            this.mainContentPane.setLayout(new GridBagLayout());
            this.mainContentPane.add((Component)this.getMusicDataPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 10, 0.0, 1.0));
            this.mainContentPane.add((Component)this.getPlayerDataPane(), Helpers.getGridBagConstraint(0, 1, 1, 0, 1, 10, 0.0, 1.0));
            this.mainContentPane.add((Component)this.getPlayerControlPane(), Helpers.getGridBagConstraint(0, 2, 1, 0, 1, 10, 0.0, 0.0));
        }
        return this.mainContentPane;
    }

    private JavaModAbout getJavaModAbout() {
        if (this.about == null) {
            this.about = new JavaModAbout((Frame)this, true);
            this.about.addWindowFocusListener(this.makeMainWindowVisiable);
        } else {
            this.about.setLocation(Helpers.getFrameCenteredLocation(this.about, this));
        }
        return this.about;
    }

    private UrlDialog getURLDialog() {
        if (this.urlDialog == null) {
            this.urlDialog = new UrlDialog(this, true, "");
            this.urlDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        } else {
            this.urlDialog.setLocation(Helpers.getFrameCenteredLocation(this.urlDialog, this));
        }
        return this.urlDialog;
    }

    public JDialog getEffectDialog() {
        if (this.equalizerDialog == null) {
            this.equalizerDialog = new JDialog(this, "Effect", false);
            this.equalizerDialog.setName("equalizerDialog");
            this.equalizerDialog.setSize(this.effectsDialogSize);
            this.equalizerDialog.setPreferredSize(this.effectsDialogSize);
            this.equalizerDialog.setContentPane(this.getEffectPane());
            if (this.effectsDialogLocation == null || this.effectsDialogLocation.getX() == -1.0 || this.effectsDialogLocation.getY() == -1.0) {
                this.effectsDialogLocation = Helpers.getFrameCenteredLocation(this.equalizerDialog, null);
            }
            this.equalizerDialog.setLocation(this.effectsDialogLocation);
            this.equalizerDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        }
        return this.equalizerDialog;
    }

    public JDialog getPlayerSetUpDialog() {
        if (this.playerSetUpDialog == null) {
            this.playerSetUpDialog = new JDialog(this, "Configuration", false);
            this.playerSetUpDialog.setName("playerSetUpDialog");
            this.playerSetUpDialog.setSize(this.playerSetUpDialogSize);
            this.playerSetUpDialog.setPreferredSize(this.playerSetUpDialogSize);
            this.playerSetUpDialog.setContentPane(this.getPlayerSetUpPane());
            if (this.playerSetUpDialogLocation == null || this.playerSetUpDialogLocation.getX() == -1.0 || this.playerSetUpDialogLocation.getY() == -1.0) {
                this.playerSetUpDialogLocation = Helpers.getFrameCenteredLocation(this.playerSetUpDialog, null);
            }
            this.playerSetUpDialog.setLocation(this.playerSetUpDialogLocation);
            this.playerSetUpDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        }
        return this.playerSetUpDialog;
    }

    public JDialog getModInfoDialog() {
        if (this.modInfoDialog == null) {
            this.modInfoDialog = new JDialog(this, "File properties", false);
            this.modInfoDialog.setName("modInfoDialog");
            this.modInfoDialog.setSize(this.modInfoDialogSize);
            this.modInfoDialog.setPreferredSize(this.modInfoDialogSize);
            this.modInfoDialog.setContentPane(this.getModInfoPane());
            if (this.modInfoDialogLocation == null || this.modInfoDialogLocation.getX() == -1.0 || this.modInfoDialogLocation.getY() == -1.0) {
                this.modInfoDialogLocation = Helpers.getFrameCenteredLocation(this.modInfoDialog, null);
            }
            this.modInfoDialog.setLocation(this.modInfoDialogLocation);
            this.modInfoDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        }
        return this.modInfoDialog;
    }

    public JPanel getModInfoPane() {
        if (this.modInfoPane == null) {
            this.modInfoPane = new JPanel();
            this.modInfoPane.setName("ModInfoPane");
            this.modInfoPane.setLayout(new BorderLayout());
            this.modInfoPane.setBorder(new TitledBorder(null, "Multimedia File Info", 4, 0, Helpers.getDialogFont(), null));
            this.changeInfoPane();
        }
        return this.modInfoPane;
    }

    public JDialog getPlaylistDialog() {
        if (this.playlistDialog == null) {
            this.playlistDialog = new JDialog(this, "Playlist", false);
            this.playlistDialog.setName("playlistDialog");
            this.playlistDialog.setSize(this.playlistDialogSize);
            this.playlistDialog.setPreferredSize(this.playlistDialogSize);
            this.playlistDialog.setContentPane(this.getPlaylistPane());
            if (this.playlistDialogLocation == null || this.playlistDialogLocation.getX() == -1.0 || this.playlistDialogLocation.getY() == -1.0) {
                this.playlistDialogLocation = Helpers.getFrameCenteredLocation(this.playlistDialog, null);
            }
            this.playlistDialog.setLocation(this.playlistDialogLocation);
            this.playlistDialog.addWindowFocusListener(this.makeMainWindowVisiable);
        }
        return this.playlistDialog;
    }

    public JPanel getPlaylistPane() {
        if (this.playlistPane == null) {
            this.playlistPane = new JPanel();
            this.playlistPane.setName("playlistPane");
            this.playlistPane.setLayout(new BorderLayout());
            this.playlistPane.setBorder(new TitledBorder(null, "Playlist", 4, 0, Helpers.getDialogFont(), null));
            this.playlistPane.add(this.getPlaylistGUI());
        }
        return this.playlistPane;
    }

    public PlayListGUI getPlaylistGUI() {
        if (this.playlistGUI == null) {
            this.playlistGUI = new PlayListGUI(this.getPlaylistDialog());
            this.playlistGUI.addPlaylistGUIChangeListener(this);
        }
        return this.playlistGUI;
    }

    public JPanel getEffectPane() {
        if (this.effectPane == null) {
            this.effectPane = new JPanel();
            this.effectPane.setName("effectPane");
            this.effectPane.setLayout(new BorderLayout());
            this.effectPane.setBorder(new TitledBorder(null, "Effects", 4, 0, Helpers.getDialogFont(), null));
            this.effectPane.add(this.getEffectsPanel());
        }
        return this.effectPane;
    }

    private GraphicEqGUI getEqualizerGui() {
        if (this.equalizerGUI == null) {
            this.equalizerGUI = new GraphicEqGUI(this.currentEqualizer);
        }
        return this.equalizerGUI;
    }

    private PitchShiftGUI getPitchShiftGui() {
        if (this.pitchShiftGUI == null) {
            this.pitchShiftGUI = new PitchShiftGUI(this.currentPitchShift);
        }
        return this.pitchShiftGUI;
    }

    public EffectsPanel getEffectsPanel() {
        if (this.effectGUI == null) {
            JPanel[] effectPanels = new JPanel[]{this.getEqualizerGui(), this.getPitchShiftGui()};
            this.effectGUI = new EffectsPanel(effectPanels, this.audioProcessor);
        }
        return this.effectGUI;
    }

    public JPanel getPlayerSetUpPane() {
        if (this.playerSetUpPane == null) {
            this.playerSetUpPane = new JPanel();
            this.playerSetUpPane.setName("playerSetUpPane");
            this.playerSetUpPane.setLayout(new BorderLayout());
            this.playerSetUpPane.setBorder(new TitledBorder(null, "Mixer Control", 4, 0, Helpers.getDialogFont(), null));
            this.playerSetUpPane.add(this.getPlayerConfigPanel());
            this.changeConfigPane();
        }
        return this.playerSetUpPane;
    }

    public PlayerConfigPanel getPlayerConfigPanel() {
        if (this.playerConfigPanel == null) {
            this.playerConfigPanel = new PlayerConfigPanel();
        }
        return this.playerConfigPanel;
    }

    public SimpleProgessDialog getDownloadDialog() {
        if (this.downloadDialog == null) {
            this.downloadDialog = new SimpleProgessDialog((Frame)this, "Download progress");
            this.downloadDialog.setSize(350, 90);
            this.downloadDialog.setPreferredSize(this.downloadDialog.getSize());
            this.downloadDialog.pack();
        }
        return this.downloadDialog;
    }

    public SAMeterPanel getSALMeterPanel() {
        if (this.saLMeterPanel == null) {
            this.saLMeterPanel = new SAMeterPanel(50, 25);
            Dimension d = new Dimension(104, 60);
            this.saLMeterPanel.setSize(d);
            this.saLMeterPanel.setMaximumSize(d);
            this.saLMeterPanel.setMinimumSize(d);
            this.saLMeterPanel.setPreferredSize(d);
            this.saLMeterPanel.setDoubleBuffered(true);
            this.saLMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.saLMeterPanel;
    }

    public SAMeterPanel getSARMeterPanel() {
        if (this.saRMeterPanel == null) {
            this.saRMeterPanel = new SAMeterPanel(50, 25);
            Dimension d = new Dimension(104, 60);
            this.saRMeterPanel.setSize(d);
            this.saRMeterPanel.setMaximumSize(d);
            this.saRMeterPanel.setMinimumSize(d);
            this.saRMeterPanel.setPreferredSize(d);
            this.saRMeterPanel.setDoubleBuffered(true);
            this.saRMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.saRMeterPanel;
    }

    public VUMeterPanel getVULMeterPanel() {
        if (this.vuLMeterPanel == null) {
            this.vuLMeterPanel = new VUMeterPanel(50);
            Dimension d = new Dimension(20, 100);
            this.vuLMeterPanel.setSize(d);
            this.vuLMeterPanel.setMaximumSize(d);
            this.vuLMeterPanel.setMinimumSize(d);
            this.vuLMeterPanel.setPreferredSize(d);
            this.vuLMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.vuLMeterPanel;
    }

    public VUMeterPanel getVURMeterPanel() {
        if (this.vuRMeterPanel == null) {
            this.vuRMeterPanel = new VUMeterPanel(50);
            Dimension d = new Dimension(20, 100);
            this.vuRMeterPanel.setSize(d);
            this.vuRMeterPanel.setMaximumSize(d);
            this.vuRMeterPanel.setMinimumSize(d);
            this.vuRMeterPanel.setPreferredSize(d);
            this.vuRMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.vuRMeterPanel;
    }

    public JPanel getMusicDataPane() {
        if (this.musicDataPane == null) {
            this.musicDataPane = new JPanel();
            this.musicDataPane.setName("musicDataPane");
            this.musicDataPane.setLayout(new GridBagLayout());
            this.musicDataPane.setBorder(new TitledBorder(null, "Name", 4, 0, Helpers.getDialogFont(), null));
            this.musicDataPane.add((Component)this.getLEDScrollPanel(), Helpers.getGridBagConstraint(0, 0, 1, 0, 0, 10, 0.0, 0.0));
        }
        return this.musicDataPane;
    }

    public LEDScrollPanel getLEDScrollPanel() {
        int chars = 15;
        int brick = 3;
        if (this.ledScrollPanel == null) {
            this.ledScrollPanel = new LEDScrollPanel(30, "Java Mod Player V2.3 \u00c2\u00a9 by Daniel Becker since 2006                  ", 15, Color.GREEN, Color.GRAY);
            Dimension d = new Dimension(274, 28);
            this.ledScrollPanel.setSize(d);
            this.ledScrollPanel.setMaximumSize(d);
            this.ledScrollPanel.setMinimumSize(d);
            this.ledScrollPanel.setPreferredSize(d);
            this.ledScrollPanel.setBorder(new BevelBorder(1));
        }
        return this.ledScrollPanel;
    }

    public JPanel getPlayerDataPane() {
        if (this.playerDataPane == null) {
            this.playerDataPane = new JPanel();
            this.playerDataPane.setName("playerDataPane");
            this.playerDataPane.setLayout(new GridBagLayout());
            this.playerDataPane.setBorder(new TitledBorder(null, "Player Data", 4, 0, Helpers.getDialogFont(), null));
            this.playerDataPane.add((Component)this.getVULMeterPanel(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getSALMeterPanel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getSARMeterPanel(), Helpers.getGridBagConstraint(2, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getVURMeterPanel(), Helpers.getGridBagConstraint(3, 0, 1, 0, 0, 10, 0.0, 0.0));
        }
        return this.playerDataPane;
    }

    public JPanel getPlayerControlPane() {
        if (this.playerControlPane == null) {
            this.playerControlPane = new JPanel();
            this.playerControlPane.setName("playerControlPane");
            this.playerControlPane.setLayout(new GridBagLayout());
            this.playerControlPane.setBorder(new TitledBorder(null, "Player Control", 4, 0, Helpers.getDialogFont(), null));
            this.playerControlPane.add((Component)this.getButton_Prev(), Helpers.getGridBagConstraint(0, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Play(), Helpers.getGridBagConstraint(1, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Next(), Helpers.getGridBagConstraint(2, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Pause(), Helpers.getGridBagConstraint(3, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Stop(), Helpers.getGridBagConstraint(4, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getVolumeSlider(), Helpers.getGridBagConstraint(5, 0, 1, 1, 3, 10, 0.0, 1.0));
            this.playerControlPane.add((Component)this.getBalanceSlider(), Helpers.getGridBagConstraint(6, 0, 1, 0, 3, 10, 0.0, 1.0));
            this.playerControlPane.add((Component)this.getVolumeLabel(), Helpers.getGridBagConstraint(5, 1, 1, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getBalanceLabel(), Helpers.getGridBagConstraint(6, 1, 1, 0, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getSeekBarPanel(), Helpers.getGridBagConstraint(0, 2, 1, 0, 1, 10, 1.0, 1.0));
        }
        return this.playerControlPane;
    }

    private SeekBarPanel getSeekBarPanel() {
        if (this.seekBarPanel == null) {
            this.seekBarPanel = new SeekBarPanel(30, false);
            this.seekBarPanel.setName("SeekBarPanel");
            this.seekBarPanel.addListener(new SeekBarPanelListener(){

                @Override
                public void valuesChanged(long milliseconds) {
                    if (MainForm.this.currentPlayList != null && MainForm.this.playerThread != null && MainForm.this.playerThread.isRunning()) {
                        MainForm.this.currentPlayList.setCurrentElementByTimeIndex(milliseconds);
                    }
                }
            });
        }
        return this.seekBarPanel;
    }

    private JButton getButton_Play() {
        if (this.button_Play == null) {
            this.buttonPlay_normal = new ImageIcon(this.getClass().getResource(BUTTONPLAY_NORMAL));
            this.buttonPlay_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPLAY_INACTIVE));
            this.buttonPlay_Active = new ImageIcon(this.getClass().getResource(BUTTONPLAY_ACTIVE));
            this.button_Play = new JButton();
            this.button_Play.setName("button_Play");
            this.button_Play.setText("");
            this.button_Play.setToolTipText("play");
            this.button_Play.setHorizontalTextPosition(0);
            this.button_Play.setVerticalTextPosition(3);
            this.button_Play.setIcon(this.buttonPlay_normal);
            this.button_Play.setDisabledIcon(this.buttonPlay_Inactive);
            this.button_Play.setPressedIcon(this.buttonPlay_Active);
            this.button_Play.setMargin(new Insets(4, 6, 4, 6));
            this.button_Play.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doStartPlaying();
                }
            });
        }
        return this.button_Play;
    }

    private JButton getButton_Pause() {
        if (this.button_Pause == null) {
            this.buttonPause_normal = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_NORMAL));
            this.buttonPause_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_INACTIVE));
            this.buttonPause_Active = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_ACTIVE));
            this.button_Pause = new JButton();
            this.button_Pause.setName("button_Pause");
            this.button_Pause.setText("");
            this.button_Pause.setToolTipText("pause");
            this.button_Pause.setHorizontalTextPosition(0);
            this.button_Pause.setVerticalTextPosition(3);
            this.button_Pause.setIcon(this.buttonPause_normal);
            this.button_Pause.setDisabledIcon(this.buttonPause_Inactive);
            this.button_Pause.setPressedIcon(this.buttonPause_Active);
            this.button_Pause.setMargin(new Insets(4, 6, 4, 6));
            this.button_Pause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doPausePlaying();
                }
            });
        }
        return this.button_Pause;
    }

    private JButton getButton_Stop() {
        if (this.button_Stop == null) {
            this.buttonStop_normal = new ImageIcon(this.getClass().getResource(BUTTONSTOP_NORMAL));
            this.buttonStop_Inactive = new ImageIcon(this.getClass().getResource(BUTTONSTOP_INACTIVE));
            this.buttonStop_Active = new ImageIcon(this.getClass().getResource(BUTTONSTOP_ACTIVE));
            this.button_Stop = new JButton();
            this.button_Stop.setName("button_Stop");
            this.button_Stop.setText("");
            this.button_Stop.setToolTipText("stop");
            this.button_Stop.setHorizontalTextPosition(0);
            this.button_Stop.setVerticalTextPosition(3);
            this.button_Stop.setIcon(this.buttonStop_normal);
            this.button_Stop.setDisabledIcon(this.buttonStop_Inactive);
            this.button_Stop.setPressedIcon(this.buttonStop_Active);
            this.button_Stop.setMargin(new Insets(4, 6, 4, 6));
            this.button_Stop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doStopPlaying();
                }
            });
        }
        return this.button_Stop;
    }

    private JButton getButton_Prev() {
        if (this.button_Prev == null) {
            this.buttonPrev_normal = new ImageIcon(this.getClass().getResource(BUTTONPREV_NORMAL));
            this.buttonPrev_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPREV_INACTIVE));
            this.buttonPrev_Active = new ImageIcon(this.getClass().getResource(BUTTONPREV_ACTIVE));
            this.button_Prev = new JButton();
            this.button_Prev.setName("button_Prev");
            this.button_Prev.setText("");
            this.button_Prev.setToolTipText("previous");
            this.button_Prev.setHorizontalTextPosition(0);
            this.button_Prev.setVerticalTextPosition(3);
            this.button_Prev.setIcon(this.buttonPrev_normal);
            this.button_Prev.setDisabledIcon(this.buttonPrev_Inactive);
            this.button_Prev.setPressedIcon(this.buttonPrev_Active);
            this.button_Prev.setMargin(new Insets(4, 6, 4, 6));
            this.button_Prev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doPrevPlayListEntry();
                }
            });
        }
        return this.button_Prev;
    }

    private JButton getButton_Next() {
        if (this.button_Next == null) {
            this.buttonNext_normal = new ImageIcon(this.getClass().getResource(BUTTONNEXT_NORMAL));
            this.buttonNext_Inactive = new ImageIcon(this.getClass().getResource(BUTTONNEXT_INACTIVE));
            this.buttonNext_Active = new ImageIcon(this.getClass().getResource(BUTTONNEXT_ACTIVE));
            this.button_Next = new JButton();
            this.button_Next.setName("button_Next");
            this.button_Next.setText("");
            this.button_Next.setToolTipText("next");
            this.button_Next.setHorizontalTextPosition(0);
            this.button_Next.setVerticalTextPosition(3);
            this.button_Next.setIcon(this.buttonNext_normal);
            this.button_Next.setDisabledIcon(this.buttonNext_Inactive);
            this.button_Next.setPressedIcon(this.buttonNext_Active);
            this.button_Next.setMargin(new Insets(4, 6, 4, 6));
            this.button_Next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doNextPlayListEntry();
                }
            });
        }
        return this.button_Next;
    }

    public JLabel getVolumeLabel() {
        if (this.volumeLabel == null) {
            this.volumeLabel = new JLabel("Volume");
            this.volumeLabel.setFont(Helpers.getDialogFont());
        }
        return this.volumeLabel;
    }

    public RoundSlider getVolumeSlider() {
        if (this.volumeSlider == null) {
            this.volumeSlider = new RoundSlider();
            this.volumeSlider.setSize(new Dimension(20, 20));
            this.volumeSlider.setMinimumSize(new Dimension(20, 20));
            this.volumeSlider.setMaximumSize(new Dimension(20, 20));
            this.volumeSlider.setPreferredSize(new Dimension(20, 20));
            this.volumeSlider.setValue(this.currentVolume);
            this.volumeSlider.setToolTipText(Float.toString(this.currentVolume * 100.0f) + '%');
            this.volumeSlider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RoundSlider slider = (RoundSlider)e.getSource();
                    if (e.getClickCount() > 1) {
                        slider.setValue(0.5f);
                        e.consume();
                    }
                }
            });
            this.volumeSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RoundSlider slider = (RoundSlider)e.getSource();
                    MainForm.this.currentVolume = slider.getValue();
                    if (MainForm.this.currentVolume < 0.0f) {
                        MainForm.this.currentVolume = 0.0f;
                    } else if (MainForm.this.currentVolume > 1.0f) {
                        MainForm.this.currentVolume = 1.0f;
                    }
                    slider.setToolTipText(Float.toString(MainForm.this.currentVolume * 100.0f) + '%');
                    MainForm.this.doSetVoumeValue();
                }
            });
        }
        return this.volumeSlider;
    }

    public JLabel getBalanceLabel() {
        if (this.balanceLabel == null) {
            this.balanceLabel = new JLabel("Balance");
            this.balanceLabel.setFont(Helpers.getDialogFont());
        }
        return this.balanceLabel;
    }

    public RoundSlider getBalanceSlider() {
        if (this.balanceSlider == null) {
            this.balanceSlider = new RoundSlider();
            this.balanceSlider.setSize(new Dimension(20, 20));
            this.balanceSlider.setMinimumSize(new Dimension(20, 20));
            this.balanceSlider.setMaximumSize(new Dimension(20, 20));
            this.balanceSlider.setPreferredSize(new Dimension(20, 20));
            this.balanceSlider.setValue((this.currentBalance + 1.0f) / 2.0f);
            this.balanceSlider.setToolTipText(Float.toString(this.currentBalance * 100.0f) + '%');
            this.balanceSlider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RoundSlider slider = (RoundSlider)e.getSource();
                    if (e.getClickCount() > 1) {
                        slider.setValue(0.5f);
                        e.consume();
                    }
                }
            });
            this.balanceSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RoundSlider slider = (RoundSlider)e.getSource();
                    MainForm.this.currentBalance = slider.getValue() * 2.0f - 1.0f;
                    slider.setToolTipText(Float.toString(MainForm.this.currentBalance * 100.0f) + '%');
                    MainForm.this.doSetBalanceValue();
                }
            });
        }
        return this.balanceSlider;
    }

    @Override
    public void currentSampleChanged(float[] leftSample, float[] rightSample) {
        this.getVULMeterPanel().setVUMeter(leftSample);
        this.getVURMeterPanel().setVUMeter(rightSample);
        this.getSALMeterPanel().setMeter(leftSample);
        this.getSARMeterPanel().setMeter(rightSample);
    }

    @Override
    public void multimediaContainerEventOccured(MultimediaContainerEvent event) {
        if (event.getType() == MultimediaContainerEvent.SONG_NAME_CHANGED) {
            this.getLEDScrollPanel().addScrollText(event.getEvent().toString() + "     ");
        } else if (event.getType() == MultimediaContainerEvent.SONG_NAME_CHANGED_OLD_INVALID) {
            this.getLEDScrollPanel().setScrollTextTo(event.getEvent().toString() + "     ");
        }
        this.getTrayIcon().setToolTip(event.getEvent().toString());
    }

    @Override
    public void playThreadEventOccured(PlayThread thread) {
        if (thread.isRunning()) {
            this.getButton_Play().setIcon(this.buttonPlay_Active);
        } else {
            boolean ok;
            this.getButton_Play().setIcon(this.buttonPlay_normal);
            if (thread.getHasFinishedNormaly() && !(ok = this.doNextPlayListEntry())) {
                this.doStopPlaying();
            }
        }
        Mixer mixer = thread.getCurrentMixer();
        if (mixer != null) {
            if (mixer.isPaused()) {
                this.getButton_Pause().setIcon(this.buttonPause_Active);
            } else {
                this.getButton_Pause().setIcon(this.buttonPause_normal);
            }
        }
    }

    private void setPlayListIcons() {
        if (this.currentPlayList == null) {
            this.getButton_Prev().setEnabled(false);
            this.getButton_Next().setEnabled(false);
        } else {
            this.getButton_Prev().setEnabled(this.currentPlayList.hasPrevious());
            this.getButton_Next().setEnabled(this.currentPlayList.hasNext());
        }
        this.getPrevItem().setEnabled(this.getButton_Prev().isEnabled());
        this.getNextItem().setEnabled(this.getButton_Next().isEnabled());
    }

    private void doClose() {
        if (this.useSystemTray && (this.getExtendedState() & 1) != 0) {
            this.setVisible(true);
        }
        this.doStopPlaying();
        this.getSeekBarPanel().pauseThread();
        this.getVULMeterPanel().pauseThread();
        this.getVURMeterPanel().pauseThread();
        this.getSALMeterPanel().pauseThread();
        this.getSARMeterPanel().pauseThread();
        this.getLEDScrollPanel().pauseThread();
        this.writePropertyFile();
        if (this.audioProcessor != null) {
            this.audioProcessor.removeListener(this);
        }
        MultimediaContainerManager.removeMultimediaContainerEventListener(this);
        this.useSystemTray = false;
        this.setSystemTray();
        for (Window win : this.windows) {
            win.setVisible(false);
            win.dispose();
        }
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void doOpenFile() {
        FileChooserResult selectedFile = Helpers.selectFileNameFor(this, this.searchPath, "Load a Sound-File", fileFilterLoad, 0, true, false);
        if (selectedFile != null) {
            this.doOpenFile(selectedFile.getSelectedFiles());
        }
    }

    public void doOpenFile(File[] files) {
        if (files != null) {
            if (files.length == 1) {
                File f = files[0];
                if (f.isFile()) {
                    String modFileName = f.getAbsolutePath();
                    int i = modFileName.lastIndexOf(File.separatorChar);
                    this.searchPath = modFileName.substring(0, i);
                    this.loadMultimediaOrPlayListFile(Helpers.createURLfromFile(f));
                } else if (f.isDirectory()) {
                    this.searchPath = f.getAbsolutePath();
                }
            } else {
                this.playlistRecieved(null, PlayList.createNewListWithFiles(files, false, false), null);
            }
        }
    }

    private void doOpenURL() {
        this.getURLDialog().setVisible(true);
        String url = this.getURLDialog().getURL();
        if (url != null && url.length() != 0) {
            this.doOpenURL(url);
        }
    }

    public void doOpenURL(String surl) {
        if (surl != null) {
            this.loadMultimediaOrPlayListFile(Helpers.createURLfromString(surl));
        }
    }

    private void doExportToWave() {
        this.doStopPlaying();
        if (this.currentContainer != null) {
            block3: {
                File f;
                block4: {
                    int result;
                    do {
                        String fileName = Helpers.createLocalFileStringFromURL(this.currentContainer.getFileURL(), true);
                        fileName = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1);
                        String exportToWav = this.exportPath + File.separatorChar + fileName + ".WAV";
                        FileChooserResult selectedFile = Helpers.selectFileNameFor(this, exportToWav, "Export to wave", fileFilterExport, 1, false, false);
                        if (selectedFile == null || (f = selectedFile.getSelectedFile()) == null) break block3;
                        if (!f.exists()) break block4;
                        result = JOptionPane.showConfirmDialog(this, "File already exists! Overwrite?", "Overwrite confirmation", 1, 3);
                        if (result != 2) continue;
                        return;
                    } while (result == 1);
                    boolean ok = f.delete();
                    if (!ok) {
                        JOptionPane.showMessageDialog(this, "Overwrite failed. Is file write protected or in use?", "Failed", 0);
                        return;
                    }
                }
                String modFileName = f.getAbsolutePath();
                int i = modFileName.lastIndexOf(File.separatorChar);
                this.exportPath = modFileName.substring(0, i);
                int result = JOptionPane.showConfirmDialog(this, "Continue playback while exporting?", "Playback?", 0, 3);
                Mixer mixer = this.createNewMixer();
                mixer.setPlayDuringExport(result == 0);
                mixer.setExportFile(f);
                this.playerThread = new PlayThread(mixer, this);
                this.playerThread.start();
                this.inExportMode = true;
            }
            return;
        }
        JOptionPane.showMessageDialog(this, "You need to load a file first!", "Ups!", 0);
    }

    private SimpleTextViewerDialog getShowVersion_Text() {
        if (this.simpleTextViewerDialog == null) {
            this.simpleTextViewerDialog = new SimpleTextViewerDialog(this, true);
        }
        this.simpleTextViewerDialog.setLocation(Helpers.getFrameCenteredLocation(this.simpleTextViewerDialog, this));
        return this.simpleTextViewerDialog;
    }

    private void doCheckUpdate() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String serverVersion = Helpers.getCurrentServerVersion();
                int compareResult = Helpers.compareVersions("V2.3", serverVersion);
                if (compareResult < 0) {
                    int result;
                    File f = new File(".");
                    String programmDestination = f.getAbsolutePath();
                    int resultHistory = JOptionPane.showConfirmDialog(MainForm.this, "There is a new version available!\n\nYour version: V2.3 - online verison: " + serverVersion + "\n\nWatch version history?\n\n", "New Version", 0, 3);
                    if (resultHistory == 0) {
                        SimpleTextViewerDialog dialog = MainForm.this.getShowVersion_Text();
                        dialog.setDisplayTextFromURL("http://www.quippy.de/download.php?file=./modplayer/javamod_version.txt");
                        dialog.setVisible(true);
                    }
                    if ((result = JOptionPane.showConfirmDialog(MainForm.this, "Your version: V2.3 - online verison: " + serverVersion + "\n\nShould I start the download?\n\n", "New Version", 0, 3)) == 0) {
                        File destination;
                        block12: {
                            JFileChooser chooser = new JFileChooser();
                            chooser.setDialogTitle("Select download destination");
                            chooser.setFileSelectionMode(1);
                            chooser.setAcceptAllFileFilterUsed(false);
                            chooser.setApproveButtonText("Save here");
                            while (true) {
                                int chooser_result;
                                if ((chooser_result = chooser.showOpenDialog(MainForm.this)) == 1) {
                                    return;
                                }
                                if (chooser_result != 0) continue;
                                File destinationDir = chooser.getSelectedFile();
                                destination = new File(destinationDir.getAbsolutePath() + File.separatorChar + "javamod.jar");
                                if (!destination.exists()) break block12;
                                int owresult = JOptionPane.showConfirmDialog(MainForm.this, "File already exists! Overwrite?", "Overwrite confirmation", 1, 3);
                                if (owresult == 2) {
                                    return;
                                }
                                if (owresult != 1) break;
                            }
                            boolean ok = destination.delete();
                            if (!ok && destination.exists()) {
                                JOptionPane.showMessageDialog(MainForm.this, "Overwrite failed. Is file write protected or in use?", "Failed", 0);
                                return;
                            }
                        }
                        MainForm.this.getDownloadDialog().setLocation(Helpers.getFrameCenteredLocation(MainForm.this.getDownloadDialog(), MainForm.this));
                        MainForm.this.getDownloadDialog().setCurrentFileName("http://www.quippy.de/download.php?file=./modplayer/javamod.jar");
                        MainForm.this.getDownloadDialog().setVisible(true);
                        int copied = Helpers.downloadJavaMod(destination, MainForm.this.getDownloadDialog());
                        MainForm.this.getDownloadDialog().setVisible(false);
                        if (copied == -1) {
                            JOptionPane.showMessageDialog(MainForm.this, "Download failed!\n" + destination, "Failed", 0);
                        } else {
                            JOptionPane.showMessageDialog(MainForm.this, "Saved " + copied + " bytes successfully to\n" + destination + "\n\nNow exit JavaMod, move the downloaded file to\n" + programmDestination + "\nand restart javamod.\n\n", "Success", 1);
                        }
                        return;
                    }
                } else if (compareResult > 0) {
                    JOptionPane.showMessageDialog(MainForm.this, "Your version of JavaMod is newer!", "Newer version", 1);
                } else {
                    JOptionPane.showMessageDialog(MainForm.this, "Your version of JavaMod is up-to-date.", "Up-To-Date", 1);
                }
            }
        }).start();
    }

    private void doShowAbout() {
        this.getJavaModAbout().setVisible(true);
    }

    public void doStartPlaying() {
        this.doStartPlaying(false, 0L);
    }

    public void doStartPlaying(boolean reuseMixer, long initialSeek) {
        if (this.currentContainer != null) {
            if (this.playerThread != null && !reuseMixer) {
                this.playerThread.stopMod();
                this.playerThread = null;
                this.removeMixer();
            }
            if (this.inExportMode) {
                this.inExportMode = false;
                this.doExportToWave();
            }
            if (this.playerThread == null) {
                Mixer mixer = this.createNewMixer();
                if (mixer != null) {
                    if (initialSeek > 0L) {
                        mixer.setMillisecondPosition(initialSeek);
                    }
                    this.playerThread = new PlayThread(mixer, this);
                    this.playerThread.start();
                }
            } else {
                this.playerThread.getCurrentMixer().setMillisecondPosition(initialSeek);
            }
        }
    }

    private void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.getSoundOutputStream().closeAllDevices();
            this.playerThread = null;
            this.removeMixer();
        }
    }

    private void doPausePlaying() {
        if (this.playerThread != null) {
            this.playerThread.pausePlay();
        }
    }

    private boolean doNextPlayListEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && this.currentPlayList.hasNext() && !ok) {
            this.currentPlayList.next();
            ok = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry());
        }
        return ok;
    }

    private boolean doPrevPlayListEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && this.currentPlayList.hasPrevious() && !ok) {
            this.currentPlayList.previous();
            ok = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry());
        }
        return ok;
    }

    @Override
    public void userSelectedPlaylistEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && !ok) {
            PlayListEntry entry = this.currentPlayList.getCurrentEntry();
            ok = this.loadMultimediaFile(entry);
            if (!ok) {
                this.currentPlayList.next();
                continue;
            }
            if (this.playerThread != null) continue;
            this.doStartPlaying(true, entry.getTimeIndex());
        }
    }

    private void doSetVoumeValue() {
        if (this.playerThread != null) {
            Mixer currentMixer = this.playerThread.getCurrentMixer();
            currentMixer.setVolume(this.currentVolume);
        }
    }

    private void doSetBalanceValue() {
        if (this.playerThread != null) {
            Mixer currentMixer = this.playerThread.getCurrentMixer();
            currentMixer.setBalance(this.currentBalance);
        }
    }

    private SoundOutputStream getSoundOutputStream() {
        if (this.soundOutputStream == null) {
            this.soundOutputStream = new GaplessSoundOutputStreamImpl();
        }
        return this.soundOutputStream;
    }

    private Mixer createNewMixer() {
        Mixer mixer = this.getCurrentContainer().createNewMixer();
        if (mixer != null) {
            mixer.setAudioProcessor(this.audioProcessor);
            mixer.setVolume(this.currentVolume);
            mixer.setBalance(this.currentBalance);
            mixer.setSoundOutputStream(this.getSoundOutputStream());
            this.getSeekBarPanel().setCurrentMixer(mixer);
        }
        return mixer;
    }

    private void removeMixer() {
        this.getSeekBarPanel().setCurrentMixer(null);
    }

    private boolean loadMultimediaOrPlayListFile(URL mediaPLSFileURL) {
        Log.info("");
        this.addFileToLastLoaded(mediaPLSFileURL);
        this.currentPlayList = null;
        try {
            this.currentPlayList = PlayList.createFromFile(mediaPLSFileURL, false, false);
            if (this.currentPlayList != null) {
                this.getPlaylistGUI().setNewPlaylist(this.currentPlayList);
                return this.doNextPlayListEntry();
            }
        }
        catch (Throwable ex) {
            Log.error("[MainForm::loadMultimediaOrPlayListFile]", ex);
            this.currentPlayList = null;
        }
        return false;
    }

    private boolean loadMultimediaFile(PlayListEntry playListEntry) {
        boolean reuseMixer;
        URL mediaFileURL = playListEntry.getFile();
        boolean bl = reuseMixer = this.currentContainer != null && Helpers.isEqualURL(this.currentContainer.getFileURL(), mediaFileURL) && this.playerThread != null && this.playerThread.isRunning();
        if (!reuseMixer) {
            try {
                MultimediaContainer newContainer;
                if (mediaFileURL != null && (newContainer = MultimediaContainerManager.getMultimediaContainer(mediaFileURL)) != null) {
                    this.currentContainer = newContainer;
                    this.getLEDScrollPanel().setScrollTextTo(this.currentContainer.getSongName() + "     ");
                    this.getTrayIcon().setToolTip(this.currentContainer.getSongName());
                }
            }
            catch (Throwable ex) {
                Log.error("[MainForm::loadMultimediaFile] Loading of " + mediaFileURL + " failed!", ex);
                return false;
            }
            this.changeInfoPane();
            this.changeConfigPane();
            this.changeExportMenu();
        }
        this.setPlayListIcons();
        if (this.playerThread != null) {
            this.doStartPlaying(reuseMixer, playListEntry.getTimeIndex());
        }
        return true;
    }

    private void addFileToLastLoaded(URL url) {
        if (this.lastLoaded.contains(url)) {
            this.lastLoaded.remove(url);
        }
        this.lastLoaded.add(0, url);
        this.createRecentFileMenuItems();
    }

    private MultimediaContainer getCurrentContainer() {
        if (this.currentContainer == null) {
            try {
                this.currentContainer = MultimediaContainerManager.getMultimediaContainerForType("mod");
            }
            catch (Exception ex) {
                Log.error("getCurrentContainer()", ex);
            }
        }
        return this.currentContainer;
    }

    private synchronized void showMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainForm.this.getMessages().setText(msg);
            }
        });
    }

    private final class MakeMainWindowVisible
    implements WindowFocusListener {
        private MakeMainWindowVisible() {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            MainForm.this.setFocusableWindowState(false);
            MainForm.this.toFront();
            MainForm.this.setFocusableWindowState(true);
        }
    }

    private final class MouseWheelVolumeControl
    implements MouseWheelListener {
        private MouseWheelVolumeControl() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!e.isConsumed() && e.getScrollType() == 0) {
                RoundSlider volSlider = MainForm.this.getVolumeSlider();
                volSlider.setValue(volSlider.getValue() + (float)e.getWheelRotation() / 100.0f);
                e.consume();
            }
        }
    }

    private final class LookAndFeelChanger
    implements ActionListener {
        private String uiClassName;
        private JCheckBoxMenuItem parent;

        public LookAndFeelChanger(JCheckBoxMenuItem parent, String uiClassName) {
            this.uiClassName = uiClassName;
            this.parent = parent;
        }

        private void setSelection() {
            for (int i = 0; i < MainForm.this.menu_LookAndFeel_Items.length; ++i) {
                if (MainForm.this.menu_LookAndFeel_Items[i] == this.parent) {
                    MainForm.this.menu_LookAndFeel_Items[i].setSelected(true);
                    continue;
                }
                MainForm.this.menu_LookAndFeel_Items[i].setSelected(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.setSelection();
            MainForm.this.uiClassName = this.uiClassName;
            MainForm.this.updateLookAndFeel(this.uiClassName);
        }
    }
}

