/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class PlayerConfigPanel
extends JPanel {
    private static final long serialVersionUID = -923697640128200718L;
    private JTabbedPane tabbedPane = null;

    public PlayerConfigPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName("playerSetUpTabbedPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTabbedPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 10, 1.0, 1.0));
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1, 1);
            this.tabbedPane.setFont(Helpers.getDialogFont());
            ArrayList<MultimediaContainer> containerList = MultimediaContainerManager.getContainerArray();
            for (int i = 0; i < containerList.size(); ++i) {
                MultimediaContainer container = containerList.get(i);
                JPanel configPanel = container.getConfigPanel();
                if (configPanel == null) continue;
                JScrollPane containerScroller = new JScrollPane();
                containerScroller.setName("scrollPane_Config_" + container.getName());
                containerScroller.setViewportView(configPanel);
                this.tabbedPane.add(container.getName(), containerScroller);
            }
        }
        return this.tabbedPane;
    }

    public void selectTabForContainer(MultimediaContainer currentContainer) {
        for (int i = 0; i < this.getTabbedPane().getTabCount(); ++i) {
            if (!this.getTabbedPane().getTitleAt(i).equals(currentContainer.getName())) continue;
            this.getTabbedPane().setSelectedIndex(i);
            return;
        }
    }
}

