/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SimpleTextViewerDialog
extends JDialog {
    private static final long serialVersionUID = -5666092255473846658L;
    private static final String DEFAULT_CODING = "ISO-8859-1";
    private JButton closeButton;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private URL url = null;
    private String coding = "ISO-8859-1";

    public SimpleTextViewerDialog(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.initialize();
    }

    public SimpleTextViewerDialog(JFrame owner, boolean modal, URL url, String coding) {
        this(owner, modal);
        this.coding = coding;
        this.setDisplayTextFromURL(url);
    }

    public SimpleTextViewerDialog(JFrame owner, boolean modal, String url, String coding) {
        this(owner, modal, Helpers.createURLfromString(url), coding);
    }

    public SimpleTextViewerDialog(JFrame owner, boolean modal, URL url) {
        this(owner, modal, url, DEFAULT_CODING);
    }

    public SimpleTextViewerDialog(JFrame owner, boolean modal, String url) {
        this(owner, modal, url, DEFAULT_CODING);
    }

    private void initialize() {
        this.setTitle("File Viewer");
        this.setName("SimpleTextFileViewer");
        this.setSize(new Dimension(640, 480));
        this.setPreferredSize(this.getSize());
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SimpleTextViewerDialog.this.doClose();
            }
        });
        this.setLayout(new GridBagLayout());
        Container panel = this.getContentPane();
        panel.add((Component)this.getScrollPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 17, 1.0, 1.0));
        panel.add((Component)this.getCloseButton(), Helpers.getGridBagConstraint(0, 1, 1, 0, 0, 10, 0.0, 0.0));
        if (this.url != null) {
            this.fillTextArea();
        }
        this.pack();
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setName("scrollPane_TextField");
            this.scrollPane.setViewportView(this.getTextArea());
        }
        return this.scrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setName("modInfo_Instruments");
            this.textArea.setEditable(false);
            this.textArea.setFont(Helpers.getTextAreaFont());
        }
        return this.textArea;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setMnemonic('C');
            this.closeButton.setText("Close");
            this.closeButton.setToolTipText("Close");
            this.closeButton.setFont(Helpers.getDialogFont());
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SimpleTextViewerDialog.this.doClose();
                }
            });
        }
        return this.closeButton;
    }

    public void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.getParent() == null) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTextArea() {
        if (this.url != null) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(this.url.openStream(), this.coding));
                StringBuilder fullText = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    fullText.append(line).append('\n');
                }
                this.getTextArea().setText(fullText.toString());
                this.getTextArea().select(0, 0);
            }
            catch (Throwable ex) {
                Log.error("reading text failed", ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        Log.error("IGNORED", ex);
                    }
                }
            }
        }
    }

    public void setDisplayTextFromURL(URL url) {
        this.url = url;
        this.fillTextArea();
    }

    public void setDisplayTextFromURL(String url) {
        this.setDisplayTextFromURL(Helpers.createURLfromString(url));
    }
}

