/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.ThreadUpdatePanel;
import de.quippy.javamod.system.Log;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.border.Border;

public abstract class MeterPanelBase
extends ThreadUpdatePanel {
    private static final long serialVersionUID = -7284099301353768209L;
    private volatile int myTop;
    private volatile int myLeft;
    private volatile int myWidth;
    private volatile int myHeight;
    private Image imageBuffer;

    public MeterPanelBase(int desiredFPS) {
        super(desiredFPS);
        this.prepareComponentListener();
    }

    private void prepareComponentListener() {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MeterPanelBase.this.internalComponentWasResized();
            }
        });
    }

    protected synchronized void internalComponentWasResized() {
        this.imageBuffer = null;
        Border b = this.getBorder();
        Insets inset = b == null ? new Insets(1, 1, 1, 1) : b.getBorderInsets(this);
        this.myTop = inset.top;
        this.myLeft = inset.left;
        this.myWidth = this.getWidth() - inset.left - inset.right;
        this.myHeight = this.getHeight() - inset.top - inset.bottom;
        if (this.myWidth > 0 && this.myHeight > 0) {
            this.componentWasResized(0, 0, this.myWidth, this.myHeight);
        }
    }

    protected Image getDoubleBuffer() {
        GraphicsConfiguration graConf;
        if (this.imageBuffer == null && this.myWidth > 0 && this.myHeight > 0 && (graConf = this.getGraphicsConfiguration()) != null) {
            this.imageBuffer = graConf.createCompatibleImage(this.myWidth, this.myHeight);
        }
        return this.imageBuffer;
    }

    @Override
    protected synchronized void doThreadUpdate() {
        Image buffer = this.getDoubleBuffer();
        if (buffer != null) {
            try {
                this.drawMeter(buffer.getGraphics(), 0, 0, this.myWidth, this.myHeight);
                this.repaint();
            }
            catch (Exception ex) {
                Log.error("drawMeter:", ex);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Image buffer = this.getDoubleBuffer();
        if (buffer != null) {
            g.drawImage(buffer, this.myLeft, this.myTop, null);
        }
    }

    protected abstract void drawMeter(Graphics var1, int var2, int var3, int var4, int var5);

    protected abstract void componentWasResized(int var1, int var2, int var3, int var4);
}

