/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RoundSlider
extends JComponent {
    private static final long serialVersionUID = 7401158894851891182L;
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static final double PI_2 = Math.PI * 2;
    private static final double START_ANG = 5.497787143782138;
    private static final double LENGTH_ANG = 4.71238898038469;
    private ChangeEvent changeEvent = null;
    private double lastAngle;
    private double currentAngle;
    private float currentValue;

    public RoundSlider() {
        this.initialize();
    }

    private void initialize() {
        this.setValue(0.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                RoundSlider.this.lastAngle = RoundSlider.this.getAngle(me);
                RoundSlider.this.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                double ang = RoundSlider.this.getAngle(me);
                RoundSlider.this.setValue((float)((5.497787143782138 - ang) / 4.71238898038469));
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                double ang = RoundSlider.this.getAngle(me);
                double diff = ang - RoundSlider.this.lastAngle;
                RoundSlider.this.lastAngle = ang;
                float newValue = (float)((double)RoundSlider.this.getValue() - diff / 4.71238898038469);
                if ((double)Math.abs(newValue - RoundSlider.this.getValue()) < 0.5) {
                    RoundSlider.this.setValue(newValue);
                }
            }

            @Override
            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    public float getValue() {
        return this.currentValue;
    }

    public void setValue(float newVal) {
        this.currentValue = newVal < 0.0f ? 0.0f : (newVal > 1.0f ? 1.0f : newVal);
        this.currentAngle = 5.497787143782138 - 4.71238898038469 * (double)this.currentValue;
        this.repaint();
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    private int getMaxSize() {
        int height;
        int width = this.getWidth();
        return width < (height = this.getHeight()) ? width : height;
    }

    private double getAngle(MouseEvent me) {
        int middle = this.getMaxSize() >> 1;
        int xpos = me.getX() - middle;
        int ypos = me.getY() - middle;
        double ang = Math.atan2(xpos, ypos);
        if (xpos < 0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    @Override
    public void paintComponent(Graphics g) {
        int size = this.getMaxSize();
        int middle = size >> 1;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(this.getParent().getBackground());
            g2d.setRenderingHints(AALIAS);
        }
        --middle;
        int startColor = 64;
        int colorStep = (255 - startColor) / (size -= 2);
        for (int i = size; i >= 0; --i) {
            g.setColor(new Color(startColor, startColor, startColor));
            int x = 1 + middle - (i >> 1);
            g.fillOval(x, x, i, i);
            startColor += colorStep;
        }
        g.setColor(Color.RED);
        double sin = Math.sin(this.currentAngle);
        double cos = Math.cos(this.currentAngle);
        int x = middle + (int)((double)middle * sin);
        int y = middle + (int)((double)middle * cos);
        g.drawLine(middle, middle, x, y);
    }
}

