/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.MeterPanelBase;
import de.quippy.javamod.mixer.dsp.FFT;
import de.quippy.javamod.system.FastMath;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SAMeterPanel
extends MeterPanelBase {
    private static final long serialVersionUID = 3032239961770238793L;
    private static final int FFT_SAMPLE_SIZE = 512;
    protected static final int DRAW_SA_METER = 0;
    protected static final int DRAW_WAVE_METER = 1;
    protected static final int DRAW_SK_METER = 2;
    private static final Color WAVEMETER_LINE_COLOR = Color.darkGray;
    private static final Color WAVEMETER_WAVE_COLOR = Color.green;
    private FFT fftCalc;
    private Color[] color;
    private Color[] SKcolor;
    private int SKMax;
    private float[] fftLevels;
    private float[] maxFFTLevels;
    private float[] floatSamples;
    private int anzSamples;
    private int bands;
    private int multiplier;
    private float rampDownValue;
    private float[] maxPeakLevelRampDownValue;
    private float maxPeakLevelRampDownDelay;
    private int myBottom;
    private float myHalfHeight;
    private int barWidth;
    private int drawWhat;
    private boolean switched;

    public SAMeterPanel(int updateRate, int bands) {
        super(updateRate);
        this.bands = bands;
        this.fftCalc = new FFT(512);
        this.multiplier = 256 / bands;
        this.fftLevels = new float[this.bands];
        this.maxFFTLevels = new float[this.bands];
        this.maxPeakLevelRampDownValue = new float[this.bands];
        this.drawWhat = 0;
        this.switched = true;
        this.prepareDisplayToggleListener();
        this.startThread();
    }

    private void prepareDisplayToggleListener() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent pEvent) {
                if (pEvent.getButton() == 1) {
                    SAMeterPanel.this.drawWhat++;
                    if (SAMeterPanel.this.drawWhat > 2) {
                        SAMeterPanel.this.drawWhat = 0;
                    }
                    SAMeterPanel.this.switched = true;
                }
            }
        });
    }

    protected void setDrawWhatTo(int newDrawWhat) {
        this.drawWhat = newDrawWhat;
    }

    @Override
    protected void componentWasResized(int newTop, int newLeft, int newWidth, int newHeight) {
        int i;
        this.rampDownValue = (float)this.getDesiredFPS() / 2000.0f;
        this.maxPeakLevelRampDownDelay = this.rampDownValue / 50.0f;
        if (newTop < 0 || newLeft < 0 || newWidth < 0 || newHeight < 0) {
            return;
        }
        this.myBottom = newTop + newHeight;
        this.myHalfHeight = (float)newHeight / 2.0f;
        this.barWidth = newWidth / this.bands;
        this.color = new Color[newHeight + 1];
        for (i = 0; i <= newHeight; ++i) {
            int color1 = i * 255 / newHeight;
            int color2 = 255 - color1;
            this.color[i] = new Color(color1, color2, 0);
        }
        this.SKMax = 1024;
        this.SKcolor = new Color[this.SKMax];
        for (i = 0; i < 256; ++i) {
            this.SKcolor[i] = new Color(0, 0, i);
        }
        for (i = 256; i < 512; ++i) {
            this.SKcolor[i] = new Color(0, i - 256, 511 - i);
        }
        for (i = 512; i < 768; ++i) {
            this.SKcolor[i] = new Color(i - 512, 767 - i, 0);
        }
        for (i = 768; i < 1024; ++i) {
            this.SKcolor[i] = new Color(255, i - 768, 0);
        }
    }

    public void setMeter(float[] newSamples) {
        if (newSamples != null) {
            this.anzSamples = newSamples.length;
            if (this.floatSamples == null || this.floatSamples.length != this.anzSamples) {
                this.floatSamples = new float[this.anzSamples];
            }
            System.arraycopy(newSamples, 0, this.floatSamples, 0, this.anzSamples);
            float[] resultFFTSamples = this.fftCalc.calculate(this.floatSamples);
            int a = 0;
            for (int bd = 0; bd < this.bands; ++bd) {
                float wFs = resultFFTSamples[a];
                for (int b = 1; b < this.multiplier; ++b) {
                    wFs += resultFFTSamples[a + b];
                }
                if ((wFs *= (float)FastMath.log(bd + 2)) > 1.0f) {
                    wFs = 1.0f;
                }
                if (wFs > this.fftLevels[bd]) {
                    this.fftLevels[bd] = wFs;
                    if (this.fftLevels[bd] > this.maxFFTLevels[bd]) {
                        this.maxFFTLevels[bd] = this.fftLevels[bd];
                        this.maxPeakLevelRampDownValue[bd] = this.maxPeakLevelRampDownDelay;
                    }
                }
                a += this.multiplier;
            }
        } else {
            this.floatSamples = null;
        }
    }

    @Override
    protected void drawMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        this.drawMeter(g, newTop, newLeft, newWidth, newHeight, true);
    }

    protected void drawMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight, boolean doClear) {
        if (g != null) {
            switch (this.drawWhat) {
                default: {
                    this.drawSAMeter(g, newTop, newLeft, newWidth, newHeight, doClear);
                    break;
                }
                case 1: {
                    this.drawWaveMeter(g, newTop, newLeft, newWidth, newHeight, doClear);
                    break;
                }
                case 2: {
                    this.drawSKMeter(g, newTop, newLeft, newWidth, newHeight);
                }
            }
        }
        for (int i = 0; i < this.bands; ++i) {
            int n = i;
            this.fftLevels[n] = this.fftLevels[n] - this.rampDownValue;
            if (this.fftLevels[i] < 0.0f) {
                this.fftLevels[i] = 0.0f;
            }
            int n2 = i;
            this.maxFFTLevels[n2] = this.maxFFTLevels[n2] - this.maxPeakLevelRampDownValue[i];
            if (this.maxFFTLevels[i] < 0.0f) {
                this.maxFFTLevels[i] = 0.0f;
                continue;
            }
            int n3 = i;
            this.maxPeakLevelRampDownValue[n3] = this.maxPeakLevelRampDownValue[n3] + this.maxPeakLevelRampDownDelay;
        }
    }

    private void drawWaveMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight, boolean doClear) {
        if (doClear) {
            g.setColor(Color.BLACK);
            g.fillRect(newLeft, newTop, newWidth, newHeight);
        }
        g.setColor(WAVEMETER_LINE_COLOR);
        g.drawLine(newLeft, newTop + (int)this.myHalfHeight, newLeft + newWidth, newTop + (int)this.myHalfHeight);
        if (this.floatSamples == null) {
            return;
        }
        int add = this.anzSamples / newWidth >> 1;
        if (add <= 0) {
            add = 1;
        }
        int xpOld = 0;
        int ypOld = (int)(this.myHalfHeight - this.floatSamples[0] * this.myHalfHeight);
        if (ypOld < 0) {
            ypOld = 0;
        } else if (ypOld > newHeight) {
            ypOld = newHeight;
        }
        g.setColor(WAVEMETER_WAVE_COLOR);
        for (int i = add; i < this.anzSamples; i += add) {
            int xp = i * newWidth / this.anzSamples;
            if (xp < 0) {
                xp = 0;
            } else if (xp > newWidth) {
                xp = newWidth;
            }
            int yp = (int)(this.myHalfHeight - this.floatSamples[i] * this.myHalfHeight);
            if (yp < 0) {
                yp = 0;
            } else if (yp > newHeight) {
                yp = newHeight;
            }
            g.drawLine(newLeft + xpOld, newTop + ypOld, newLeft + xp, newTop + yp);
            xpOld = xp;
            ypOld = yp;
        }
    }

    private void drawSAMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight, boolean doClear) {
        if (doClear) {
            g.setColor(Color.BLACK);
            g.fillRect(newLeft, newTop, newWidth, newHeight);
        }
        for (int i = 0; i < this.bands; ++i) {
            int barX = i * this.barWidth;
            int barX1 = barX + this.barWidth - 2;
            int barHeight = (int)((float)newHeight * this.fftLevels[i]);
            int maxBarHeight = (int)((float)newHeight * this.maxFFTLevels[i]);
            int c = barHeight;
            for (int y = this.myBottom - barHeight; y < this.myBottom; ++y) {
                g.setColor(this.color[c--]);
                g.drawLine(newLeft + barX, newTop + y, newLeft + barX1, newTop + y);
            }
            if (maxBarHeight <= barHeight) continue;
            g.setColor(this.color[maxBarHeight]);
            g.drawLine(newLeft + barX, newTop + this.myBottom - maxBarHeight, newLeft + barX1, newTop + this.myBottom - maxBarHeight);
        }
    }

    private void drawSKMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        if (this.switched) {
            g.setColor(Color.BLACK);
            g.fillRect(newLeft, newTop, newWidth, newHeight);
            this.switched = false;
        }
        g.copyArea(newLeft, newTop, newWidth - 1, newHeight, 1, 0);
        int max = this.bands - 1;
        for (int i = 0; i <= max; ++i) {
            int bary = newHeight * (max - i) / this.bands;
            g.setColor(this.SKcolor[(int)((float)(this.SKMax - 1) * this.fftLevels[i])]);
            g.drawLine(newLeft, newTop + bary, newLeft, newTop + bary + 2);
        }
    }
}

