/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.SeekBarPanelListener;
import de.quippy.javamod.main.gui.components.ThreadUpdatePanel;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class SeekBarPanel
extends ThreadUpdatePanel {
    private static final long serialVersionUID = -3570075762823459752L;
    private JTextField timeTextField = null;
    private JLabel timeLabel = null;
    private JTextField KBSField = null;
    private JLabel KBSLabel = null;
    private JTextField KHZField = null;
    private JLabel KHZLabel = null;
    private JTextField activeChannelsTextField = null;
    private JLabel activeChannelsLabel = null;
    private JProgressBar timeBar = null;
    private boolean showBarOnly;
    private long maxLengthInMillis = 0L;
    private int displayWhat = 0;
    private Mixer currentMixer;
    private ArrayList<SeekBarPanelListener> listeners;

    public SeekBarPanel(int desiredFPS, boolean showBarOnly) {
        super(desiredFPS);
        this.showBarOnly = showBarOnly;
        this.listeners = new ArrayList();
        this.initialize();
        this.startThread();
    }

    public synchronized void addListener(SeekBarPanelListener newListener) {
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public synchronized void removeListener(SeekBarPanelListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void fireValuesChanged(long milliseconds) {
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.get(i).valuesChanged(milliseconds);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        if (!this.showBarOnly) {
            this.add((Component)this.getTimeTextField(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 0.0, 0.0));
            this.add((Component)this.getTimeLabel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 17, 1.0, 0.0));
            this.add((Component)this.getKBSField(), Helpers.getGridBagConstraint(2, 0, 1, 1, 0, 17, 0.0, 0.0));
            this.add((Component)this.getKBSLabel(), Helpers.getGridBagConstraint(3, 0, 1, 1, 0, 17, 1.0, 0.0));
            this.add((Component)this.getKHZField(), Helpers.getGridBagConstraint(4, 0, 1, 1, 0, 17, 0.0, 0.0));
            this.add((Component)this.getKHZLabel(), Helpers.getGridBagConstraint(5, 0, 1, 1, 0, 17, 1.0, 0.0));
            this.add((Component)this.getActiveChannelsTextField(), Helpers.getGridBagConstraint(6, 0, 1, 1, 0, 17, 0.0, 0.0));
            this.add((Component)this.getActiveChannelsLabel(), Helpers.getGridBagConstraint(7, 0, 1, 0, 0, 17, 1.0, 0.0));
            this.add((Component)this.getTimeBar(), Helpers.getGridBagConstraint(0, 1, 1, 0, 2, 17, 1.0, 0.0));
        } else {
            this.add((Component)this.getTimeTextField(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 0.0, 0.0));
            this.add((Component)this.getTimeBar(), Helpers.getGridBagConstraint(1, 0, 1, 0, 2, 13, 1.0, 0.0));
        }
    }

    public JTextField getTimeTextField() {
        if (this.timeTextField == null) {
            this.timeTextField = new JTextField("0:00");
            this.timeTextField.setHorizontalAlignment(11);
            this.timeTextField.setEditable(false);
            this.timeTextField.setName("timeTextField");
            this.timeTextField.setFont(Helpers.getDialogFont());
            this.timeTextField.setCursor(Cursor.getPredefinedCursor(12));
            FontMetrics metrics = this.timeTextField.getFontMetrics(Helpers.getDialogFont());
            Dimension d = new Dimension(6 * metrics.charWidth('0'), metrics.getHeight());
            this.timeTextField.setSize(d);
            this.timeTextField.setMinimumSize(d);
            this.timeTextField.setMaximumSize(d);
            this.timeTextField.setPreferredSize(d);
            this.timeTextField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent pEvent) {
                    if (pEvent.getButton() == 1 && SeekBarPanel.this.currentMixer != null) {
                        SeekBarPanel.this.displayWhat = 1 - SeekBarPanel.this.displayWhat;
                    }
                }
            });
        }
        return this.timeTextField;
    }

    public JLabel getTimeLabel() {
        if (this.timeLabel == null) {
            this.timeLabel = new JLabel();
            this.timeLabel.setName("timeLabel");
            this.timeLabel.setText("time");
            this.timeLabel.setFont(Helpers.getDialogFont());
        }
        return this.timeLabel;
    }

    public JTextField getKBSField() {
        if (this.KBSField == null) {
            this.KBSField = new JTextField("--");
            this.KBSField.setHorizontalAlignment(11);
            this.KBSField.setEditable(false);
            this.KBSField.setName("KBSField");
            this.KBSField.setFont(Helpers.getDialogFont());
            FontMetrics metrics = this.timeTextField.getFontMetrics(Helpers.getDialogFont());
            Dimension d = new Dimension(6 * metrics.charWidth('0'), metrics.getHeight());
            this.KBSField.setSize(d);
            this.KBSField.setMinimumSize(d);
            this.KBSField.setMaximumSize(d);
            this.KBSField.setPreferredSize(d);
        }
        return this.KBSField;
    }

    public JLabel getKBSLabel() {
        if (this.KBSLabel == null) {
            this.KBSLabel = new JLabel();
            this.KBSLabel.setName("KBSLabel");
            this.KBSLabel.setText("KB/s");
            this.KBSLabel.setFont(Helpers.getDialogFont());
        }
        return this.KBSLabel;
    }

    public JTextField getKHZField() {
        if (this.KHZField == null) {
            this.KHZField = new JTextField("--");
            this.KHZField.setHorizontalAlignment(11);
            this.KHZField.setEditable(false);
            this.KHZField.setName("KHZField");
            this.KHZField.setFont(Helpers.getDialogFont());
            FontMetrics metrics = this.timeTextField.getFontMetrics(Helpers.getDialogFont());
            Dimension d = new Dimension(4 * metrics.charWidth('0'), metrics.getHeight());
            this.KHZField.setSize(d);
            this.KHZField.setMinimumSize(d);
            this.KHZField.setMaximumSize(d);
            this.KHZField.setPreferredSize(d);
        }
        return this.KHZField;
    }

    public JLabel getKHZLabel() {
        if (this.KHZLabel == null) {
            this.KHZLabel = new JLabel();
            this.KHZLabel.setName("KHZLabel");
            this.KHZLabel.setText("KHZ");
            this.KHZLabel.setFont(Helpers.getDialogFont());
        }
        return this.KHZLabel;
    }

    public JTextField getActiveChannelsTextField() {
        if (this.activeChannelsTextField == null) {
            this.activeChannelsTextField = new JTextField("--");
            this.activeChannelsTextField.setHorizontalAlignment(11);
            this.activeChannelsTextField.setEditable(false);
            this.activeChannelsTextField.setName("activeChannelsTextField");
            this.activeChannelsTextField.setFont(Helpers.getDialogFont());
            FontMetrics metrics = this.timeTextField.getFontMetrics(Helpers.getDialogFont());
            Dimension d = new Dimension(4 * metrics.charWidth('0'), metrics.getHeight());
            this.activeChannelsTextField.setSize(d);
            this.activeChannelsTextField.setMinimumSize(d);
            this.activeChannelsTextField.setMaximumSize(d);
            this.activeChannelsTextField.setPreferredSize(d);
        }
        return this.activeChannelsTextField;
    }

    public JLabel getActiveChannelsLabel() {
        if (this.activeChannelsLabel == null) {
            this.activeChannelsLabel = new JLabel();
            this.activeChannelsLabel.setName("activeChannelsLabel");
            this.activeChannelsLabel.setText("Chn");
            this.activeChannelsLabel.setFont(Helpers.getDialogFont());
        }
        return this.activeChannelsLabel;
    }

    public JProgressBar getTimeBar() {
        if (this.timeBar == null) {
            this.timeBar = new JProgressBar(0, 0);
            this.timeBar.setValue(0);
            this.timeBar.setCursor(Cursor.getPredefinedCursor(12));
            this.timeBar.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent pEvent) {
                    if (pEvent.getButton() == 1 && SeekBarPanel.this.currentMixer != null) {
                        Point p = pEvent.getPoint();
                        double x = p.getX();
                        int width = SeekBarPanel.this.timeBar.getWidth();
                        BoundedRangeModel model = SeekBarPanel.this.getTimeBar().getModel();
                        SeekBarPanel.this.currentMixer.setMillisecondPosition((long)((double)model.getMaximum() * x) / (long)width);
                    }
                }
            });
        }
        return this.timeBar;
    }

    public synchronized void setCurrentMixer(Mixer newMixer) {
        this.currentMixer = newMixer;
        this.getTimeBar().setValue(0);
        this.getTimeTextField().setText("0:00");
        this.getKBSField().setText("--");
        this.getKHZField().setText("--");
        this.getActiveChannelsTextField().setText("--");
        if (this.currentMixer != null) {
            BoundedRangeModel model = this.getTimeBar().getModel();
            this.maxLengthInMillis = this.currentMixer.getLengthInMilliseconds();
            model.setMaximum((int)this.maxLengthInMillis);
        }
    }

    @Override
    protected synchronized void doThreadUpdate() {
        if (this.currentMixer != null) {
            long timeCode = this.currentMixer.getMillisecondPosition();
            this.getTimeBar().setValue((int)timeCode);
            this.fireValuesChanged(timeCode);
            if (!this.showBarOnly) {
                if (this.displayWhat == 1) {
                    timeCode = this.maxLengthInMillis - timeCode;
                }
                this.getTimeTextField().setText(Helpers.getTimeStringFromMilliseconds(timeCode));
                this.getKBSField().setText(Integer.toString(this.currentMixer.getCurrentKBperSecond()));
                this.getKHZField().setText(Integer.toString(this.currentMixer.getCurrentSampleFrequency()));
                this.getActiveChannelsTextField().setText(Integer.toString(this.currentMixer.getChannelCount()));
            }
        }
    }
}

