/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.system.Log;
import javax.swing.JPanel;

public abstract class ThreadUpdatePanel
extends JPanel {
    private static final long serialVersionUID = 499420014207584726L;
    private volatile boolean threadRunning;
    private volatile int pause;
    private final int desiredFPS;
    private final MeterUpdateThread uiUpdateThread;
    private final long nanoWait;

    public ThreadUpdatePanel(int desiredFPS) {
        this.desiredFPS = desiredFPS;
        this.nanoWait = 1000000000L / (long)desiredFPS;
        this.uiUpdateThread = new MeterUpdateThread(this);
    }

    protected void startThread() {
        this.threadRunning = true;
        this.uiUpdateThread.start();
    }

    public void pauseThread() {
        if (this.pause == 0) {
            this.pause = 1;
            while (this.pause == 1) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void unPauseThread() {
        this.pause = 0;
    }

    protected void stopThread() {
        this.threadRunning = false;
    }

    public int getDesiredFPS() {
        return this.desiredFPS;
    }

    protected abstract void doThreadUpdate();

    private static final class MeterUpdateThread
    extends Thread {
        private final ThreadUpdatePanel me;

        public MeterUpdateThread(ThreadUpdatePanel me) {
            this.me = me;
            this.setName("ThreadUpdatePanel::" + me.getClass().getName());
            this.setDaemon(true);
            this.setPriority(10);
        }

        @Override
        public void run() {
            while (this.me.threadRunning) {
                long now = System.nanoTime();
                try {
                    this.me.doThreadUpdate();
                }
                catch (Throwable ex) {
                    Log.error(this.getName(), ex);
                }
                long stillToWait = this.me.nanoWait - (System.nanoTime() - now);
                if (stillToWait > 0L) {
                    try {
                        Thread.sleep(stillToWait / 1000000L);
                    }
                    catch (InterruptedException ex) {}
                } else {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (this.me.pause != 1) continue;
                this.me.pause = 2;
                while (this.me.pause == 2) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
    }
}

