/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.MeterPanelBase;
import java.awt.Color;
import java.awt.Graphics;

public class VUMeterPanel
extends MeterPanelBase {
    private static final long serialVersionUID = -4587795218202329414L;
    private float currentLevel = 0.0f;
    private float currentMaxPeakLevel = 0.0f;
    private Color[] color;
    private Color[] colorLow;
    private float rampDownValue;
    private float maxPeakLevelRampDownValue;
    private float maxPeakLevelRampDownDelay;
    private int myAnzLines;

    public VUMeterPanel(int updateRate) {
        super(updateRate);
        this.startThread();
    }

    @Override
    protected synchronized void doThreadUpdate() {
        super.doThreadUpdate();
    }

    @Override
    protected void componentWasResized(int newTop, int newLeft, int newWidth, int newHeight) {
        this.rampDownValue = (float)this.getDesiredFPS() / 1000.0f;
        this.maxPeakLevelRampDownDelay = this.rampDownValue / 100.0f;
        this.maxPeakLevelRampDownValue = 0.0f;
        this.myAnzLines = newHeight >> 1;
        this.color = new Color[this.myAnzLines];
        this.colorLow = new Color[this.myAnzLines];
        for (int i = 0; i < this.myAnzLines; ++i) {
            int color1 = i * 255 / this.myAnzLines;
            int color2 = 255 - color1;
            this.color[i] = new Color(color1, color2, 0);
            this.colorLow[i] = new Color(color1 >> 1, color2 >> 1, 0);
        }
    }

    public void setVUMeter(float[] samples) {
        if (samples != null) {
            this.setVUMeter(samples, samples.length);
        }
    }

    public void setVUMeter(float[] samples, int length) {
        float newLevel = 0.0f;
        for (int i = 0; i < length; ++i) {
            float v = samples[i];
            if (v < 0.0f) {
                v *= -1.0f;
            }
            if (!(v > newLevel)) continue;
            newLevel = v;
        }
        if (newLevel > 1.0f) {
            newLevel = 1.0f;
        }
        if (newLevel > this.currentLevel) {
            this.currentLevel = newLevel;
            if (this.currentLevel > this.currentMaxPeakLevel) {
                this.currentMaxPeakLevel = this.currentLevel;
                this.maxPeakLevelRampDownValue = this.maxPeakLevelRampDownDelay;
            }
        }
    }

    @Override
    protected void drawMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        if (g != null) {
            int level = (int)((float)this.myAnzLines * this.currentLevel);
            int maxPeakLevel = (int)((float)this.myAnzLines * this.currentMaxPeakLevel);
            for (int i = 0; i < this.myAnzLines; ++i) {
                g.setColor(i >= level && i != maxPeakLevel ? this.colorLow[i] : this.color[i]);
                int ly = newHeight - (i << 1);
                g.drawLine(newLeft, newTop + ly, newLeft + newWidth, newTop + ly);
            }
        }
        this.currentLevel -= this.rampDownValue;
        if (this.currentLevel < 0.0f) {
            this.currentLevel = 0.0f;
        }
        this.currentMaxPeakLevel -= this.maxPeakLevelRampDownValue;
        if (this.currentMaxPeakLevel < 0.0f) {
            this.currentMaxPeakLevel = 0.0f;
        } else {
            this.maxPeakLevelRampDownValue += this.maxPeakLevelRampDownDelay;
        }
    }
}

