/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.playlist;

import de.quippy.javamod.main.gui.components.SimpleProgessDialog;
import de.quippy.javamod.main.gui.playlist.EditPlaylistEntry;
import de.quippy.javamod.main.gui.playlist.PlaylistGUIChangeListener;
import de.quippy.javamod.main.gui.tools.FileChooserResult;
import de.quippy.javamod.main.gui.tools.PlaylistDropListener;
import de.quippy.javamod.main.gui.tools.PlaylistDropListenerCallBack;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.main.playlist.PlaylistChangedListener;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;

public class PlayListGUI
extends JPanel
implements PlaylistChangedListener,
PlaylistDropListenerCallBack {
    private static final long serialVersionUID = -7914306014081401144L;
    private static final int PLUS_LINES_VISABLE = 2;
    private JDialog parentFrame = null;
    private PlayList playList;
    private PlayListEntry lastClickedEntry;
    private JCheckBox repeatCheckBox = null;
    private JScrollPane scrollPane = null;
    private JTextPane textArea = null;
    private JPopupMenu playListPopUp = null;
    private JMenuItem popUpEntryDeleteFromList = null;
    private JMenuItem popUpEntryCropFromList = null;
    private JMenuItem popUpEntryRefreshEntry = null;
    private JMenuItem popUpEntryEditEntry = null;
    private JMenuItem popUpEntrySaveList = null;
    private JMenuItem popUpEntryShuffleList = null;
    private JMenuItem popUpEntryCopyFilesInOrder = null;
    private SimpleProgessDialog downloadDialog = null;
    private EditPlaylistEntry editPlayListEntryDialog = null;
    private ArrayList<DropTarget> dropTargetList;
    private PlayListUpdateThread playlistUpdateThread;
    private String unmarkColorBackground;
    private String unmarkColorForeground;
    private String markColorBackground;
    private String markColorForeground;
    private ArrayList<PlaylistGUIChangeListener> listeners = new ArrayList();

    public PlayListGUI(JDialog parentFrame) {
        this.parentFrame = parentFrame;
        this.initialize();
    }

    private static String getHTMLColorString(Color color) {
        String htmlColor = Integer.toHexString(color.getRGB());
        if (htmlColor.length() > 6) {
            htmlColor = htmlColor.substring(htmlColor.length() - 6);
        }
        return htmlColor;
    }

    private void initialize() {
        this.setName("PlayList");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getScrollPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 17, 1.0, 1.0));
        this.add((Component)this.getRepeatCheckBox(), Helpers.getGridBagConstraint(0, 1, 1, 0, 0, 13, 0.0, 0.0));
        this.dropTargetList = new ArrayList();
        PlaylistDropListener myListener = new PlaylistDropListener(this);
        Helpers.registerDropListener(this.dropTargetList, this, myListener);
        this.unmarkColorBackground = PlayListGUI.getHTMLColorString(this.getPlaylistTextArea().getBackground());
        this.unmarkColorForeground = PlayListGUI.getHTMLColorString(this.getPlaylistTextArea().getForeground());
        this.markColorBackground = PlayListGUI.getHTMLColorString(this.getPlaylistTextArea().getSelectionColor());
        this.markColorForeground = PlayListGUI.getHTMLColorString(this.getPlaylistTextArea().getSelectedTextColor());
        this.playlistUpdateThread = new PlayListUpdateThread(this);
        this.playlistUpdateThread.start();
    }

    private JCheckBox getRepeatCheckBox() {
        if (this.repeatCheckBox == null) {
            this.repeatCheckBox = new JCheckBox();
            this.repeatCheckBox.setName("repeatCombobox");
            this.repeatCheckBox.setText("repeat playlist");
            this.repeatCheckBox.setFont(Helpers.getDialogFont());
            this.repeatCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 || e.getStateChange() == 2) {
                        if (PlayListGUI.this.playList != null) {
                            PlayListGUI.this.playList.setRepeat(PlayListGUI.this.repeatCheckBox.isSelected());
                        } else {
                            PlayListGUI.this.repeatCheckBox.setSelected(false);
                        }
                        PlayListGUI.this.firePlaylistChanged();
                    }
                }
            });
        }
        return this.repeatCheckBox;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setName("scrollPane_TextField");
            this.scrollPane.setViewportView(this.getPlaylistTextArea());
        }
        return this.scrollPane;
    }

    private JTextPane getPlaylistTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextPane(new HTMLDocument());
            this.textArea.setContentType("text/html");
            this.textArea.setName("textArea");
            this.textArea.setEditable(false);
            this.textArea.setCaret(new InvisiableCaret());
            this.textArea.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isConsumed() || PlayListGUI.this.playList == null) {
                        return;
                    }
                    if (e.isControlDown()) {
                        switch (e.getKeyCode()) {
                            case 83: {
                                PlayListGUI.this.doSavePlayList();
                                e.consume();
                                break;
                            }
                            case 69: {
                                PlayListGUI.this.doEditSelectedEntry();
                                e.consume();
                                break;
                            }
                            case 85: {
                                PlayListGUI.this.doUpdateSelectedEntryFromList();
                                e.consume();
                                break;
                            }
                            case 82: {
                                PlayListGUI.this.doShufflePlayList();
                                e.consume();
                                break;
                            }
                            case 65: {
                                PlayListGUI.this.doSelectAll();
                                e.consume();
                                break;
                            }
                            case 67: {
                                PlayListGUI.this.doCopyFilesInOrder();
                                e.consume();
                                break;
                            }
                            case 127: {
                                PlayListGUI.this.doCropSelectedEntryFromList();
                                e.consume();
                            }
                        }
                    } else if (e.isShiftDown()) {
                        switch (e.getKeyCode()) {
                            case 38: {
                                PlayListGUI.this.doChangeSelectionInList(-1);
                                e.consume();
                                break;
                            }
                            case 40: {
                                PlayListGUI.this.doChangeSelectionInList(1);
                                e.consume();
                            }
                        }
                    } else if (e.isAltDown()) {
                        switch (e.getKeyCode()) {
                            case 38: {
                                PlayListGUI.this.doMoveSelectedEntriesInList(-1);
                                e.consume();
                                break;
                            }
                            case 40: {
                                PlayListGUI.this.doMoveSelectedEntriesInList(1);
                                e.consume();
                            }
                        }
                    } else if (!e.isAltGraphDown() && !e.isMetaDown()) {
                        switch (e.getKeyCode()) {
                            case 127: {
                                PlayListGUI.this.doDeleteSelectedEntryFromList();
                                e.consume();
                                break;
                            }
                            case 27: {
                                PlayListGUI.this.playList.setSelectedElement(-1);
                                e.consume();
                                break;
                            }
                            case 36: {
                                PlayListGUI.this.playList.setSelectedElement(0);
                                PlayListGUI.this.doMakeIndexVisible(0);
                                e.consume();
                                break;
                            }
                            case 35: {
                                int ende = PlayListGUI.this.playList.size() - 1;
                                PlayListGUI.this.playList.setSelectedElement(ende);
                                PlayListGUI.this.doMakeIndexVisible(ende);
                                e.consume();
                                break;
                            }
                            case 38: {
                                PlayListGUI.this.doMoveSelectionInList(-1);
                                e.consume();
                                break;
                            }
                            case 40: {
                                PlayListGUI.this.doMoveSelectionInList(1);
                                e.consume();
                                break;
                            }
                            case 33: {
                                PlayListGUI.this.doMoveSelectionInList(-(PlayListGUI.this.getMaxVisableRows() - 1));
                                e.consume();
                                break;
                            }
                            case 34: {
                                PlayListGUI.this.doMoveSelectionInList(PlayListGUI.this.getMaxVisableRows() - 1);
                                e.consume();
                                break;
                            }
                            case 10: {
                                PlayListGUI.this.doPlaySelectedPiece();
                                e.consume();
                            }
                        }
                    }
                }
            });
            this.textArea.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (e.isConsumed() || PlayListGUI.this.playList == null) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        int index = PlayListGUI.this.getSelectedIndexFromPoint(e.getPoint(), false);
                        if (index == -1) {
                            return;
                        }
                        PlayListEntry entry = PlayListGUI.this.playList.getEntry(index);
                        if (entry.isSelected() && PlayListGUI.this.lastClickedEntry == null) {
                            PlayListGUI.this.lastClickedEntry = entry;
                        } else if (PlayListGUI.this.lastClickedEntry != null) {
                            int moveBy = index - PlayListGUI.this.lastClickedEntry.getIndexInPlaylist();
                            if (moveBy == 0) {
                                return;
                            }
                            PlayListGUI.this.doMoveSelectedEntriesInList(moveBy);
                        }
                        e.consume();
                    }
                }
            });
            this.textArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isConsumed() || PlayListGUI.this.playList == null) {
                        return;
                    }
                    PlayListGUI.this.lastClickedEntry = null;
                    int index = PlayListGUI.this.getSelectedIndexFromPoint(e.getPoint(), false);
                    if (index != -1) {
                        PlayListEntry entry = PlayListGUI.this.playList.getEntry(index);
                        if (e.isShiftDown()) {
                            PlayListEntry[] alreadySelectedEntries = PlayListGUI.this.playList.getSelectedEntries();
                            if (alreadySelectedEntries == null) {
                                PlayListGUI.this.playList.setSelectedElement(index);
                            } else {
                                int fromIndex = alreadySelectedEntries[0].getIndexInPlaylist();
                                PlayListGUI.this.playList.setSelectedElements(fromIndex, index);
                            }
                            PlayListGUI.this.lastClickedEntry = entry;
                        } else if (e.isControlDown()) {
                            PlayListGUI.this.playList.toggleSelectedElement(index);
                            PlayListGUI.this.lastClickedEntry = entry;
                        } else if (!entry.isSelected()) {
                            PlayListGUI.this.playList.setSelectedElement(index);
                            PlayListGUI.this.lastClickedEntry = entry;
                        }
                    } else {
                        PlayListGUI.this.playList.setSelectedElement(index);
                    }
                    if (SwingUtilities.isRightMouseButton(e)) {
                        PlayListGUI.this.getPopup().show(PlayListGUI.this.textArea, e.getX(), e.getY());
                    }
                    e.consume();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isConsumed() || PlayListGUI.this.playList == null) {
                        return;
                    }
                    int index = PlayListGUI.this.getSelectedIndexFromPoint(e.getPoint(), false);
                    if (index != -1 && SwingUtilities.isLeftMouseButton(e)) {
                        PlayListEntry entry = PlayListGUI.this.playList.getEntry(index);
                        if (e.getClickCount() > 1) {
                            PlayListGUI.this.doPlaySelectedPiece();
                        } else if (entry != null && PlayListGUI.this.lastClickedEntry == null) {
                            PlayListGUI.this.playList.setSelectedElement(index);
                        }
                        e.consume();
                    }
                }
            });
        }
        return this.textArea;
    }

    private JPopupMenu getPopup() {
        if (this.playListPopUp == null) {
            this.playListPopUp = new JPopupMenu();
            this.playListPopUp.setName("playListPopUp");
            this.playListPopUp.add(this.getPopUpEntryDeleteFromList());
            this.playListPopUp.add(this.getPopUpEntryCropFromList());
            this.playListPopUp.add(new JSeparator());
            this.playListPopUp.add(this.getPopUpEntryRefreshEntry());
            this.playListPopUp.add(this.getPopUpEntryEditEntry());
            this.playListPopUp.add(this.getPopUpEntryShuffleList());
            this.playListPopUp.add(new JSeparator());
            this.playListPopUp.add(this.getPopUpEntrySaveList());
            this.playListPopUp.add(this.getPopUpEntryCopyFilesInOrder());
        }
        boolean noEmptyList = this.playList != null && this.playList.size() > 0;
        PlayListEntry[] selectedEntries = noEmptyList ? this.playList.getSelectedEntries() : null;
        boolean elementSpecificEntriesEnabled = noEmptyList && selectedEntries != null;
        this.getPopUpEntryDeleteFromList().setEnabled(elementSpecificEntriesEnabled);
        this.getPopUpEntryRefreshEntry().setEnabled(elementSpecificEntriesEnabled);
        this.getPopUpEntryEditEntry().setEnabled(elementSpecificEntriesEnabled && selectedEntries != null && selectedEntries.length == 1);
        this.getPopUpEntrySaveList().setEnabled(noEmptyList);
        this.getPopUpEntryShuffleList().setEnabled(noEmptyList);
        this.getPopUpEntryCopyFilesInOrder().setEnabled(noEmptyList);
        return this.playListPopUp;
    }

    private JMenuItem getPopUpEntryDeleteFromList() {
        if (this.popUpEntryDeleteFromList == null) {
            this.popUpEntryDeleteFromList = new JMenuItem();
            this.popUpEntryDeleteFromList.setName("JPopUpMenu_DeleteFromList");
            this.popUpEntryDeleteFromList.setText("<del> delete entry from list");
            this.popUpEntryDeleteFromList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayListGUI.this.doDeleteSelectedEntryFromList();
                }
            });
        }
        return this.popUpEntryDeleteFromList;
    }

    private JMenuItem getPopUpEntryCropFromList() {
        if (this.popUpEntryCropFromList == null) {
            this.popUpEntryCropFromList = new JMenuItem();
            this.popUpEntryCropFromList.setName("JPopUpMenu_CropFromList");
            this.popUpEntryCropFromList.setText("<ctrl-del> crop entry from list");
            this.popUpEntryCropFromList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayListGUI.this.doCropSelectedEntryFromList();
                }
            });
        }
        return this.popUpEntryCropFromList;
    }

    private JMenuItem getPopUpEntryRefreshEntry() {
        if (this.popUpEntryRefreshEntry == null) {
            this.popUpEntryRefreshEntry = new JMenuItem();
            this.popUpEntryRefreshEntry.setName("JPopUpMenu_RefreshEntry");
            this.popUpEntryRefreshEntry.setText("<ctrl-u> Refresh entry");
            this.popUpEntryRefreshEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayListGUI.this.doUpdateSelectedEntryFromList();
                }
            });
        }
        return this.popUpEntryRefreshEntry;
    }

    private JMenuItem getPopUpEntryEditEntry() {
        if (this.popUpEntryEditEntry == null) {
            this.popUpEntryEditEntry = new JMenuItem();
            this.popUpEntryEditEntry.setName("JPopUpMenu_EditEntry");
            this.popUpEntryEditEntry.setText("<ctrl-e> Edit entry");
            this.popUpEntryEditEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayListGUI.this.doEditSelectedEntry();
                }
            });
        }
        return this.popUpEntryEditEntry;
    }

    private JMenuItem getPopUpEntrySaveList() {
        if (this.popUpEntrySaveList == null) {
            this.popUpEntrySaveList = new JMenuItem();
            this.popUpEntrySaveList.setName("JPopUpMenu_SaveList");
            this.popUpEntrySaveList.setText("<ctrl-s> save playlist to");
            this.popUpEntrySaveList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayListGUI.this.doSavePlayList();
                }
            });
        }
        return this.popUpEntrySaveList;
    }

    private JMenuItem getPopUpEntryShuffleList() {
        if (this.popUpEntryShuffleList == null) {
            this.popUpEntryShuffleList = new JMenuItem();
            this.popUpEntryShuffleList.setName("JPopUpMenu_ShuffleList");
            this.popUpEntryShuffleList.setText("<ctrl-r> shuffle list");
            this.popUpEntryShuffleList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayListGUI.this.doShufflePlayList();
                }
            });
        }
        return this.popUpEntryShuffleList;
    }

    private JMenuItem getPopUpEntryCopyFilesInOrder() {
        if (this.popUpEntryCopyFilesInOrder == null) {
            this.popUpEntryCopyFilesInOrder = new JMenuItem();
            this.popUpEntryCopyFilesInOrder.setName("JPopUpMenu_CopyFiles");
            this.popUpEntryCopyFilesInOrder.setText("<ctrl-c> copy files in list order");
            this.popUpEntryCopyFilesInOrder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayListGUI.this.doCopyFilesInOrder();
                }
            });
        }
        return this.popUpEntryCopyFilesInOrder;
    }

    private SimpleProgessDialog getDownloadDialog() {
        if (this.downloadDialog == null) {
            this.downloadDialog = new SimpleProgessDialog((Dialog)this.parentFrame, "copy progress");
            this.downloadDialog.setSize(350, 90);
            this.downloadDialog.setPreferredSize(this.downloadDialog.getSize());
            this.downloadDialog.pack();
        }
        return this.downloadDialog;
    }

    private EditPlaylistEntry getEditDialog() {
        if (this.editPlayListEntryDialog == null) {
            this.editPlayListEntryDialog = new EditPlaylistEntry(this.parentFrame, true);
            this.editPlayListEntryDialog.setSize(650, 150);
            this.editPlayListEntryDialog.setPreferredSize(this.editPlayListEntryDialog.getSize());
            this.editPlayListEntryDialog.pack();
            this.editPlayListEntryDialog.setLocation(Helpers.getFrameCenteredLocation(this.editPlayListEntryDialog, this.parentFrame));
        }
        return this.editPlayListEntryDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeleteSelectedEntryFromList() {
        int lastIndex;
        PlayListEntry[] selectedEntries = this.playList.getSelectedEntries();
        if (selectedEntries != null && (lastIndex = selectedEntries.length - 1) >= 0) {
            int markAfterDeletion = selectedEntries[0].getIndexInPlaylist();
            this.playlistUpdateThread.halt();
            try {
                for (int i = 0; i <= lastIndex; ++i) {
                    this.playList.remove(selectedEntries[i].getIndexInPlaylist());
                }
                this.createList(this.getFirstVisableIndex());
                this.firePlaylistChanged();
                this.playList.setSelectedElement(markAfterDeletion < 0 ? 0 : markAfterDeletion);
                this.doMakeIndexVisible(markAfterDeletion);
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCropSelectedEntryFromList() {
        PlayListEntry[] allEntries = this.playList.getAllEntries();
        if (allEntries != null) {
            this.playlistUpdateThread.halt();
            try {
                for (int i = 0; i < allEntries.length; ++i) {
                    if (allEntries[i].isSelected()) continue;
                    this.playList.remove(allEntries[i].getIndexInPlaylist());
                }
                this.createList(this.getFirstVisableIndex());
                this.firePlaylistChanged();
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateSelectedEntryFromList() {
        PlayListEntry[] selectedEntries = this.playList.getSelectedEntries();
        if (selectedEntries != null) {
            this.playlistUpdateThread.halt();
            try {
                for (int i = 0; i < selectedEntries.length; ++i) {
                    selectedEntries[i].setSongName(null);
                    selectedEntries[i].setDuration(null);
                    this.updateLine(selectedEntries[i].getIndexInPlaylist());
                }
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEditSelectedEntry() {
        block7: {
            PlayListEntry[] selectedEntries = this.playList.getSelectedEntries();
            if (selectedEntries != null) {
                this.playlistUpdateThread.halt();
                try {
                    PlayListEntry entry = selectedEntries[0];
                    EditPlaylistEntry editor = this.getEditDialog();
                    editor.setValue(Helpers.createLocalFileStringFromURL(entry.getFile(), false));
                    editor.setVisible(true);
                    String newValue = editor.getValue();
                    if (newValue == null) break block7;
                    try {
                        URL url = Helpers.createURLfromString(newValue);
                        if (url != null) {
                            entry.setFile(url);
                            entry.setSongName(null);
                            entry.setDuration(null);
                            this.updateLine(entry.getIndexInPlaylist());
                        }
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(this, "Changing entry failed", "Failed", 0);
                    }
                }
                finally {
                    this.playlistUpdateThread.restart();
                }
            }
        }
    }

    private void doSavePlayList() {
        if (this.playList != null) {
            File f;
            String suggestedPath;
            FileChooserResult selectedFile;
            while ((selectedFile = Helpers.selectFileNameFor(this, suggestedPath = Helpers.createLocalFileStringFromURL(this.playList.getLoadedFromURL(), true), "Save playlist to", new FileFilter[]{PlayList.PLAYLIST_FILE_FILTER}, 1, false, false)) != null && (f = selectedFile.getSelectedFile()) != null) {
                String filename = f.getAbsolutePath();
                String fileNameLow = filename.toLowerCase();
                if (!(fileNameLow.endsWith("pls") || fileNameLow.endsWith("m3u8") || fileNameLow.endsWith("m3u") || fileNameLow.endsWith("cue"))) {
                    f = new File(filename + ".M3U");
                }
                if (f.exists()) {
                    int result = JOptionPane.showConfirmDialog(this, "File already exists! Overwrite?", "Overwrite confirmation", 1, 3);
                    if (result == 2) {
                        return;
                    }
                    if (result == 1) continue;
                    boolean ok = f.delete();
                    if (!ok) {
                        JOptionPane.showMessageDialog(this, "Overwrite failed. Is file write protected or in use?", "Failed", 0);
                        return;
                    }
                }
                try {
                    this.playList.savePlayListTo(f);
                    break;
                }
                catch (Exception ex) {
                    Log.error("Save playlist", ex);
                    break;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShufflePlayList() {
        if (this.playList != null) {
            this.playlistUpdateThread.halt();
            try {
                this.playList.doShuffle();
                this.createList(this.getFirstVisableIndex());
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    private void doCopyFilesInOrder() {
        if (this.playList != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    File destinationDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle("Select download destination");
                    chooser.setFileSelectionMode(1);
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.setApproveButtonText("Save here");
                    if (chooser.showOpenDialog(PlayListGUI.this) == 0 && (destinationDir = chooser.getSelectedFile()).isDirectory() && destinationDir.canWrite()) {
                        int c = (int)Math.log10(PlayListGUI.this.playList.size()) + 1;
                        PlayListGUI.this.getDownloadDialog().setLocation(Helpers.getFrameCenteredLocation(PlayListGUI.this.getDownloadDialog(), PlayListGUI.this.parentFrame));
                        PlayListGUI.this.getDownloadDialog().setVisible(true);
                        for (int i = 0; i < PlayListGUI.this.playList.size(); ++i) {
                            PlayListEntry entry = PlayListGUI.this.playList.setCurrentElement(i);
                            String newFileName = String.format("%s%c%0" + c + "d - %s", destinationDir.getAbsolutePath(), Character.valueOf(File.separatorChar), i + 1, Helpers.getFileNameFromURL(entry.getFile()));
                            File destination = new File(newFileName.toString());
                            PlayListGUI.this.getDownloadDialog().setCurrentFileName(destination.getAbsolutePath());
                            PlayListGUI.this.getDownloadDialog().setValue(0);
                            if (destination.exists()) {
                                int owresult = JOptionPane.showConfirmDialog(PlayListGUI.this, destination + "\nalready exists! Overwrite?", "Overwrite confirmation", 1, 3);
                                if (owresult == 2) {
                                    PlayListGUI.this.getDownloadDialog().setVisible(false);
                                    return;
                                }
                                if (owresult == 1) continue;
                                boolean ok = destination.delete();
                                if (!ok && destination.exists()) {
                                    JOptionPane.showMessageDialog(PlayListGUI.this, "Overwrite failed. Is file write protected or in use?", "Failed", 0);
                                    continue;
                                }
                            }
                            Helpers.copyFromURL(entry.getFile(), destination, PlayListGUI.this.getDownloadDialog());
                        }
                        PlayListGUI.this.getDownloadDialog().setVisible(false);
                    }
                }
            }).start();
        }
    }

    private void doSelectAll() {
        this.playList.setSelectedElements(0, this.playList.size() - 1);
    }

    private void doChangeSelectionInList(int moveBy) {
        PlayListEntry[] selected = this.playList.getSelectedEntries();
        if (selected == null || selected.length == 0) {
            this.playList.setSelectedElement(0);
            this.doMakeIndexVisible(0);
        } else {
            int firstIndex = selected[0].getIndexInPlaylist();
            int lastIndex = selected[selected.length - 1].getIndexInPlaylist();
            if (moveBy < 0) {
                if ((firstIndex += moveBy) < 0) {
                    firstIndex = 0;
                }
            } else if ((lastIndex += moveBy) >= this.playList.size()) {
                lastIndex = this.playList.size() - 1;
            }
            this.playList.setSelectedElements(firstIndex, lastIndex);
            if (moveBy < 0) {
                this.doMakeIndexVisible(firstIndex);
            } else {
                this.doMakeIndexVisible(lastIndex);
            }
        }
    }

    private void doMoveSelectionInList(int moveBy) {
        PlayListEntry[] selected = this.playList.getSelectedEntries();
        if (selected == null || selected.length == 0) {
            this.playList.setSelectedElement(0);
            this.doMakeIndexVisible(0);
        } else {
            int index = selected[0].getIndexInPlaylist();
            if ((index += moveBy) < 0) {
                index = 0;
            } else if (index >= this.playList.size()) {
                index = this.playList.size() - 1;
            }
            this.playList.setSelectedElement(index);
            index = moveBy < 0 ? (index -= 2) : (index += 2);
            this.doMakeIndexVisible(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMoveSelectedEntriesInList(int moveBy) {
        PlayListEntry[] selected = this.playList.getSelectedEntries();
        if (selected != null) {
            this.playlistUpdateThread.halt();
            try {
                if (moveBy < 0) {
                    if (selected[0].getIndexInPlaylist() + moveBy < 0) {
                        moveBy = selected[0].getIndexInPlaylist();
                    }
                    if (moveBy == 0) {
                        return;
                    }
                    for (int i = 0; i < selected.length; ++i) {
                        int fromIndex = selected[i].getIndexInPlaylist();
                        this.playList.move(fromIndex, fromIndex + moveBy);
                    }
                } else {
                    int lastIndex = selected.length - 1;
                    if (selected[lastIndex].getIndexInPlaylist() + moveBy >= this.playList.size()) {
                        moveBy = this.playList.size() - 1 - selected[lastIndex].getIndexInPlaylist();
                    }
                    if (moveBy == 0) {
                        return;
                    }
                    for (int i = lastIndex; i >= 0; --i) {
                        int fromIndex = selected[i].getIndexInPlaylist();
                        this.playList.move(fromIndex, fromIndex + moveBy);
                    }
                }
                int showIndex = moveBy < 0 ? selected[0].getIndexInPlaylist() - 2 : selected[selected.length - 1].getIndexInPlaylist() + 2;
                this.createList(showIndex);
                this.firePlaylistChanged();
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    private void doPlaySelectedPiece() {
        PlayListEntry[] selected = this.playList.getSelectedEntries();
        if (selected != null) {
            int index = selected[0].getIndexInPlaylist();
            this.playList.setSelectedElement(index);
            this.playList.setCurrentElement(index);
            this.fireActiveElementChanged();
        }
    }

    private Element getDocumentRootElement() {
        Element e1;
        Element map;
        Document doc = this.getPlaylistTextArea().getDocument();
        if (doc != null && (map = doc.getDefaultRootElement()) != null && (e1 = map.getElement(1)) != null) {
            return e1.getElement(0);
        }
        return null;
    }

    private Element getDocumentElementForIndex(int index) {
        Element element;
        if (index > -1 && (element = this.getDocumentRootElement()) != null) {
            return element.getElement(index);
        }
        return null;
    }

    private int getMaxVisableRows() {
        Rectangle size = this.getScrollPane().getVisibleRect();
        Point p = new Point(0, (int)size.getHeight());
        return this.getSelectedIndexFromPoint(p, true) - 1;
    }

    private int getFirstVisableIndex() {
        Element table = this.getDocumentRootElement();
        if (table != null) {
            for (int i = 0; i < table.getElementCount(); ++i) {
                Element element = table.getElement(i);
                try {
                    Rectangle r1 = this.getPlaylistTextArea().modelToView(element.getStartOffset());
                    Rectangle r2 = this.getPlaylistTextArea().modelToView(element.getEndOffset() - 1);
                    Rectangle r = new Rectangle((int)r1.getX(), (int)r1.getY(), (int)(r2.getX() - r1.getX()), (int)r1.getHeight());
                    Rectangle intersect = r.intersection(this.getPlaylistTextArea().getVisibleRect());
                    if (!intersect.isEmpty() && intersect.height == r.height) {
                        return i;
                    }
                    continue;
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    private int getSelectedIndexFromPoint(Point position, boolean returnNearest) {
        int modelPos = this.getPlaylistTextArea().viewToModel(position);
        Element table = this.getDocumentRootElement();
        if (table != null) {
            int index = table.getElementIndex(modelPos);
            Element selectedElement = table.getElement(index);
            try {
                Rectangle r1 = this.getPlaylistTextArea().modelToView(selectedElement.getStartOffset());
                Rectangle r2 = this.getPlaylistTextArea().modelToView(selectedElement.getEndOffset() - 1);
                Rectangle r = new Rectangle((int)r1.getX(), (int)r1.getY(), (int)(r2.getX() - r1.getX()), (int)r1.getHeight());
                if (!returnNearest && !r.contains(position)) {
                    return -1;
                }
                if (returnNearest) {
                    if (position.getY() < r1.getY()) {
                        --index;
                    } else if (position.getY() > r1.getY() + r1.getHeight()) {
                        ++index;
                    }
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            return index;
        }
        return -1;
    }

    private void doMakeIndexVisible(PlayListEntry entry) {
        block6: {
            if (entry != null) {
                try {
                    Element element = this.getDocumentElementForIndex(entry.getIndexInPlaylist());
                    if (element == null) break block6;
                    try {
                        Rectangle r1 = this.getPlaylistTextArea().modelToView(element.getStartOffset());
                        Rectangle r2 = this.getPlaylistTextArea().modelToView(element.getEndOffset() - 1);
                        if (r1 != null && r2 != null) {
                            Rectangle r = new Rectangle((int)r1.getX(), (int)r1.getY(), (int)(r2.getX() - r1.getX()), (int)r1.getHeight());
                            this.getPlaylistTextArea().scrollRectToVisible(r);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                catch (Throwable ex) {
                    Log.error("PlayListGui::doMakeIndexVisible", ex);
                }
            }
        }
    }

    private void doMakeIndexVisible(int index) {
        if (this.playList != null) {
            if (index < 0) {
                index = 0;
            } else if (index >= this.playList.size()) {
                index = this.playList.size() - 1;
            }
            this.doMakeIndexVisible(this.playList.getEntry(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playlistRecieved(DropTargetDropEvent dtde, PlayList dropResult, URL addToLastLoaded) {
        if (this.playList == null) {
            this.setNewPlaylist(dropResult);
            this.firePlaylistChanged();
        } else {
            this.playlistUpdateThread.halt();
            try {
                int index = 0;
                Point dropCoordinates = dtde.getLocation();
                DropTargetContext targetContext = dtde.getDropTargetContext();
                Component targetComponent = targetContext.getComponent();
                if (!targetComponent.equals(this.getPlaylistTextArea())) {
                    int middle = targetComponent.getHeight() >> 1;
                    index = dropCoordinates.getY() < (double)middle ? 0 : this.playList.size();
                } else {
                    index = this.getSelectedIndexFromPoint(dropCoordinates, true);
                    if (index == -1) {
                        index = 0;
                    } else if (index > this.playList.size()) {
                        index = this.playList.size();
                    }
                }
                this.playList.addAllAt(index, dropResult);
                this.createList(this.getFirstVisableIndex());
                this.firePlaylistChanged();
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    public synchronized void addPlaylistGUIChangeListener(PlaylistGUIChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removePlaylistGUIChangeListener(PlaylistGUIChangeListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireActiveElementChanged() {
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.get(i).userSelectedPlaylistEntry();
        }
    }

    private synchronized void firePlaylistChanged() {
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.get(i).playListChanged(this.playList);
        }
    }

    private String getHTMLString(PlayListEntry entry, String text, String duration) {
        StringBuilder html = new StringBuilder("<TR style=\"").append("background:#").append(entry.isSelected() ? this.markColorBackground : this.unmarkColorBackground).append("; ").append("color:#").append(entry.isSelected() ? this.markColorForeground : this.unmarkColorForeground).append("; ").append("font-family:").append(Helpers.getTextAreaFont().getFamily()).append("; ").append("font-size:").append(Helpers.getTextAreaFont().getSize()).append(';').append("font-weight:").append(entry.isActive() ? "bold" : "normal").append(';').append("\"><TD align=\"left\" nowrap>").append(text.replace(" ", "&nbsp;")).append("</TD><TD align=\"right\" nowrap>").append(duration.replace(" ", "&nbsp;")).append("</TD></TR>");
        return html.toString();
    }

    private void createList(final int makeThisIndexVisable) {
        if (this.playList != null) {
            final StringBuilder fullText = new StringBuilder("<HTML><HEAD><TITLE>PlayList</TITLE></HEAD><BODY><TABLE WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\">");
            Iterator<PlayListEntry> iter = this.playList.getIterator();
            int lineIndex = 0;
            int digits = (int)(Math.log10(this.playList.size()) + 1.0);
            String formatString = String.format("%%%dd. ", digits);
            while (iter.hasNext()) {
                PlayListEntry entry = iter.next();
                fullText.append(this.getHTMLString(entry, String.format(formatString, lineIndex + 1) + entry.getQuickSongName(), entry.getQuickDuration()));
                ++lineIndex;
            }
            fullText.append("</TABLE></FONT></BODY></HTML>");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlayListGUI.this.getPlaylistTextArea().setText(fullText.toString());
                    PlayListGUI.this.getPlaylistTextArea().select(0, 0);
                    PlayListGUI.this.doMakeIndexVisible(makeThisIndexVisable < 0 ? 0 : makeThisIndexVisable);
                }
            });
            this.getRepeatCheckBox().setSelected(this.playList.isRepeat());
        } else {
            this.getRepeatCheckBox().setSelected(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewPlaylist(PlayList playList) {
        this.playlistUpdateThread.halt();
        try {
            this.playList = playList;
            this.playList.addPlaylistChangedListener(this);
            this.createList(0);
        }
        finally {
            this.playlistUpdateThread.restart();
        }
    }

    private void replaceLine(String newName, String time, int lineIndex) {
        try {
            Element element = this.getDocumentElementForIndex(lineIndex);
            if (element != null) {
                Element TextElement = element.getElement(0).getElement(0).getElement(0);
                Element TimeElement = element.getElement(1).getElement(0).getElement(0);
                this.getPlaylistTextArea().getDocument().remove(TextElement.getStartOffset(), TextElement.getEndOffset() - TextElement.getStartOffset());
                this.getPlaylistTextArea().getDocument().insertString(TextElement.getStartOffset(), newName, TextElement.getAttributes());
                this.getPlaylistTextArea().getDocument().remove(TimeElement.getStartOffset(), TimeElement.getEndOffset() - TimeElement.getStartOffset());
                this.getPlaylistTextArea().getDocument().insertString(TimeElement.getStartOffset(), time, TimeElement.getAttributes());
            }
        }
        catch (BadLocationException ex) {
            Log.error("PlayListGUI::replaceLine", ex);
        }
    }

    private void updateLine(int index) {
        int digits = (int)Math.log10(this.playList.size()) + 1;
        String formatString = String.format("%%%dd. %%s", digits);
        PlayListEntry entry = this.playList.getEntry(index);
        String name = MultimediaContainerManager.getSongNameFromURL(entry.getFile());
        String duration = "0:00";
        try {
            name = entry.getFormattedName();
            duration = entry.getDurationString();
        }
        catch (RuntimeException ex) {
            name = name + " [" + ex.getMessage() + "]";
        }
        String songLine = String.format(formatString, index + 1, name);
        this.replaceLine(songLine, duration, index);
    }

    private static String getText(Element element) throws BadLocationException {
        String text = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        if (text.endsWith("\n")) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    private void setTextDecorationAndColorsFor(PlayListEntry entry) {
        try {
            Element element = this.getDocumentElementForIndex(entry.getIndexInPlaylist());
            if (element != null) {
                String text = PlayListGUI.getText(element.getElement(0).getElement(0).getElement(0));
                String duration = PlayListGUI.getText(element.getElement(1).getElement(0).getElement(0));
                HTMLDocument doc = (HTMLDocument)element.getDocument();
                doc.setOuterHTML(element, this.getHTMLString(entry, text, duration));
            }
        }
        catch (Throwable ex) {
            Log.error("PlayListGui::setTextDecorationAndColorsFor", ex);
        }
    }

    @Override
    public void activeElementChanged(final PlayListEntry oldActiveElement, final PlayListEntry newActiveElement) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (oldActiveElement != null) {
                    PlayListGUI.this.setTextDecorationAndColorsFor(oldActiveElement);
                }
                if (newActiveElement != null) {
                    PlayListGUI.this.setTextDecorationAndColorsFor(newActiveElement);
                    PlayListGUI.this.doMakeIndexVisible(newActiveElement);
                }
            }
        });
    }

    @Override
    public void selectedElementChanged(final PlayListEntry oldSelectedElement, final PlayListEntry newSelectedElement) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (oldSelectedElement != null) {
                    PlayListGUI.this.setTextDecorationAndColorsFor(oldSelectedElement);
                }
                if (newSelectedElement != null) {
                    PlayListGUI.this.setTextDecorationAndColorsFor(newSelectedElement);
                    PlayListGUI.this.doMakeIndexVisible(newSelectedElement);
                }
            }
        });
    }

    private static final class PlayListUpdateThread
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = -8105723830268691249L;
        private PlayListGUI parent;
        private volatile boolean stopIt;
        private volatile boolean isStopped;
        private volatile boolean finished;

        public PlayListUpdateThread(PlayListGUI parent) {
            this.setName("PlayListUpdateThread::" + this.getClass().getName());
            this.setDaemon(true);
            this.setPriority(1);
            this.parent = parent;
            this.isStopped = true;
            this.stopIt = false;
            this.finished = false;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public void halt() {
            if (!this.isStopped) {
                this.stopIt = true;
                this.interrupt();
                while (!this.isStopped()) {
                    try {
                        PlayListUpdateThread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.stopIt = false;
            }
        }

        public void restart() {
            this.stopIt = false;
            this.isStopped = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.finished) {
                while (this.isStopped() && !this.finished) {
                    try {
                        PlayListUpdateThread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {}
                }
                try {
                    if (this.parent.playList == null) continue;
                    int size = this.parent.playList.size();
                    for (int index = 0; index < size && !this.stopIt; ++index) {
                        this.parent.updateLine(index);
                        try {
                            PlayListUpdateThread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    this.stopIt = false;
                    this.isStopped = true;
                }
            }
        }
    }

    private static final class InvisiableCaret
    implements Caret {
        private Point magicCaretPosition;
        private int dot;
        private int rate;

        @Override
        public void setVisible(boolean v) {
        }

        @Override
        public void setSelectionVisible(boolean v) {
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public boolean isSelectionVisible() {
            return false;
        }

        @Override
        public void setMagicCaretPosition(Point p) {
            this.magicCaretPosition = p;
        }

        @Override
        public Point getMagicCaretPosition() {
            return this.magicCaretPosition;
        }

        @Override
        public void setDot(int dot) {
            this.dot = dot;
        }

        @Override
        public int getDot() {
            return this.dot;
        }

        @Override
        public void setBlinkRate(int rate) {
            this.rate = rate;
        }

        @Override
        public int getBlinkRate() {
            return this.rate;
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void moveDot(int dot) {
        }

        @Override
        public void install(JTextComponent c) {
        }

        @Override
        public void deinstall(JTextComponent c) {
        }

        @Override
        public int getMark() {
            return this.dot;
        }
    }
}

