/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.tools;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    private ArrayList<String> extensions = new ArrayList();
    private String description;

    public FileChooserFilter() {
    }

    public FileChooserFilter(String extension, String description) {
        this();
        this.extensions.add(extension.toLowerCase());
        this.description = description == null ? extension + " files" : description;
    }

    public FileChooserFilter(String extension) {
        this(extension, null);
    }

    public FileChooserFilter(String[] extensions, String description) {
        this();
        this.description = description != null ? description : "";
        for (int i = 0; i < extensions.length; ++i) {
            String suffix = extensions[i].toLowerCase();
            if (description == null) {
                this.description = this.description + "*." + suffix + " ";
            }
            this.extensions.add(extensions[i].toLowerCase());
        }
    }

    public FileChooserFilter(String[] extensions) {
        this(extensions, null);
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        int len = this.extensions.size();
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            String suffix = this.extensions.get(i);
            if (suffix.equals("*")) {
                return true;
            }
            if (f.getName().toLowerCase().endsWith('.' + suffix)) {
                return true;
            }
            if (!f.getName().toLowerCase().startsWith(suffix + '.')) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

