/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.tools;

import de.quippy.javamod.main.gui.tools.PlaylistDropListenerCallBack;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Log;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PlaylistDropListener
extends DropTargetAdapter {
    private PlaylistDropListenerCallBack callBack;

    public PlaylistDropListener(PlaylistDropListenerCallBack callBack) {
        this.callBack = callBack;
    }

    private void fillWithPlayableFiles(ArrayList<URL> urls, File startDir) {
        String[] files = startDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File fullFileName = new File(dir.getAbsolutePath() + File.separatorChar + name);
                if (fullFileName.isDirectory()) {
                    return true;
                }
                try {
                    return MultimediaContainerManager.getMultimediaContainerSingleton(fullFileName.toURI().toURL()) != null;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File fullFileName = new File(startDir.getAbsolutePath() + File.separatorChar + files[i]);
            if (fullFileName.isDirectory()) {
                this.fillWithPlayableFiles(urls, fullFileName);
                continue;
            }
            try {
                urls.add(fullFileName.toURI().toURL());
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            URL addToLastLoaded = null;
            Transferable t = dtde.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                if (userObject instanceof List) {
                    List files = (List)userObject;
                    ArrayList<URL> urls = new ArrayList<URL>(files.size());
                    for (int i = 0; i < files.size(); ++i) {
                        String fileName = files.get(i).toString();
                        File f = new File(fileName);
                        if (f.isDirectory()) {
                            this.fillWithPlayableFiles(urls, f);
                            continue;
                        }
                        URL url = f.toURI().toURL();
                        if (files.size() == 1) {
                            addToLastLoaded = url;
                        }
                        urls.add(url);
                    }
                    PlayList playList = PlayList.createNewListWithFiles(urls.toArray(new URL[urls.size()]), false, false);
                    this.callBack.playlistRecieved(dtde, playList, addToLastLoaded);
                }
            }
        }
        catch (Exception ex) {
            Log.error("[MainForm::DropListener]", ex);
        }
        finally {
            dtde.dropComplete(true);
        }
    }
}

