/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.playlist;

import de.quippy.javamod.main.gui.tools.FileChooserFilter;
import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.main.playlist.PlaylistChangedListener;
import de.quippy.javamod.main.playlist.cuesheet.CueFile;
import de.quippy.javamod.main.playlist.cuesheet.CueIndex;
import de.quippy.javamod.main.playlist.cuesheet.CueSheet;
import de.quippy.javamod.main.playlist.cuesheet.CueTrack;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PlayList {
    public static String[] SUPPORTEDPLAYLISTS = new String[]{"pls", "m3u", "m3u8", "cue", "zip"};
    public static FileChooserFilter PLAYLIST_FILE_FILTER = new FileChooserFilter(SUPPORTEDPLAYLISTS, PlayList.getFileChooserDescription());
    public static String[] SUPPORTEDSAVELISTS = new String[]{"pls", "m3u", "m3u8"};
    public static FileChooserFilter PLAYLIST_SAVE_FILE_FILTER = new FileChooserFilter(SUPPORTEDSAVELISTS, PlayList.getFileChooserDescription());
    private static String INDEX_STRING = "  index ";
    private URL loadedFromURL;
    private ArrayList<PlayListEntry> entries;
    private int current;
    private boolean repeat;
    private ArrayList<PlaylistChangedListener> listeners = new ArrayList();

    public PlayList(boolean shuffle, boolean repeat) {
        this.entries = new ArrayList();
        this.current = -1;
        this.repeat = repeat;
        if (shuffle) {
            this.doShuffle();
        }
    }

    public PlayList(ArrayList<PlayListEntry> entries, boolean shuffle, boolean repeat) {
        this.entries = entries;
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).setSavedInPlaylist(this);
        }
        this.current = -1;
        this.repeat = repeat;
        if (shuffle) {
            this.doShuffle();
        }
    }

    public PlayList(File[] files, boolean shuffle, boolean repeat) {
        this(PlayList.generateURLListFromFiles(files), shuffle, repeat);
    }

    public PlayList(String[] fileNames, boolean shuffle, boolean repeat) {
        this(PlayList.generateURLListFromFileNames(fileNames), shuffle, repeat);
    }

    public PlayList(URL[] urls, boolean shuffle, boolean repeat) {
        this.entries = new ArrayList(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            if (PlayList.isPlaylistFile(url)) {
                try {
                    PlayList newPlayList = PlayList.createFromFile(url, false, false);
                    if (this.getLoadedFromURL() == null) {
                        this.setLoadedFromURL(url);
                    }
                    Iterator<PlayListEntry> elementIter = newPlayList.getIterator();
                    while (elementIter.hasNext()) {
                        PlayListEntry entry = elementIter.next();
                        entry.setSavedInPlaylist(this);
                        this.entries.add(entry);
                    }
                    continue;
                }
                catch (IOException ex) {
                    Log.error("PlayList", ex);
                    continue;
                }
            }
            this.entries.add(new PlayListEntry(urls[i], this));
        }
        this.current = -1;
        this.repeat = repeat;
        if (shuffle) {
            this.doShuffle();
        }
    }

    public synchronized void addPlaylistChangedListener(PlaylistChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removePlaylistChangedListener(PlaylistChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void fireActiveElementChanged(PlayListEntry oldElement, PlayListEntry newEntry) {
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.get(i).activeElementChanged(oldElement, newEntry);
        }
    }

    public synchronized void fireSelectedElementChanged(PlayListEntry oldElement, PlayListEntry newEntry) {
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.get(i).selectedElementChanged(oldElement, newEntry);
        }
    }

    public synchronized boolean isRepeat() {
        return this.repeat;
    }

    public synchronized void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public synchronized void doShuffle() {
        Random rnd = new Random(System.currentTimeMillis());
        ArrayList<PlayListEntry> newEntries = new ArrayList<PlayListEntry>(this.size());
        while (!this.entries.isEmpty()) {
            newEntries.add(this.entries.remove(rnd.nextInt(this.entries.size())));
        }
        this.entries = newEntries;
        this.current = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            PlayListEntry entry = this.entries.get(i);
            if (!entry.isActive()) continue;
            if (this.current == -1) {
                this.current = i;
                continue;
            }
            entry.setActive(false);
        }
    }

    private synchronized ArrayList<PlayListEntry> getEntries() {
        return this.entries;
    }

    public synchronized PlayListEntry[] getAllEntries() {
        return this.entries.toArray(new PlayListEntry[this.entries.size()]);
    }

    public synchronized PlayListEntry getCurrentEntry() {
        if (this.current >= 0 && this.current < this.size()) {
            return this.entries.get(this.current);
        }
        return null;
    }

    public synchronized PlayListEntry getEntry(int index) {
        if (index >= 0 && index < this.size()) {
            return this.entries.get(index);
        }
        return null;
    }

    private synchronized void activateCurrentEntry() {
        PlayListEntry current = this.getCurrentEntry();
        if (current != null) {
            current.setActive(true);
        }
    }

    private synchronized void deactivateCurrentEntry() {
        PlayListEntry current = this.getCurrentEntry();
        if (current != null) {
            current.setActive(false);
        }
    }

    public synchronized PlayListEntry setCurrentElement(int index) {
        if (index >= 0 && index < this.size() && index != this.current) {
            PlayListEntry oldEntry = this.getCurrentEntry();
            this.deactivateCurrentEntry();
            this.current = index;
            this.activateCurrentEntry();
            PlayListEntry newEntry = this.getCurrentEntry();
            this.fireActiveElementChanged(oldEntry, newEntry);
            return newEntry;
        }
        return this.getCurrentEntry();
    }

    public synchronized void setCurrentElementByTimeIndex(long timeIndex) {
        if (this.current == -1 || this.entries == null) {
            return;
        }
        int currentIndex = this.current;
        int end = this.entries.size() - 1;
        if (currentIndex > end) {
            currentIndex = end;
        } else if (currentIndex < 0) {
            currentIndex = 0;
        }
        URL file = null;
        do {
            PlayListEntry currentEntry = this.entries.get(currentIndex);
            if (file != null && !Helpers.isEqualURL(file, currentEntry.getFile())) {
                return;
            }
            file = currentEntry.getFile();
            long startIndex = currentEntry.getTimeIndex();
            if (startIndex > timeIndex) {
                --currentIndex;
                continue;
            }
            long endIndex = startIndex + currentEntry.getDuration();
            if (endIndex >= timeIndex) break;
            ++currentIndex;
        } while (currentIndex >= 0 && currentIndex <= end);
        if (currentIndex != this.current) {
            this.setCurrentElement(currentIndex);
        }
    }

    public synchronized PlayListEntry[] getSelectedEntries() {
        if (this.entries.size() > 0) {
            ArrayList<PlayListEntry> selected = new ArrayList<PlayListEntry>(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                PlayListEntry entry = this.entries.get(i);
                if (!entry.isSelected()) continue;
                selected.add(entry);
            }
            if (selected.size() > 0) {
                return selected.toArray(new PlayListEntry[selected.size()]);
            }
        }
        return null;
    }

    public synchronized void addSelectedElement(int index) {
        PlayListEntry entry = this.entries.get(index);
        entry.setSelected(true);
        this.fireSelectedElementChanged(null, entry);
    }

    public synchronized void toggleSelectedElement(int index) {
        PlayListEntry entry;
        entry.setSelected(!(entry = this.entries.get(index)).isSelected());
        this.fireSelectedElementChanged(null, entry);
    }

    public synchronized void setSelectedElement(int index) {
        this.setSelectedElements(index, index);
    }

    public synchronized void setSelectedElements(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            int swap = fromIndex;
            fromIndex = toIndex;
            toIndex = swap;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            PlayListEntry entry = this.entries.get(i);
            if (entry.isSelected() && (i < fromIndex || i > toIndex)) {
                entry.setSelected(false);
                this.fireSelectedElementChanged(entry, null);
                continue;
            }
            if (entry.isSelected() || i < fromIndex || i > toIndex) continue;
            entry.setSelected(true);
            this.fireSelectedElementChanged(null, entry);
        }
    }

    public synchronized boolean next() {
        if (this.hasNext()) {
            PlayListEntry oldEntry = this.getCurrentEntry();
            this.deactivateCurrentEntry();
            this.current = this.current >= this.size() - 1 ? 0 : ++this.current;
            this.activateCurrentEntry();
            this.fireActiveElementChanged(oldEntry, this.getCurrentEntry());
            return true;
        }
        return false;
    }

    public synchronized boolean previous() {
        if (this.hasPrevious()) {
            PlayListEntry oldEntry = this.getCurrentEntry();
            this.deactivateCurrentEntry();
            --this.current;
            this.activateCurrentEntry();
            this.fireActiveElementChanged(oldEntry, this.getCurrentEntry());
            return true;
        }
        return false;
    }

    public synchronized boolean hasNext() {
        return this.current < this.size() - 1 || this.repeat;
    }

    public synchronized boolean hasPrevious() {
        return this.current > 0;
    }

    public synchronized int size() {
        return this.entries.size();
    }

    public synchronized int indexOf(PlayListEntry entry) {
        return this.entries.indexOf(entry);
    }

    public synchronized void addAllAt(int indexAt, PlayList newPlaylist) {
        ArrayList<PlayListEntry> newEntries = newPlaylist.getEntries();
        int size = newEntries.size();
        for (int i = 0; i < size; ++i) {
            newEntries.get(i).setSavedInPlaylist(this);
        }
        if (indexAt > this.entries.size()) {
            indexAt = this.entries.size();
        }
        this.entries.addAll(indexAt, newEntries);
        if (this.current >= indexAt) {
            this.current += size;
        }
    }

    public synchronized void addEntry(PlayListEntry newPlaylistEntry) {
        newPlaylistEntry.setSavedInPlaylist(this);
        this.entries.add(newPlaylistEntry);
    }

    public synchronized void move(int fromIndex, int toIndex) {
        PlayListEntry mover = this.entries.remove(fromIndex);
        this.entries.add(toIndex, mover);
        if (this.current == fromIndex) {
            this.current = toIndex;
        } else if (this.current == toIndex) {
            ++this.current;
        }
    }

    public synchronized void remove(int fromIndex) {
        this.entries.remove(fromIndex);
        if (this.current > fromIndex && this.current > -1) {
            --this.current;
        } else if (this.current == fromIndex) {
            this.current = -1;
        }
    }

    public URL getLoadedFromURL() {
        return this.loadedFromURL;
    }

    private void setLoadedFromURL(URL loadedFromURL) {
        this.loadedFromURL = loadedFromURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void savePlayListTo(File f) throws IOException {
        PrintWriter ps = null;
        try {
            String prefix = f.getAbsolutePath();
            String lowCasePrefix = prefix.toLowerCase();
            boolean writePLSFile = lowCasePrefix.endsWith("pls");
            boolean writeCueSheet = lowCasePrefix.endsWith("cue");
            boolean writeM3U8 = lowCasePrefix.endsWith("m3u8");
            boolean writeM3U = lowCasePrefix.endsWith("m3u");
            if (!(writePLSFile || writeCueSheet || writeM3U8 || writeM3U)) {
                prefix = prefix + ".M3U";
                f = new File(prefix);
            }
            if (f.exists()) {
                boolean ok = f.delete();
                if (ok) {
                    ok = f.createNewFile();
                }
                if (!ok) {
                    throw new IOException("Could not overwrite file " + prefix);
                }
            }
            prefix = prefix.substring(0, prefix.lastIndexOf(File.separatorChar) + 1);
            lowCasePrefix = prefix.toLowerCase();
            int prefixLen = prefix.length();
            CueSheet cueSheet = null;
            CueFile currentCueFile = null;
            CueTrack currentCueTrack = null;
            int cueTrackIndex = 0;
            int cueTrackNo = 0;
            if (!writeCueSheet) {
                ps = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), writeM3U8 ? "UTF-8" : "ISO-8859-1"));
                ps.println(writePLSFile ? "[playlist]" : "#EXTM3U");
            } else {
                cueSheet = new CueSheet();
                cueSheet.setCueSheedFileName(Helpers.createURLfromFile(f));
            }
            for (int i = 0; i < this.size(); ++i) {
                PlayListEntry entry = this.entries.get(i);
                URL fileURL = entry.getFile();
                if (fileURL == null) continue;
                if (writeCueSheet && cueSheet != null) {
                    if (currentCueFile == null || !Helpers.isEqualURL(currentCueFile.getFile(), fileURL)) {
                        currentCueFile = new CueFile();
                        cueSheet.addFile(currentCueFile);
                        currentCueFile.setFile(fileURL);
                        String ext = Helpers.getExtensionFromURL(fileURL).toLowerCase();
                        if (ext.equals("mp3")) {
                            currentCueFile.setType("MP3");
                        } else {
                            currentCueFile.setType("WAVE");
                        }
                    }
                    if (!entry.getFormattedName().startsWith(INDEX_STRING) || currentCueTrack == null) {
                        currentCueTrack = new CueTrack();
                        currentCueFile.addTrack(currentCueTrack);
                        currentCueTrack.setFormat("AUDIO");
                        currentCueTrack.setTrackNo(++cueTrackNo);
                        currentCueTrack.setTitle(entry.getFormattedName());
                        cueTrackIndex = 0;
                    }
                    CueIndex cueIndex = new CueIndex();
                    cueIndex.setIndexNo(++cueTrackIndex);
                    cueIndex.setMillisecondIndex(entry.getTimeIndex());
                    currentCueTrack.addIndex(cueIndex);
                    continue;
                }
                if (ps == null) continue;
                String fileString = Helpers.createLocalFileStringFromURL(fileURL, true);
                if (fileString.toLowerCase().startsWith(lowCasePrefix)) {
                    fileString = fileString.substring(prefixLen);
                }
                String duration = Long.toString(Helpers.getMillisecondsFromTimeString(entry.getDurationString()) / 1000L);
                if (writePLSFile) {
                    String index = Integer.toString(i + 1) + '=';
                    ps.println("File" + index + fileString);
                    ps.println("Title" + index + entry.getFormattedName());
                    ps.println("Length" + index + duration);
                    continue;
                }
                ps.println("#EXTINF:" + duration + ',' + entry.getFormattedName());
                ps.println(fileString);
            }
            if (writePLSFile && ps != null) {
                ps.println("NumberOfEntries=" + this.size());
                ps.println("Version=2");
            } else if (writeCueSheet && cueSheet != null) {
                cueSheet.writeCueSheet(f);
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public synchronized void savePlayListTo(String fileName) throws IOException {
        this.savePlayListTo(new File(fileName));
    }

    private static URL[] generateURLListFromFileNames(String[] fileNames) {
        ArrayList<File> files = new ArrayList<File>(fileNames.length);
        for (int i = 0; i < fileNames.length; ++i) {
            files.add(new File(fileNames[i]));
        }
        return PlayList.generateURLListFromFiles(files.toArray(new File[files.size()]));
    }

    private static URL[] generateURLListFromFiles(File[] files) {
        ArrayList<URL> urls = new ArrayList<URL>(files.length);
        for (int i = 0; i < files.length; ++i) {
            URL url = Helpers.createURLfromFile(files[i]);
            if (url == null) continue;
            urls.add(url);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static PlayList readPlainFile(String line, URL playListURL, BufferedReader br, boolean shuffle, boolean repeat) throws IOException {
        ArrayList<PlayListEntry> entries = new ArrayList<PlayListEntry>();
        do {
            if ((line = line.trim()).length() == 0) continue;
            PlayListEntry entry = new PlayListEntry(line, null);
            entries.add(entry);
        } while ((line = br.readLine()) != null);
        if (entries.size() > 0) {
            PlayList playList = new PlayList(entries, shuffle, repeat);
            playList.setLoadedFromURL(playListURL);
            return playList;
        }
        return null;
    }

    private static PlayList readPLSFile(URL playListURL, BufferedReader br, boolean shuffle, boolean repeat) throws IOException {
        String line;
        ArrayList<String> songName = new ArrayList<String>();
        ArrayList<String> duration = new ArrayList<String>();
        ArrayList<URL> file = new ArrayList<URL>();
        int highestIndex = -1;
        while ((line = br.readLine()) != null) {
            int index;
            if ((line = line.trim()).length() == 0) continue;
            line = line.toLowerCase();
            int equalOp = line.indexOf(61);
            String value = line.substring(equalOp + 1);
            if (line.startsWith("file")) {
                index = Integer.parseInt(line.substring(4, equalOp)) - 1;
                if (index > highestIndex) {
                    highestIndex = index;
                }
                file.add(index, Helpers.createAbsolutePathForFile(playListURL, value));
                continue;
            }
            if (line.startsWith("title")) {
                index = Integer.parseInt(line.substring(5, equalOp)) - 1;
                if (index > highestIndex) {
                    highestIndex = index;
                }
                songName.add(index, value);
                continue;
            }
            if (!line.startsWith("length") || value.equals("-1")) continue;
            index = Integer.parseInt(line.substring(6, equalOp)) - 1;
            if (index > highestIndex) {
                highestIndex = index;
            }
            duration.add(index, value);
        }
        ArrayList<PlayListEntry> entries = new ArrayList<PlayListEntry>();
        for (int i = 0; i <= highestIndex; ++i) {
            String dura;
            String name;
            if (i >= file.size()) continue;
            PlayListEntry entry = new PlayListEntry((URL)file.get(i), null);
            if (i < songName.size() && (name = (String)songName.get(i)) != null && name.length() != 0) {
                entry.setSongName(name);
            }
            if (i < duration.size() && (dura = (String)duration.get(i)) != null && dura.length() != 0) {
                int seconds = Integer.parseInt(dura);
                entry.setDuration((long)seconds * 1000L);
            }
            entries.add(entry);
        }
        if (entries.size() > 0) {
            PlayList playList = new PlayList(entries, shuffle, repeat);
            playList.setLoadedFromURL(playListURL);
            return playList;
        }
        return null;
    }

    private static PlayList readM3UFile(URL playListURL, BufferedReader br, boolean shuffle, boolean repeat) throws IOException {
        String line;
        ArrayList<PlayListEntry> entries = new ArrayList<PlayListEntry>();
        String songName = null;
        String duration = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#EXTM3U")) continue;
            if (line.startsWith("#EXTINF:")) {
                int comma = line.indexOf(44);
                if (comma <= -1) continue;
                duration = line.substring(8, comma);
                songName = line.substring(comma + 1);
                continue;
            }
            URL normalizedEntry = Helpers.createAbsolutePathForFile(playListURL, line);
            if (normalizedEntry == null) {
                normalizedEntry = Helpers.createURLfromString(line);
            }
            PlayListEntry entry = new PlayListEntry(normalizedEntry, null);
            entries.add(entry);
            if (songName != null && songName.length() != 0) {
                entry.setSongName(songName);
            }
            if (duration != null && duration.length() != 0) {
                int seconds = Integer.parseInt(duration);
                entry.setDuration((long)seconds * 1000L);
            }
            duration = null;
            songName = null;
        }
        if (entries.size() > 0) {
            PlayList playList = new PlayList(entries, shuffle, repeat);
            playList.setLoadedFromURL(playListURL);
            return playList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PlayList readZIPFile(URL playListURL, boolean shuffle, boolean repeat) throws IOException {
        ArrayList<File> entries = new ArrayList<File>();
        ZipInputStream input = null;
        try {
            ZipEntry entry;
            File zipFile = new File(playListURL.toURI());
            input = new ZipInputStream(playListURL.openStream());
            while ((entry = input.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                entries.add(new File(zipFile.getCanonicalPath() + File.separatorChar + entry.getName()));
            }
        }
        catch (Throwable ex) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
        }
        if (entries.size() > 0) {
            return new PlayList(entries.toArray(new File[entries.size()]), shuffle, repeat);
        }
        return null;
    }

    private static PlayList readCUEFile(URL playListURL, boolean shuffle, boolean repeat) throws IOException {
        CueSheet cueSheet = CueSheet.createCueSheet(playListURL);
        int list_index = 0;
        ArrayList<CueFile> cueFiles = cueSheet.getCueFiles();
        int filesSize = cueFiles.size();
        if (filesSize > 0) {
            ArrayList<PlayListEntry> entries = new ArrayList<PlayListEntry>();
            for (int i = 0; i < filesSize; ++i) {
                CueFile cueFile = cueFiles.get(i);
                Object[] infos = MultimediaContainerManager.getSongInfosFor(cueFile.getFile());
                long fullDuration = infos[1] != null ? (Long)infos[1] : -1L;
                ArrayList<CueTrack> cueTracks = cueFile.getTracks();
                int tracksSize = cueTracks.size();
                for (int j = 0; j < tracksSize; ++j) {
                    CueTrack cueTrack = cueTracks.get(j);
                    ArrayList<CueIndex> indexes = cueTrack.getIndexes();
                    int indexSize = indexes.size();
                    for (int k = 0; k < indexSize; ++k) {
                        CueIndex index = indexes.get(k);
                        int indexNo = index.getIndexNo();
                        if (indexNo <= 0) continue;
                        long millisecondIndex = index.getMillisecondIndex();
                        if (j > 0) {
                            PlayListEntry previousEntry = entries.get(list_index - 1);
                            long duration = millisecondIndex - previousEntry.getTimeIndex();
                            previousEntry.setDuration(duration);
                            fullDuration -= duration;
                        }
                        PlayListEntry entry = new PlayListEntry(cueFile.getFile(), null);
                        if (indexNo > 1) {
                            entry.setSongName(INDEX_STRING + indexNo);
                        } else {
                            StringBuilder songName = new StringBuilder();
                            if (cueSheet.getTitle() != null) {
                                songName.append(cueSheet.getTitle());
                            }
                            if (cueTrack.getTitle() != null) {
                                if (songName.length() > 0) {
                                    songName.append(" - ");
                                }
                                songName.append(cueTrack.getTitle());
                            }
                            entry.setSongName(songName.toString());
                        }
                        entry.setTimeIndexInFile(millisecondIndex);
                        entry.setDuration(fullDuration);
                        entries.add(list_index++, entry);
                    }
                }
            }
            return new PlayList(entries, shuffle, repeat);
        }
        return null;
    }

    public static PlayList createNewListWithFiles(URL[] url, boolean shuffle, boolean repeat) {
        return new PlayList(url, shuffle, repeat);
    }

    public static PlayList createNewListWithFile(URL url, boolean shuffle, boolean repeat) {
        return PlayList.createNewListWithFiles(new URL[]{url}, shuffle, repeat);
    }

    public static PlayList createNewListWithFiles(File[] file, boolean shuffle, boolean repeat) {
        return new PlayList(file, shuffle, repeat);
    }

    public static PlayList createNewListWithFile(File file, boolean shuffle, boolean repeat) {
        return PlayList.createNewListWithFiles(new File[]{file}, shuffle, repeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlayList createFromFile(URL url, boolean shuffle, boolean repeat) throws IOException {
        PlayList result = null;
        String fileName = url.getPath().toLowerCase();
        if (fileName.endsWith(".zip")) {
            return PlayList.readZIPFile(url, shuffle, repeat);
        }
        if (fileName.endsWith(".cue")) {
            return PlayList.readCUEFile(url, shuffle, repeat);
        }
        if (!PlayList.isPlaylistFile(url)) return PlayList.createNewListWithFile(url, shuffle, repeat);
        boolean readM3U8 = fileName.endsWith("m3u8");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(url.openStream(), readM3U8 ? "UTF-8" : "ISO-8859-1"));
            String line = "";
            while (line != null && line.length() == 0) {
                line = br.readLine().trim();
            }
            if (line == null) return result;
            result = (line = line.trim()).equalsIgnoreCase("[playlist]") ? PlayList.readPLSFile(url, br, shuffle, repeat) : (line.equalsIgnoreCase("#EXTM3U") ? PlayList.readM3UFile(url, br, shuffle, repeat) : PlayList.readPlainFile(line, url, br, shuffle, repeat));
            return result;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
    }

    public static PlayList createFromFile(File f, boolean shuffle, boolean repeat) throws IOException {
        return PlayList.createFromFile(Helpers.createURLfromFile(f), shuffle, repeat);
    }

    public static PlayList createFromFile(String fileName, boolean shuffle, boolean repeat) throws IOException {
        return PlayList.createFromFile(new File(fileName), shuffle, repeat);
    }

    public static boolean isPlaylistFile(URL fileURL) {
        return PlayList.isPlaylistFile(fileURL.getPath().toLowerCase());
    }

    public static boolean isPlaylistFile(String fileName) {
        for (int i = 0; i < SUPPORTEDPLAYLISTS.length; ++i) {
            if (!fileName.endsWith('.' + SUPPORTEDPLAYLISTS[i])) continue;
            return true;
        }
        return false;
    }

    public static String getFileChooserDescription() {
        StringBuilder sb = new StringBuilder("Playlist (");
        for (int i = 0; i < SUPPORTEDPLAYLISTS.length; ++i) {
            sb.append("*.").append(SUPPORTEDPLAYLISTS[i]);
            if (i >= SUPPORTEDPLAYLISTS.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getFileChooserSaveDescription() {
        StringBuilder sb = new StringBuilder("Playlist (");
        for (int i = 0; i < SUPPORTEDSAVELISTS.length; ++i) {
            sb.append("*.").append(SUPPORTEDSAVELISTS[i]);
            if (i >= SUPPORTEDSAVELISTS.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public synchronized Iterator<PlayListEntry> getIterator() {
        return this.entries.iterator();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int lastIndex = this.size() - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            result.append('[').append(this.entries.get(i)).append(']');
            if (i >= lastIndex) continue;
            result.append(',');
        }
        return result.toString();
    }
}

