/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.playlist;

import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class PlayListEntry {
    private URL file;
    private boolean isActive;
    private boolean isSelected;
    private String songName;
    private Long duration;
    private Long timeIndexInFile;
    private PlayList playList;

    public PlayListEntry(URL file, PlayList savedInPlaylist) {
        this.file = file;
        this.playList = savedInPlaylist;
    }

    public PlayListEntry(File file, PlayList savedInPlaylist) throws MalformedURLException {
        this(file.toURI().toURL(), savedInPlaylist);
    }

    public PlayListEntry(String fileName, PlayList savedInPlaylist) throws MalformedURLException {
        this(new URL(fileName), savedInPlaylist);
    }

    public URL getFile() {
        return this.file;
    }

    public void setFile(URL newFile) {
        this.file = newFile;
    }

    public synchronized void setSongName(String songName) {
        this.songName = songName;
    }

    public synchronized void setDuration(Long duration) {
        this.duration = duration;
    }

    public synchronized void setDuration(long duration) {
        this.duration = duration;
    }

    public synchronized void setTimeIndexInFile(Long timeIndex) {
        this.timeIndexInFile = timeIndex;
    }

    public synchronized void setTimeIndexInFile(long timeIndex) {
        this.timeIndexInFile = timeIndex;
    }

    public synchronized String getFormattedName() {
        if (this.songName == null) {
            Object[] infos = MultimediaContainerManager.getSongInfosFor(this.file);
            this.songName = (String)infos[0];
            if (this.duration == null) {
                this.duration = (Long)infos[1];
            }
        }
        return this.songName;
    }

    public synchronized long getDuration() {
        if (this.duration == null) {
            Object[] infos = MultimediaContainerManager.getSongInfosFor(this.file);
            this.duration = (Long)infos[1];
            if (this.songName == null) {
                this.songName = (String)infos[0];
            }
        }
        return this.duration;
    }

    public synchronized String getDurationString() {
        return Helpers.getTimeStringFromMilliseconds(this.getDuration());
    }

    public synchronized String getTimeIndexString() {
        if (this.timeIndexInFile == null) {
            return " ";
        }
        return Helpers.getTimeStringFromMilliseconds(this.timeIndexInFile);
    }

    public synchronized long getTimeIndex() {
        if (this.timeIndexInFile == null) {
            return 0L;
        }
        return this.timeIndexInFile;
    }

    public synchronized String getQuickSongName() {
        if (this.songName == null) {
            return MultimediaContainerManager.getSongNameFromURL(this.getFile());
        }
        return this.getFormattedName();
    }

    public synchronized String getQuickDuration() {
        if (this.duration == null) {
            return " ";
        }
        return this.getDurationString();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public int getIndexInPlaylist() {
        if (this.playList != null) {
            return this.playList.indexOf(this);
        }
        return -1;
    }

    public void setSavedInPlaylist(PlayList playList) {
        this.playList = playList;
    }

    public String toString() {
        return this.file.toString();
    }
}

