/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.playlist.cuesheet;

import de.quippy.javamod.main.playlist.cuesheet.CueFile;
import de.quippy.javamod.main.playlist.cuesheet.CueIndex;
import de.quippy.javamod.main.playlist.cuesheet.CueTrack;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Pattern;

public class CueSheet {
    private static final String QUOTATION_MARK = "\"";
    private URL cueSheedFileName;
    private String title;
    private String performer;
    private String songwriter;
    private ArrayList<CueFile> cueFiles = new ArrayList();

    public CueSheet() {
    }

    public CueSheet(URL file) {
        this();
        this.cueSheedFileName = file;
        this.readCueSheet(file);
    }

    public CueSheet(File file) {
        this(Helpers.createURLfromFile(file));
    }

    public CueSheet(String file) {
        this(Helpers.createURLfromString(file));
    }

    public URL getCueSheedFileName() {
        return this.cueSheedFileName;
    }

    public void setCueSheedFileName(URL fileName) {
        this.cueSheedFileName = fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPerformer() {
        return this.performer;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public String getSongwriter() {
        return this.songwriter;
    }

    public void setSongwriter(String songwriter) {
        this.songwriter = songwriter;
    }

    public ArrayList<CueFile> getCueFiles() {
        return this.cueFiles;
    }

    public void addFile(CueFile cueFile) {
        this.cueFiles.add(cueFile);
    }

    private void writeCommentBlock(Writer writer, String title, String performer, String songWriter, int column) throws IOException {
        StringBuilder columnString = new StringBuilder();
        for (int i = 0; i < column; ++i) {
            columnString.append("  ");
        }
        if (performer != null && performer.length() != 0) {
            writer.write(columnString.toString() + "PERFORMER \"" + performer + "\"\r\n");
        }
        if (title != null && title.length() != 0) {
            writer.write(columnString.toString() + "TITLE \"" + title + "\"\r\n");
        }
        if (songWriter != null && songWriter.length() != 0) {
            writer.write(columnString.toString() + "SONGWRITER \"" + songWriter + "\"\r\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCueSheet(File toFile) {
        String prefix = toFile.getAbsolutePath();
        prefix = prefix.substring(0, prefix.lastIndexOf(File.separatorChar) + 1).toLowerCase();
        int prefixLen = prefix.length();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(toFile)));
            bw.write("REM COMMENT \"Java Mod Player V2.3\"\r\n");
            this.writeCommentBlock(bw, this.getTitle(), this.getPerformer(), this.getSongwriter(), 0);
            ArrayList<CueFile> cueFiles = this.getCueFiles();
            int filesSize = cueFiles.size();
            for (int i = 0; i < filesSize; ++i) {
                CueFile cueFile = cueFiles.get(i);
                String fileString = Helpers.createLocalFileStringFromURL(cueFile.getFile(), true);
                if (fileString.toLowerCase().startsWith(prefix)) {
                    fileString = fileString.substring(prefixLen);
                }
                bw.write("FILE \"" + fileString + "\" " + cueFile.getType() + "\r\n");
                ArrayList<CueTrack> cueTracks = cueFile.getTracks();
                int tracksSize = cueTracks.size();
                for (int j = 0; j < tracksSize; ++j) {
                    CueTrack cueTrack = cueTracks.get(j);
                    int trackNo = cueTrack.getTrackNo();
                    String track = trackNo < 10 ? "0" + trackNo : String.valueOf(trackNo);
                    bw.write("  TRACK " + track + " " + cueTrack.getFormat() + "\r\n");
                    this.writeCommentBlock(bw, cueTrack.getTitle(), cueTrack.getPerformer(), cueTrack.getSongwriter(), 2);
                    ArrayList<CueIndex> indexes = cueTrack.getIndexes();
                    int indexSize = indexes.size();
                    for (int k = 0; k < indexSize; ++k) {
                        CueIndex cueIndex = indexes.get(k);
                        int indexNo = cueIndex.getIndexNo();
                        String index = indexNo < 10 ? "0" + indexNo : String.valueOf(indexNo);
                        long milliIndex = cueIndex.getMillisecondIndex();
                        Integer min = (int)(milliIndex / 60000L);
                        Integer sec = (int)(milliIndex / 1000L % 60L);
                        Integer frame = (int)(((milliIndex -= (min.longValue() * 60L + sec.longValue()) * 1000L) * 75L + 500L) / 1000L);
                        String timeIndex = String.format("%02d:%02d:%02d", min, sec, frame);
                        bw.write("    INDEX " + index + " " + timeIndex + "\r\n");
                    }
                }
            }
        }
        catch (Throwable ex) {
            Log.error("[CueSheet]: Writing to \"" + toFile.getAbsolutePath() + "\" failed", ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
    }

    public static CueSheet createCueSheet(String file) {
        return new CueSheet(file);
    }

    public static CueSheet createCueSheet(File file) {
        return new CueSheet(file);
    }

    public static CueSheet createCueSheet(URL file) {
        return new CueSheet(file);
    }

    private static String getStringFromQuotation(Scanner tok) {
        String nextToken = tok.next();
        if (nextToken.startsWith(QUOTATION_MARK)) {
            nextToken = nextToken.endsWith(QUOTATION_MARK) ? nextToken.substring(1, nextToken.length() - 1) : nextToken.substring(1) + tok.useDelimiter(QUOTATION_MARK).next();
        }
        return nextToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCueSheet(URL fromFile) {
        BufferedReader br = null;
        Scanner tok = null;
        CueFile cueFile = null;
        CueTrack cueTrack = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(fromFile.openStream(), "ISO-8859-1"));
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || !(tok = new Scanner(line)).hasNext()) continue;
                String token = tok.next();
                if (token.equalsIgnoreCase("FILE")) {
                    String f = CueSheet.getStringFromQuotation(tok);
                    cueFile = new CueFile();
                    this.addFile(cueFile);
                    cueFile.setFile(Helpers.createAbsolutePathForFile(fromFile, f));
                    cueFile.setType(tok.next());
                    cueTrack = null;
                    continue;
                }
                if (token.equalsIgnoreCase("TRACK")) {
                    if (cueFile == null) {
                        tok.close();
                        throw new RuntimeException("Illegal cue sheet: track without file");
                    }
                    cueTrack = new CueTrack();
                    cueFile.addTrack(cueTrack);
                    cueTrack.setTrackNo(tok.nextInt());
                    cueTrack.setFormat(tok.nextLine().trim().toUpperCase());
                    continue;
                }
                if (token.equalsIgnoreCase("TITLE")) {
                    String title = CueSheet.getStringFromQuotation(tok);
                    if (cueTrack != null && cueTrack.getTitle() == null) {
                        cueTrack.setTitle(title);
                        continue;
                    }
                    this.setTitle(title);
                    continue;
                }
                if (token.equalsIgnoreCase("PERFORMER")) {
                    String performer = CueSheet.getStringFromQuotation(tok);
                    if (cueTrack != null && cueTrack.getPerformer() == null) {
                        cueTrack.setPerformer(performer);
                        continue;
                    }
                    this.setPerformer(performer);
                    continue;
                }
                if (token.equalsIgnoreCase("SONGWRITER")) {
                    String songWriter = CueSheet.getStringFromQuotation(tok);
                    if (cueTrack != null && cueTrack.getSongwriter() == null) {
                        cueTrack.setSongwriter(songWriter);
                        continue;
                    }
                    this.setSongwriter(songWriter);
                    continue;
                }
                if (!token.equalsIgnoreCase("INDEX")) continue;
                if (cueTrack == null) {
                    tok.close();
                    throw new RuntimeException("Illegal cue sheet: index without track");
                }
                int indexNo = tok.nextInt();
                Scanner sc = tok.useDelimiter(Pattern.compile(":| "));
                int minutes = sc.nextInt();
                int seconds = sc.nextInt();
                int frames = sc.nextInt();
                CueIndex index = new CueIndex();
                index.setIndexNo(indexNo);
                index.setMillisecondIndex(((long)minutes * 60L + (long)seconds) * 1000L + (long)frames * 1000L / 75L);
                cueTrack.addIndex(index);
            }
        }
        catch (Throwable ex) {
            Log.error("[CueSheet]: Loading failed", ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
            if (tok != null) {
                tok.close();
            }
        }
    }
}

