/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer;

import de.quippy.javamod.io.SoundOutputStream;
import de.quippy.javamod.io.SoundOutputStreamImpl;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import java.io.File;
import javax.sound.sampled.AudioFormat;

public abstract class Mixer {
    private SoundOutputStream outputStream = null;
    private AudioProcessor audioProcessor = null;
    private AudioFormat audioFormat = null;
    private File exportFile = null;
    private boolean playDuringExport = false;
    private boolean keepSilent = false;
    private float currentVolume = 1.0f;
    private float currentBalance = 0.0f;

    protected void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    protected AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public void setAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessor = audioProcessor;
    }

    public void setVolume(float newVolume) {
        this.currentVolume = newVolume;
        if (this.outputStream != null) {
            this.outputStream.setVolume(newVolume);
        }
    }

    public void setBalance(float newBalance) {
        this.currentBalance = newBalance;
        if (this.outputStream != null) {
            this.outputStream.setBalance(newBalance);
        }
    }

    public void setSoundOutputStream(SoundOutputStream newOutputStream) {
        this.outputStream = newOutputStream;
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
    }

    public void setExportFile(String exportFileName) {
        if (exportFileName != null) {
            this.exportFile = new File(exportFileName);
        }
    }

    public void setPlayDuringExport(boolean playDuringExport) {
        this.playDuringExport = playDuringExport;
    }

    public void setKeepSilent(boolean keepSilent) {
        this.keepSilent = keepSilent;
    }

    protected void writeSampleDataToLine(byte[] samples, int start, int length) {
        if (this.outputStream != null) {
            this.outputStream.writeSampleData(samples, start, length);
        }
    }

    protected void setInternatFramePosition(long newPosition) {
        if (this.outputStream != null) {
            this.outputStream.setInternalFramePosition(newPosition);
        }
    }

    protected void openAudioDevice() {
        this.closeAudioDevice();
        if (this.outputStream == null) {
            this.outputStream = new SoundOutputStreamImpl(this.audioFormat, this.audioProcessor, this.exportFile, this.playDuringExport, this.keepSilent);
        } else {
            this.outputStream.changeAudioFormatTo(this.audioFormat);
            this.outputStream.setAudioProcessor(this.audioProcessor);
            this.outputStream.setExportFile(this.exportFile);
            this.outputStream.setPlayDuringExport(this.playDuringExport);
            this.outputStream.setKeepSilent(this.keepSilent);
        }
        this.outputStream.setVolume(this.currentVolume);
        this.outputStream.setBalance(this.currentBalance);
        this.outputStream.open();
    }

    protected void closeAudioDevice() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    protected void fullyCloseAudioDevice() {
        if (this.outputStream != null) {
            this.outputStream.closeAllDevices();
        }
    }

    protected void stopLine() {
        if (this.outputStream != null) {
            this.outputStream.stopLine();
        }
    }

    protected void startLine() {
        if (this.outputStream != null) {
            this.outputStream.startLine();
        }
    }

    protected boolean isInitialized() {
        if (this.outputStream != null) {
            return this.outputStream.isInitialized();
        }
        return false;
    }

    public abstract boolean isPaused();

    public abstract boolean isPausing();

    public abstract boolean isNotSeeking();

    public abstract boolean isInSeeking();

    public abstract boolean isSeeking();

    public abstract boolean isNotPausingNorPaused();

    public abstract boolean isStopped();

    public abstract boolean isStopping();

    public abstract boolean isNotStoppingNorStopped();

    public abstract boolean isPlaying();

    public abstract boolean hasFinished();

    public abstract void stopPlayback();

    public abstract void pausePlayback();

    public abstract void startPlayback();

    public abstract boolean isSeekSupported();

    public abstract void setMillisecondPosition(long var1);

    public abstract long getLengthInMilliseconds();

    public abstract long getMillisecondPosition();

    public abstract int getChannelCount();

    public abstract int getCurrentKBperSecond();

    public abstract int getCurrentSampleFrequency();
}

