/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp;

import de.quippy.javamod.mixer.dsp.DSPEffekt;
import de.quippy.javamod.mixer.dsp.DspProcessorCallBack;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;

public class AudioProcessor {
    private final Object lock = new Object();
    private final int desiredBufferSize;
    private final long waitForNanos;
    private final ArrayList<DspProcessorCallBack> callBacks;
    private final ArrayList<DSPEffekt> effectCallBacks;
    private static final int SAMPLEBUFFERSIZE = 96000;
    private SourceDataLine sourceDataLine;
    private volatile long internalFramePosition;
    private volatile boolean useInternalCounter;
    private int sampleBufferSize;
    private float[] sampleBuffer;
    private byte[] resultSampleBuffer;
    private int currentWritePosition;
    private ProcessorTask processorThread;
    private AudioFormat audioFormat;
    private boolean isBigEndian;
    private boolean isSigned;
    private int sampleSizeInBits;
    private int bytesPerChannel;
    private int mask;
    private int neg_Bit;
    private int neg_mask;
    private int minSample;
    private int maxSample;
    private boolean dspEnabled;

    public AudioProcessor(int desiredBufferSize, int desiredFPS) {
        this.desiredBufferSize = desiredBufferSize;
        this.waitForNanos = 1000000000L / (long)desiredFPS;
        this.callBacks = new ArrayList();
        this.effectCallBacks = new ArrayList();
        this.dspEnabled = true;
    }

    public AudioProcessor() {
        this(1024, 70);
    }

    public synchronized void addListener(DspProcessorCallBack callBack) {
        if (!this.callBacks.contains(callBack)) {
            this.callBacks.add(callBack);
        }
    }

    public synchronized void removeListener(DspProcessorCallBack callBack) {
        this.callBacks.remove(callBack);
    }

    private synchronized void fireCurrentSampleChanged(float[] leftBuffer, float[] rightBuffer) {
        int size = this.callBacks.size();
        for (int i = 0; i < size; ++i) {
            this.callBacks.get(i).currentSampleChanged(leftBuffer, rightBuffer);
        }
    }

    public synchronized void addEffectListener(DSPEffekt effectCallBack) {
        if (!this.effectCallBacks.contains(effectCallBack)) {
            this.effectCallBacks.add(effectCallBack);
        }
    }

    public synchronized void removeEffectListener(DSPEffekt effectCallBack) {
        this.effectCallBacks.remove(effectCallBack);
    }

    private synchronized void initializeEffects(AudioFormat audioFormat, int sampleBufferLength) {
        int size = this.effectCallBacks.size();
        for (int i = 0; i < size; ++i) {
            this.effectCallBacks.get(i).initialize(audioFormat, sampleBufferLength);
        }
    }

    private synchronized int callEffects(float[] buffer, int start, int length) {
        int size = this.effectCallBacks.size();
        int anzSamples = length;
        for (int i = 0; i < size; ++i) {
            anzSamples = this.effectCallBacks.get(i).doEffekt(buffer, start, anzSamples);
        }
        return anzSamples;
    }

    public void setUseInternalCounter(boolean useInternalCounter) {
        this.useInternalCounter = useInternalCounter;
    }

    public void setInternalFramePosition(long internalFramePosition) {
        this.internalFramePosition = internalFramePosition;
    }

    public long getFramePosition() {
        return this.useInternalCounter || this.sourceDataLine == null ? this.internalFramePosition : this.sourceDataLine.getLongFramePosition();
    }

    public void initializeProcessor(SourceDataLine sourceDataLine) {
        this.sourceDataLine = sourceDataLine;
        this.initializeProcessor(sourceDataLine.getFormat());
    }

    public void initializeProcessor(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
        this.isBigEndian = audioFormat.isBigEndian();
        this.isSigned = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        this.sampleSizeInBits = audioFormat.getSampleSizeInBits();
        this.bytesPerChannel = this.sampleSizeInBits >> 3;
        this.mask = (1 << this.sampleSizeInBits) - 1;
        this.neg_Bit = 1 << this.sampleSizeInBits - 1;
        this.maxSample = this.neg_Bit - 1;
        this.minSample = -this.neg_Bit;
        this.neg_mask = 0xFFFFFFFF ^ this.mask;
        this.sampleBufferSize = this.sourceDataLine == null ? 96000 : this.sourceDataLine.getBufferSize();
        this.sampleBuffer = new float[this.sampleBufferSize];
        this.resultSampleBuffer = new byte[this.sampleBufferSize * this.bytesPerChannel];
        this.currentWritePosition = 0;
        this.internalFramePosition = 0L;
        this.useInternalCounter = false;
        this.initializeEffects(audioFormat, this.sampleBufferSize);
        this.processorThread = new ProcessorTask(this);
        this.processorThread.start();
    }

    public void stop() {
        if (this.processorThread != null) {
            this.processorThread.stopProcessorTask();
            this.processorThread = null;
            this.sampleBuffer = null;
        }
    }

    public boolean isDspEnabled() {
        return this.dspEnabled;
    }

    public void setDspEnabled(boolean dspEnabled) {
        this.dspEnabled = dspEnabled;
    }

    public byte[] getResultSampleBuffer() {
        return this.resultSampleBuffer;
    }

    private int writeIntoFloatArrayBuffer(int anzSamples) {
        int wx = this.currentWritePosition;
        for (int ox = 0; ox < anzSamples; ox += this.bytesPerChannel) {
            int s;
            int b;
            int sample = 0;
            if (this.isBigEndian) {
                b = this.bytesPerChannel - 1;
                s = 0;
                while (b >= 0) {
                    sample |= (this.resultSampleBuffer[ox + b] & 0xFF) << s;
                    --b;
                    s += 8;
                }
            } else {
                b = 0;
                s = 0;
                while (b < this.bytesPerChannel) {
                    sample |= (this.resultSampleBuffer[ox + b] & 0xFF) << s;
                    ++b;
                    s += 8;
                }
            }
            if (this.isSigned) {
                if ((sample & this.neg_Bit) != 0) {
                    sample |= this.neg_mask;
                }
            } else {
                sample = (sample & this.mask) - this.neg_Bit;
            }
            this.sampleBuffer[wx++ % this.sampleBufferSize] = (float)sample / (float)this.neg_Bit;
        }
        return wx - this.currentWritePosition;
    }

    private int readFromFloatArrayBuffer(int anzSamples) {
        int rx = this.currentWritePosition;
        int ox = 0;
        int i = 0;
        while (i < anzSamples) {
            int s;
            int b;
            int sample;
            if ((sample = (int)(this.sampleBuffer[rx++ % this.sampleBufferSize] * (float)this.neg_Bit)) > this.maxSample) {
                sample = this.maxSample;
            } else if (sample < this.minSample) {
                sample = this.minSample;
            }
            if (!this.isSigned) {
                sample += this.neg_Bit;
            }
            if (this.isBigEndian) {
                b = this.bytesPerChannel - 1;
                s = 0;
                while (b >= 0) {
                    this.resultSampleBuffer[ox + b] = (byte)(sample >> s & 0xFF);
                    --b;
                    s += 8;
                }
            } else {
                b = 0;
                s = 0;
                while (b < this.bytesPerChannel) {
                    this.resultSampleBuffer[ox + b] = (byte)(sample >> s & 0xFF);
                    ++b;
                    s += 8;
                }
            }
            ++i;
            ox += this.bytesPerChannel;
        }
        return ox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeSampleData(byte[] newSampleData, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            System.arraycopy(newSampleData, offset, this.resultSampleBuffer, 0, length);
            int anzSamples = this.writeIntoFloatArrayBuffer(length);
            if (this.dspEnabled) {
                anzSamples = this.callEffects(this.sampleBuffer, this.currentWritePosition, anzSamples);
                length = this.readFromFloatArrayBuffer(anzSamples);
            }
            this.currentWritePosition = (this.currentWritePosition + anzSamples) % this.sampleBufferSize;
            return length;
        }
    }

    public int writeSampleData(byte[] newSampleData) {
        return this.writeSampleData(newSampleData, 0, newSampleData.length);
    }

    private final class ProcessorTask
    extends Thread {
        private final AudioProcessor me;
        private final float[] leftBuffer;
        private final float[] rightBuffer;
        private final long nanoWait;
        private volatile boolean process;
        private volatile boolean process_alive;

        public ProcessorTask(AudioProcessor parent) {
            this.me = parent;
            this.leftBuffer = new float[this.me.desiredBufferSize];
            this.rightBuffer = new float[this.me.desiredBufferSize];
            this.process = true;
            this.nanoWait = parent.waitForNanos;
            this.setDaemon(true);
            this.setName("AudioProcessor");
            this.setPriority(10);
        }

        public void stopProcessorTask() {
            this.process = false;
            while (this.process_alive) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.me.fireCurrentSampleChanged(null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.process_alive = true;
            while (this.process) {
                long now = System.nanoTime();
                Object object = AudioProcessor.this.lock;
                synchronized (object) {
                    int channels = this.me.audioFormat.getChannels();
                    int currentReadPosition = (int)(this.me.getFramePosition() * (long)channels % (long)this.me.sampleBufferSize);
                    for (int i = 0; i < this.me.desiredBufferSize; ++i) {
                        if (currentReadPosition >= this.me.sampleBufferSize) {
                            currentReadPosition = 0;
                        }
                        if (channels == 2) {
                            this.leftBuffer[i] = this.me.sampleBuffer[currentReadPosition++];
                            this.rightBuffer[i] = this.me.sampleBuffer[currentReadPosition++];
                            continue;
                        }
                        this.leftBuffer[i] = this.rightBuffer[i] = this.me.sampleBuffer[currentReadPosition++];
                    }
                }
                this.me.fireCurrentSampleChanged(this.leftBuffer, this.rightBuffer);
                long stillToWait = this.nanoWait - (System.nanoTime() - now);
                if (stillToWait > 0L) {
                    try {
                        Thread.sleep(stillToWait / 1000000L);
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {}
            }
            this.process_alive = false;
        }
    }
}

