/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp;

import de.quippy.javamod.system.FastMath;

public class FFT2 {
    public static final int FORWARD = -1;
    public static final int REVERSE = 1;
    private int frameSize = 0;
    private int bits = 0;
    private int[] flip = null;

    public FFT2(int frameSize) {
        this.frameSize = frameSize;
        this.bits = (int)(Math.log(frameSize) / Math.log(2.0));
        this.createBitFlipArray();
    }

    private void createBitFlipArray() {
        this.flip = new int[this.frameSize];
        for (int i = 1; i < this.frameSize - 1; ++i) {
            int j = 0;
            for (int bitm = 1; bitm < this.frameSize; bitm <<= 1) {
                if ((i & bitm) != 0) {
                    ++j;
                }
                j <<= 1;
            }
            this.flip[i] = j / 2;
        }
    }

    public void smsFft(float[] fftBuffer, int sign) {
        if (sign != -1 && sign != 1) {
            throw new IllegalArgumentException("invalid sign: " + sign);
        }
        for (int i = 1; i < this.frameSize - 1; ++i) {
            int j = this.flip[i];
            if (i >= j) continue;
            int i2 = i << 1;
            int j2 = j << 1;
            float temp = fftBuffer[i2];
            fftBuffer[i2] = fftBuffer[j2];
            fftBuffer[j2] = temp;
            temp = fftBuffer[++i2];
            fftBuffer[i2] = fftBuffer[++j2];
            fftBuffer[j2] = temp;
        }
        int le = 2;
        for (int k = 0; k < this.bits; ++k) {
            int le2 = (le <<= 1) >> 1;
            float ur = 1.0f;
            float ui = 0.0f;
            float arg = (float)Math.PI / (float)(le2 >> 1);
            float wr = (float)FastMath.fastCos(arg);
            float wi = (float)sign * (float)FastMath.fastSin(arg);
            for (int j = 0; j < le2; j += 2) {
                int p1r = j;
                int p1i = p1r + 1;
                int p2r = p1r + le2;
                int p2i = p2r + 1;
                for (int i = j; i < this.frameSize << 1; i += le) {
                    float tr = fftBuffer[p2r] * ur - fftBuffer[p2i] * ui;
                    float ti = fftBuffer[p2r] * ui + fftBuffer[p2i] * ur;
                    fftBuffer[p2r] = fftBuffer[p1r] - tr;
                    fftBuffer[p2i] = fftBuffer[p1i] - ti;
                    int n = p1r;
                    fftBuffer[n] = fftBuffer[n] + tr;
                    int n2 = p1i;
                    fftBuffer[n2] = fftBuffer[n2] + ti;
                    p1r += le;
                    p1i += le;
                    p2r += le;
                    p2i += le;
                }
                float tr = ur * wr - ui * wi;
                ui = ur * wi + ui * wr;
                ur = tr;
            }
        }
    }
}

