/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir;

import de.quippy.javamod.mixer.dsp.DSPEffekt;
import de.quippy.javamod.mixer.dsp.iir.filter.IIRBandpassFilter;
import de.quippy.javamod.mixer.dsp.iir.filter.IIRFilter;
import de.quippy.javamod.mixer.dsp.iir.filter.IIRFilterBase;
import javax.sound.sampled.AudioFormat;

public class GraphicEQ
implements DSPEffekt {
    private static final float Q = 1.4f;
    private static final int[] CENTER_FREQUENCIES = new int[]{60, 170, 310, 600, 1000, 3000, 6000, 12000, 14000, 16000};
    private int usedBands;
    private IIRFilter theFilter;
    private boolean isActive;

    public GraphicEQ() {
        IIRFilterBase[] filters = new IIRBandpassFilter[CENTER_FREQUENCIES.length];
        for (int i = 0; i < CENTER_FREQUENCIES.length; ++i) {
            filters[i] = new IIRBandpassFilter();
        }
        this.theFilter = new IIRFilter(filters);
        this.isActive = false;
    }

    @Override
    public void initialize(AudioFormat audioFormat, int sampleBufferSize) {
        int bands;
        int currentSampleRate = (int)audioFormat.getSampleRate();
        int breakFreq = currentSampleRate >> 1;
        IIRFilterBase[] filters = this.theFilter.getFilters();
        for (int i = 0; i < CENTER_FREQUENCIES.length; ++i) {
            filters[i].initialize(currentSampleRate, audioFormat.getChannels(), CENTER_FREQUENCIES[i], 1.4f);
        }
        this.theFilter.initialize(audioFormat.getChannels(), sampleBufferSize);
        for (bands = 0; bands < CENTER_FREQUENCIES.length && CENTER_FREQUENCIES[bands] <= breakFreq; ++bands) {
        }
        this.usedBands = bands;
    }

    @Override
    public void setIsActive(boolean active) {
        this.isActive = active;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public int getBandCount() {
        return CENTER_FREQUENCIES.length;
    }

    public int getCenterFreq(int bandIndex) {
        return CENTER_FREQUENCIES[bandIndex];
    }

    public void setBand(int bandIndex, float newDB) {
        this.theFilter.setBand(bandIndex, newDB);
    }

    public float getBand(int bandIndex) {
        return this.theFilter.getBand(bandIndex);
    }

    public void setPreAmp(float newPreAmpDB) {
        this.theFilter.setPreAmp(newPreAmpDB);
    }

    public float getPreAmpDB() {
        return this.theFilter.getPreAmp();
    }

    @Override
    public int doEffekt(float[] buffer, int start, int length) {
        if (!this.isActive) {
            return length;
        }
        return this.theFilter.doFilter(buffer, start, length, this.usedBands);
    }
}

