/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir;

import de.quippy.javamod.mixer.dsp.iir.GraphicEQ;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphicEqGUI
extends JPanel {
    private static final long serialVersionUID = 8091057988399658762L;
    private static final int SHIFT_DB = 100;
    private static final int SLIDER_MAX = 2000;
    private static final int SLIDER_MIN = -2000;
    private static final String DEZIBEL = "db";
    private GraphicEQ eq;
    private JPanel selectionPanel = null;
    private JPanel bandsPanel = null;
    private JPanel preAmpPanel = null;
    private JSlider[] sliders = null;
    private JLabel[] slidersLable = null;
    private JSlider preAmpSlider = null;
    private JLabel preAmpSliderLable = null;
    private JLabel minLabel = null;
    private JLabel centerLabel = null;
    private JLabel maxLabel = null;
    private JCheckBox equalizerActive = null;
    private JLabel presetSelectionLabel = null;
    private JComboBox presetSelection = null;
    private boolean presetsActive;
    private static final String[] PRESET_NAMES = new String[]{"Select a preset...", "Flat", "Classical", "Club", "Cristal", "Dance", "Full bass", "Full bass & treble", "Full treble", "Laptop", "Live", "Party", "Pop", "Reggae", "Rock", "Techno"};
    private static final int[][] PRESET_DB = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, -8, -8, -8, -10}, {0, 0, 4, 7, 7, 7, 4, 0, 0, 0}, {20, 15, 10, 5, 0, 0, 5, 10, 15, 20}, {10, 7, 2, 0, 0, -6, -8, -8, 0, 0}, {10, 10, 10, 6, 2, -4, -10, -11, -11, -11}, {7, 7, 0, -7, -4, 2, 9, 12, 13, 13}, {-11, -11, -11, -4, 4, 11, 17, 17, 17, 17}, {5, 12, 6, -4, -3, 2, 5, 11, 14, 15}, {-6, 0, 4, 6, 7, 7, 4, 4, 4, 4}, {8, 8, 0, 0, 0, 0, 0, 0, 8, 8}, {-2, 5, 8, 8, 5, -1, -2, -2, -1, -1}, {1, 1, 0, -6, 1, 7, 7, 1, 1, 1}, {8, 5, -5, -8, -2, 4, 9, 11, 11, 11}, {8, 7, 1, -6, -5, 1, 8, 11, 11, 9}};

    public GraphicEqGUI(GraphicEQ equalizer) {
        if (equalizer == null) {
            throw new IllegalArgumentException("Equalizer must not be null!");
        }
        this.eq = equalizer;
        this.presetsActive = this.eq.getBandCount() == 10;
        this.initialize();
    }

    private void initialize() {
        this.setName("Equalizer");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getSelectionPanel(), Helpers.getGridBagConstraint(0, 0, 1, 0, 2, 18, 1.0, 0.0));
        this.add((Component)this.getBandsPanel(), Helpers.getGridBagConstraint(0, 1, 1, 1, 2, 18, 1.0, 0.0));
        this.add((Component)this.getPreAmpPanel(), Helpers.getGridBagConstraint(1, 1, 1, 0, 2, 18, 1.0, 0.0));
    }

    private JPanel getSelectionPanel() {
        if (this.selectionPanel == null) {
            this.selectionPanel = new JPanel();
            this.selectionPanel.setName("selectionPanel");
            this.selectionPanel.setLayout(new GridBagLayout());
            this.selectionPanel.setBorder(new TitledBorder(null, "Selections", 4, 0, Helpers.getDialogFont(), null));
            this.selectionPanel.add((Component)this.getEqualizerActive(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 1.0, 0.0));
            this.selectionPanel.add((Component)this.getPresetSelectionLabel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 13, 1.0, 0.0));
            this.selectionPanel.add((Component)this.getPresetSelection(), Helpers.getGridBagConstraint(2, 0, 1, 0, 2, 13, 1.0, 0.0));
        }
        return this.selectionPanel;
    }

    private JCheckBox getEqualizerActive() {
        if (this.equalizerActive == null) {
            this.equalizerActive = new JCheckBox();
            this.equalizerActive.setName("equalizerActive");
            this.equalizerActive.setText("activate equalizer");
            this.equalizerActive.setFont(Helpers.getDialogFont());
            if (this.eq != null) {
                this.equalizerActive.setSelected(this.eq.isActive());
            }
            this.equalizerActive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if ((e.getStateChange() == 1 || e.getStateChange() == 2) && GraphicEqGUI.this.eq != null) {
                        GraphicEqGUI.this.eq.setIsActive(GraphicEqGUI.this.getEqualizerActive().isSelected());
                    }
                }
            });
        }
        return this.equalizerActive;
    }

    private JLabel getPresetSelectionLabel() {
        if (this.presetSelectionLabel == null) {
            this.presetSelectionLabel = new JLabel("Presets:");
            this.presetSelectionLabel.setFont(Helpers.getDialogFont());
            this.presetSelectionLabel.setEnabled(this.presetsActive);
        }
        return this.presetSelectionLabel;
    }

    private JComboBox getPresetSelection() {
        if (this.presetSelection == null) {
            this.presetSelection = new JComboBox();
            this.presetSelection.setName("presetSelection");
            DefaultComboBoxModel<String> theModel = new DefaultComboBoxModel<String>(PRESET_NAMES);
            this.presetSelection.setModel(theModel);
            this.presetSelection.setFont(Helpers.getDialogFont());
            this.presetSelection.setEnabled(this.presetsActive);
            this.presetSelection.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        GraphicEqGUI.this.setPreset(GraphicEqGUI.this.getPresetSelection().getSelectedIndex());
                    }
                }
            });
        }
        return this.presetSelection;
    }

    private JSlider createDefaultSlider(float value) {
        if (value > 20.0f) {
            value = 20.0f;
        } else if (value < -20.0f) {
            value = -20.0f;
        }
        JSlider slider = new JSlider(1, -2000, 2000, (int)(value * 100.0f));
        slider.setFont(Helpers.getDialogFont());
        slider.setMinorTickSpacing(500);
        slider.setMajorTickSpacing(1000);
        slider.setPaintTicks(true);
        slider.setSnapToTicks(false);
        slider.setPaintLabels(false);
        slider.setPaintTrack(true);
        slider.setToolTipText(Float.toString((float)Math.round(value * 10.0f) / 10.0f) + DEZIBEL);
        slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ((JSlider)e.getSource()).setValue(0);
                    e.consume();
                }
            }
        });
        return slider;
    }

    private JPanel getBandsPanel() {
        if (this.bandsPanel == null) {
            this.bandsPanel = new JPanel();
            this.bandsPanel.setName("bandsPanel");
            this.bandsPanel.setLayout(new GridBagLayout());
            this.bandsPanel.setBorder(new TitledBorder(null, "Bands", 4, 0, Helpers.getDialogFont(), null));
            this.maxLabel = new JLabel("+" + Integer.toString(20));
            this.maxLabel.setFont(Helpers.getDialogFont());
            this.bandsPanel.add((Component)this.maxLabel, Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 11, 0.0, 1.0));
            this.centerLabel = new JLabel("0db");
            this.centerLabel.setFont(Helpers.getDialogFont());
            this.bandsPanel.add((Component)this.centerLabel, Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 10, 0.0, 1.0));
            this.minLabel = new JLabel(Integer.toString(-20));
            this.minLabel.setFont(Helpers.getDialogFont());
            this.bandsPanel.add((Component)this.minLabel, Helpers.getGridBagConstraint(0, 2, 1, 1, 0, 15, 0.0, 1.0));
            int bandCount = this.eq.getBandCount();
            this.sliders = new JSlider[bandCount];
            this.slidersLable = new JLabel[bandCount];
            for (int i = 0; i < bandCount; ++i) {
                this.sliders[i] = this.createDefaultSlider(this.eq.getBand(i));
                this.sliders[i].setName(Integer.toString(i));
                this.sliders[i].addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        JSlider slider = (JSlider)e.getSource();
                        String sliderName = slider.getName();
                        int bandIndex = Integer.parseInt(sliderName);
                        int value = slider.getValue();
                        GraphicEqGUI.this.eq.setBand(bandIndex, (float)value / 100.0f);
                        slider.setToolTipText(Float.toString((float)Math.round(GraphicEqGUI.this.eq.getBand(bandIndex) * 10.0f) / 10.0f) + GraphicEqGUI.DEZIBEL);
                    }
                });
                int centerFreq = this.eq.getCenterFreq(i);
                String lableString = centerFreq >= 1000 ? Integer.toString(centerFreq / 1000) + "k" : Integer.toString(centerFreq);
                this.slidersLable[i] = new JLabel(lableString);
                this.slidersLable[i].setFont(Helpers.getDialogFont());
                this.bandsPanel.add((Component)this.sliders[i], Helpers.getGridBagConstraint(i + 1, 0, 3, 1, 3, 10, 0.0, 1.0));
                this.bandsPanel.add((Component)this.slidersLable[i], Helpers.getGridBagConstraint(i + 1, 3, 1, 1, 0, 10, 0.0, 0.0));
            }
        }
        return this.bandsPanel;
    }

    private JPanel getPreAmpPanel() {
        if (this.preAmpPanel == null) {
            this.preAmpPanel = new JPanel();
            this.preAmpPanel.setName("preAmpPanel");
            this.preAmpPanel.setLayout(new GridBagLayout());
            this.preAmpPanel.setBorder(new TitledBorder(null, "Pre Amp", 4, 0, Helpers.getDialogFont(), null));
            this.preAmpSlider = this.createDefaultSlider(this.eq.getPreAmpDB());
            this.preAmpSlider.setName("PreAmp");
            this.preAmpSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider slider = (JSlider)e.getSource();
                    int value = slider.getValue();
                    GraphicEqGUI.this.eq.setPreAmp((float)value / 100.0f);
                    slider.setToolTipText(Float.toString((float)Math.round(GraphicEqGUI.this.eq.getPreAmpDB() * 10.0f) / 10.0f) + GraphicEqGUI.DEZIBEL);
                }
            });
            this.preAmpSliderLable = new JLabel("PreAmp");
            this.preAmpSliderLable.setFont(Helpers.getDialogFont());
            this.preAmpPanel.add((Component)this.preAmpSlider, Helpers.getGridBagConstraint(0, 0, 1, 0, 3, 10, 0.0, 1.0));
            this.preAmpPanel.add((Component)this.preAmpSliderLable, Helpers.getGridBagConstraint(0, 1, 1, 0, 0, 10, 0.0, 0.0));
        }
        return this.preAmpPanel;
    }

    private void setPreset(int index) {
        int[] preset = PRESET_DB[index];
        for (int i = 0; i < preset.length; ++i) {
            this.sliders[i].setValue(preset[i] * 100);
        }
    }
}

