/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir.filter;

import de.quippy.javamod.mixer.dsp.iir.filter.IIRFilterBase;

public class IIRBandpassFilter
extends IIRFilterBase {
    @Override
    public void initialize(int sampleRate, int channels, int frequency, float parameter) {
        super.initialize(sampleRate, channels, frequency, parameter);
        float thetaZero = this.getThetaZero();
        float theTan = (float)Math.tan(thetaZero / (2.0f * parameter));
        this.beta = 0.5f * ((1.0f - theTan) / (1.0f + theTan));
        this.alpha = (0.5f - this.beta) / 2.0f;
        this.gamma = (0.5f + this.beta) * (float)Math.cos(thetaZero);
        this.alpha *= 2.0f;
        this.beta *= 2.0f;
        this.gamma *= 2.0f;
    }

    @Override
    protected float performFilterCalculation(float sample, int channel, int iIndex, int jIndex, int kIndex) {
        float[] x = this.inArray[channel];
        float[] y = this.outArray[channel];
        x[iIndex] = sample;
        y[iIndex] = this.alpha * (x[iIndex] - x[jIndex]) + this.gamma * y[kIndex] - this.beta * y[jIndex];
        return y[iIndex];
    }
}

