/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir.filter;

import de.quippy.javamod.mixer.dsp.iir.filter.IIRFilterBase;
import de.quippy.javamod.system.Helpers;

public class IIRFilter {
    private int channels;
    private int iIndex;
    private int jIndex;
    private int kIndex;
    private int sampleBufferSize;
    private int filterLength;
    private IIRFilterBase[] filters;
    private float preAmp;

    public IIRFilter(IIRFilterBase[] theFilters) {
        this.filters = theFilters;
        this.filterLength = theFilters.length;
        this.preAmp = 1.0f;
    }

    public void initialize(int channels, int sampleBufferSize) {
        this.channels = channels;
        this.sampleBufferSize = sampleBufferSize;
        this.clearHistory();
    }

    public void clearHistory() {
        for (int f = 0; f < this.filterLength; ++f) {
            this.filters[f].clearHistory();
        }
        this.iIndex = 0;
        this.jIndex = 1;
        this.kIndex = 2;
    }

    public float getBand(int index) {
        return this.filters[index].getGain();
    }

    public void setBand(int index, float newGain) {
        this.filters[index].setGain(newGain);
    }

    public float getPreAmp() {
        return (float)Helpers.getDBValueFrom(this.preAmp);
    }

    public void setPreAmp(float newPreAmpDB) {
        this.preAmp = (float)Helpers.getDecimalValueFrom(newPreAmpDB);
    }

    public IIRFilterBase[] getFilters() {
        return this.filters;
    }

    public int doFilter(float[] ringBuffer, int start, int length, int useBands) {
        float internalPreAmp = 1.0f / (float)useBands;
        float rest = 1.0f - internalPreAmp;
        int end = start + length;
        int index = start;
        while (index < end) {
            for (int c = 0; c < this.channels; ++c) {
                int sampleIndex = index++ % this.sampleBufferSize;
                float sample = 0.0f;
                float preAmpedSample = ringBuffer[sampleIndex] * this.preAmp * internalPreAmp;
                for (int f = 0; f < useBands; ++f) {
                    IIRFilterBase filter = this.filters[f];
                    sample += filter.performFilterCalculation(preAmpedSample, c, this.iIndex, this.jIndex, this.kIndex) * filter.amplitudeAdj;
                }
                ringBuffer[sampleIndex] = (sample += ringBuffer[sampleIndex] * rest) > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
            }
            this.iIndex = (this.iIndex + 1) % 3;
            this.jIndex = (this.jIndex + 1) % 3;
            this.kIndex = (this.kIndex + 1) % 3;
        }
        return length;
    }
}

